/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.servlet.mvc;

import com.stormpath.sdk.application.Application;
import com.stormpath.sdk.lang.Assert;
import com.stormpath.sdk.lang.Strings;
import com.stormpath.sdk.saml.SamlIdpUrlBuilder;
import com.stormpath.sdk.servlet.account.AccountResolver;
import com.stormpath.sdk.servlet.application.ApplicationResolver;
import com.stormpath.sdk.servlet.filter.ServerUriResolver;
import com.stormpath.sdk.servlet.http.Resolver;
import com.stormpath.sdk.servlet.mvc.AbstractController;
import com.stormpath.sdk.servlet.mvc.DefaultViewModel;
import com.stormpath.sdk.servlet.mvc.ViewModel;
import com.stormpath.sdk.servlet.saml.SamlOrganizationContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SamlController
extends AbstractController {
    private ServerUriResolver serverUriResolver;
    private String callbackUri;
    private String samlUri;
    private String alreadyLoggedInUri = "/";
    private Resolver<SamlOrganizationContext> samlOrganizationResolver;

    public void setServerUriResolver(ServerUriResolver serverUriResolver) {
        this.serverUriResolver = serverUriResolver;
    }

    public void setCallbackUri(String callbackUri) {
        this.callbackUri = callbackUri;
    }

    public void setAlreadyLoggedInUri(String alreadyLoggedInUri) {
        this.alreadyLoggedInUri = alreadyLoggedInUri;
    }

    public void setSamlUri(String samlUri) {
        this.samlUri = samlUri;
    }

    public void setSamlOrganizationResolver(Resolver<SamlOrganizationContext> samlOrganizationResolver) {
        this.samlOrganizationResolver = samlOrganizationResolver;
    }

    @Override
    public void init() {
        Assert.notNull((Object)this.serverUriResolver, (String)"Application must be configured.");
        Assert.notNull((Object)this.callbackUri, (String)"callbackUri must be configured.");
        Assert.notNull(this.samlOrganizationResolver, (String)"idSiteOrganizationResolver must be configured.");
    }

    @Override
    public boolean isNotAllowedIfAuthenticated() {
        return true;
    }

    @Override
    protected Application getApplication(HttpServletRequest request) {
        return ApplicationResolver.INSTANCE.getApplication((ServletRequest)request);
    }

    protected String buildCallbackUri(HttpServletRequest request) {
        String uri = this.serverUriResolver.getServerUri(request);
        String contextPath = request.getContextPath();
        if (contextPath == null || contextPath.equals("/")) {
            contextPath = "";
        }
        if (contextPath.endsWith("/")) {
            contextPath = contextPath.substring(0, contextPath.length() - 1);
        }
        uri = uri + contextPath + this.callbackUri;
        return uri;
    }

    @Override
    protected ViewModel doGet(HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (AccountResolver.INSTANCE.getAccount((ServletRequest)request) != null) {
            return new DefaultViewModel(this.alreadyLoggedInUri).setRedirect(true);
        }
        String samlUrl = this.createSamlUrl(request);
        response.setHeader("Cache-control", "no-cache, no-store");
        response.setHeader("Pragma", "no-cache");
        response.setHeader("Expires", "-1");
        return new DefaultViewModel(samlUrl).setRedirect(true);
    }

    protected String createSamlUrl(HttpServletRequest request) {
        SamlIdpUrlBuilder builder = this.createSamlIdpUrlBuilder(request);
        return builder.build();
    }

    protected SamlIdpUrlBuilder createSamlIdpUrlBuilder(HttpServletRequest request) {
        String nameKey;
        SamlOrganizationContext orgCtx;
        Application application = this.getApplication(request);
        String callbackUri = this.buildCallbackUri(request);
        SamlIdpUrlBuilder builder = application.newSamlIdpUrlBuilder().setCallbackUri(callbackUri);
        String ash = request.getParameter("href");
        if (ash != null) {
            builder.setAccountStoreHref(ash);
        }
        if ((orgCtx = this.samlOrganizationResolver.get(request, null)) != null && Strings.hasText((String)(nameKey = orgCtx.getOrganizationNameKey()))) {
            builder.setOrganizationNameKey(nameKey);
        }
        if (this.samlUri != null) {
            builder.setPath(this.samlUri);
        }
        return builder;
    }
}

