/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.servlet.mvc.provider;

import com.stormpath.sdk.application.Application;
import com.stormpath.sdk.application.ApplicationAccountStoreMapping;
import com.stormpath.sdk.application.ApplicationAccountStoreMappingCriteria;
import com.stormpath.sdk.application.ApplicationAccountStoreMappingList;
import com.stormpath.sdk.application.ApplicationAccountStoreMappings;
import com.stormpath.sdk.directory.AccountStore;
import com.stormpath.sdk.directory.AccountStoreVisitor;
import com.stormpath.sdk.directory.Directory;
import com.stormpath.sdk.group.Group;
import com.stormpath.sdk.organization.Organization;
import com.stormpath.sdk.provider.OAuthProvider;
import com.stormpath.sdk.provider.Provider;
import com.stormpath.sdk.provider.saml.SamlProvider;
import com.stormpath.sdk.servlet.application.ApplicationResolver;
import com.stormpath.sdk.servlet.mvc.provider.AccountStoreModel;
import com.stormpath.sdk.servlet.mvc.provider.AccountStoreModelFactory;
import com.stormpath.sdk.servlet.mvc.provider.DefaultAccountStoreModel;
import com.stormpath.sdk.servlet.mvc.provider.DefaultOAuthProviderModel;
import com.stormpath.sdk.servlet.mvc.provider.DefaultProviderModel;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;

public class ExternalAccountStoreModelFactory
implements AccountStoreModelFactory {
    @Override
    public List<AccountStoreModel> getAccountStores(HttpServletRequest request) {
        Application app = ApplicationResolver.INSTANCE.getApplication((ServletRequest)request);
        int pageSize = 100;
        ApplicationAccountStoreMappingCriteria criteria = (ApplicationAccountStoreMappingCriteria)ApplicationAccountStoreMappings.criteria().limitTo(pageSize);
        ApplicationAccountStoreMappingList mappings = app.getAccountStoreMappings(criteria);
        ArrayList<AccountStoreModel> accountStores = new ArrayList<AccountStoreModel>(mappings.getSize());
        AccountStoreModelVisitor visitor = new AccountStoreModelVisitor(accountStores);
        for (ApplicationAccountStoreMapping mapping : mappings) {
            AccountStore accountStore = mapping.getAccountStore();
            accountStore.accept((AccountStoreVisitor)visitor);
        }
        return visitor.getAccountStores();
    }

    private class AccountStoreModelVisitor
    implements AccountStoreVisitor {
        private final List<AccountStoreModel> accountStores;

        public AccountStoreModelVisitor(List<AccountStoreModel> accountStores) {
            this.accountStores = accountStores;
        }

        public void visit(Group group) {
        }

        public void visit(Directory directory) {
            Provider provider = directory.getProvider();
            DefaultProviderModel providerModel = null;
            if (provider instanceof OAuthProvider) {
                providerModel = new DefaultOAuthProviderModel((OAuthProvider)provider);
            } else if (provider instanceof SamlProvider) {
                providerModel = new DefaultProviderModel(provider);
            }
            if (providerModel != null) {
                DefaultAccountStoreModel accountStoreModel = new DefaultAccountStoreModel(directory, providerModel);
                this.accountStores.add(accountStoreModel);
            }
        }

        public void visit(Organization organization) {
        }

        public List<AccountStoreModel> getAccountStores() {
            return this.accountStores;
        }
    }
}

