/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.servlet.oauth.impl;

import com.stormpath.sdk.lang.Assert;
import com.stormpath.sdk.servlet.oauth.OAuthTokenResolver;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public abstract class AbstractOAuthTokenResolver
implements OAuthTokenResolver {
    protected abstract String getRequestAttributeName();

    @Override
    public boolean hasToken(ServletRequest request) {
        Assert.notNull((Object)request, (String)"ServletRequest argument cannot be null.");
        String token = this.findToken(request);
        return token != null;
    }

    @Override
    public String getToken(ServletRequest request) {
        Assert.notNull((Object)request, (String)"ServletRequest argument cannot be null.");
        return this.findToken(request);
    }

    @Override
    public String getRequiredToken(ServletRequest request) throws IllegalArgumentException {
        Assert.notNull((Object)request, (String)"ServletRequest argument cannot be null.");
        String token = this.findToken(request);
        Assert.notNull((Object)token, (String)"The current request does not reflect an authenticated user.  Call 'hasToken' to check if an authenticated user OAuth token exists before calling this method.");
        return token;
    }

    protected String findToken(ServletRequest request) {
        Object value = request.getAttribute(this.getRequestAttributeName());
        if (value == null) {
            Assert.isInstanceOf(HttpServletRequest.class, (Object)request, (String)"Only HttpServletRequests are supported.");
            HttpServletRequest req = (HttpServletRequest)request;
            HttpSession session = req.getSession(false);
            if (session != null) {
                value = session.getAttribute(this.getRequestAttributeName());
            }
        }
        if (value == null) {
            return null;
        }
        Assert.isInstanceOf(String.class, (Object)value, (String)(this.getRequestAttributeName() + " attribute must be a " + String.class.getName() + " instance."));
        return (String)value;
    }
}

