/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.servlet.util;

import com.stormpath.sdk.lang.Assert;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class RedirectUrlBuilder {
    public static final String DEFAULT_ENCODING_SCHEME = "UTF-8";
    private String url;
    private boolean contextRelative = false;
    private String encodingScheme = "UTF-8";
    private Map<String, Object> queryParameters;
    private final HttpServletRequest request;

    public RedirectUrlBuilder(HttpServletRequest request) {
        Assert.notNull((Object)request, (String)"Request argument cannot be null.");
        this.request = request;
    }

    public RedirectUrlBuilder setUrl(String url) {
        this.url = url;
        return this;
    }

    public RedirectUrlBuilder setContextRelative(boolean contextRelative) {
        this.contextRelative = contextRelative;
        return this;
    }

    public RedirectUrlBuilder setEncodingScheme(String encodingScheme) {
        this.encodingScheme = encodingScheme;
        return this;
    }

    public RedirectUrlBuilder setQueryParameters(Map<String, Object> params) {
        this.queryParameters = params;
        return this;
    }

    public String build() {
        StringBuilder targetUrl = new StringBuilder();
        if (this.contextRelative && this.url.startsWith("/")) {
            targetUrl.append(this.request.getContextPath());
        }
        targetUrl.append(this.url);
        try {
            this.appendQueryProperties(targetUrl);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("Specified encodingScheme is not valid: " + e.getMessage(), e);
        }
        return targetUrl.toString();
    }

    protected void appendQueryProperties(StringBuilder targetUrl) throws UnsupportedEncodingException {
        boolean first;
        String fragment = null;
        int anchorIndex = targetUrl.toString().indexOf(35);
        if (anchorIndex > -1) {
            fragment = targetUrl.substring(anchorIndex);
            targetUrl.delete(anchorIndex, targetUrl.length());
        }
        boolean bl = first = this.url.indexOf(63) < 0;
        if (this.queryParameters != null) {
            for (Map.Entry<String, Object> o : this.queryParameters.entrySet()) {
                if (first) {
                    targetUrl.append('?');
                    first = false;
                } else {
                    targetUrl.append('&');
                }
                Map.Entry<String, Object> entry = o;
                String encodedKey = this.urlEncode(entry.getKey().toString());
                String encodedValue = entry.getValue() != null ? this.urlEncode(entry.getValue().toString()) : "";
                targetUrl.append(encodedKey).append('=').append(encodedValue);
            }
        }
        if (fragment != null) {
            targetUrl.append(fragment);
        }
    }

    protected String urlEncode(String input) {
        try {
            return URLEncoder.encode(input, this.encodingScheme);
        }
        catch (UnsupportedEncodingException e) {
            String msg = "Unsupported character encoding '" + this.encodingScheme + "': " + e.getMessage();
            throw new IllegalArgumentException(msg, e);
        }
    }
}

