/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.servlet.util;

import com.stormpath.sdk.lang.Strings;
import com.stormpath.sdk.servlet.http.Resolver;
import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class RemoteAddrResolver
implements Resolver<String> {
    private static final List<String> REMOTE_ADDR_HEADERS = Arrays.asList("X-Forwarded-For", "Proxy-Client-IP", "WL-Proxy-Client-IP", "HTTP_CLIENT_IP", "HTTP_X_FORWARDED_FOR");

    @Override
    public String get(HttpServletRequest request, HttpServletResponse response) {
        return this.getRemoteAddr(request);
    }

    protected String getRemoteAddr(HttpServletRequest request) {
        String ip = null;
        for (String headerName : REMOTE_ADDR_HEADERS) {
            ip = request.getHeader(headerName);
            if (ip == null) continue;
            int i = ip.indexOf(44);
            if (i != -1) {
                ip = Strings.clean((String)ip.substring(0, i));
            }
            if (!this.isValidIp(ip)) continue;
            break;
        }
        if (!this.isValidIp(ip)) {
            ip = request.getRemoteAddr();
        }
        return ip;
    }

    protected boolean isValidIp(String ip) {
        return Strings.hasText((String)ip) && !"unknown".equalsIgnoreCase(ip);
    }
}

