/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.servlet.util;

import com.stormpath.sdk.lang.Strings;
import com.stormpath.sdk.servlet.util.RedirectUrlBuilder;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServletUtils {
    private static final Logger log = LoggerFactory.getLogger(ServletUtils.class);
    public static final String INCLUDE_REQUEST_URI_ATTRIBUTE = "javax.servlet.include.request_uri";
    public static final String INCLUDE_CONTEXT_PATH_ATTRIBUTE = "javax.servlet.include.context_path";
    public static final String INCLUDE_SERVLET_PATH_ATTRIBUTE = "javax.servlet.include.servlet_path";
    public static final String INCLUDE_PATH_INFO_ATTRIBUTE = "javax.servlet.include.path_info";
    public static final String INCLUDE_QUERY_STRING_ATTRIBUTE = "javax.servlet.include.query_string";
    public static final String FORWARD_REQUEST_URI_ATTRIBUTE = "javax.servlet.forward.request_uri";
    public static final String FORWARD_CONTEXT_PATH_ATTRIBUTE = "javax.servlet.forward.context_path";
    public static final String FORWARD_SERVLET_PATH_ATTRIBUTE = "javax.servlet.forward.servlet_path";
    public static final String FORWARD_PATH_INFO_ATTRIBUTE = "javax.servlet.forward.path_info";
    public static final String FORWARD_QUERY_STRING_ATTRIBUTE = "javax.servlet.forward.query_string";
    public static final String DEFAULT_CHARACTER_ENCODING = "ISO-8859-1";

    public static String getContextRelativeUri(HttpServletRequest request) {
        String contextPath = ServletUtils.getContextPath(request);
        String requestUri = ServletUtils.getRequestUri(request);
        if (Strings.startsWithIgnoreCase((String)requestUri, (String)contextPath)) {
            String contextRelativeUri = requestUri.substring(contextPath.length());
            return Strings.hasText((String)contextRelativeUri) ? contextRelativeUri : "/";
        }
        return requestUri;
    }

    public static String getRequestUri(HttpServletRequest request) {
        String uri = (String)request.getAttribute(INCLUDE_REQUEST_URI_ATTRIBUTE);
        if (uri == null) {
            uri = request.getRequestURI();
        }
        return ServletUtils.normalize(ServletUtils.decodeAndCleanUriString(request, uri));
    }

    public static String normalize(String path) {
        return ServletUtils.normalize(path, true);
    }

    private static String normalize(String path, boolean replaceBackSlash) {
        int index;
        if (path == null) {
            return null;
        }
        String normalized = path;
        if (replaceBackSlash && normalized.indexOf(92) >= 0) {
            normalized = normalized.replace('\\', '/');
        }
        if (normalized.equals("/.")) {
            return "/";
        }
        if (!normalized.startsWith("/")) {
            normalized = "/" + normalized;
        }
        while ((index = normalized.indexOf("//")) >= 0) {
            normalized = normalized.substring(0, index) + normalized.substring(index + 1);
        }
        while ((index = normalized.indexOf("/./")) >= 0) {
            normalized = normalized.substring(0, index) + normalized.substring(index + 2);
        }
        while ((index = normalized.indexOf("/../")) >= 0) {
            if (index == 0) {
                return null;
            }
            int index2 = normalized.lastIndexOf(47, index - 1);
            normalized = normalized.substring(0, index2) + normalized.substring(index + 3);
        }
        return normalized;
    }

    public static String decodeAndCleanUriString(HttpServletRequest request, String uri) {
        int semicolonIndex = (uri = ServletUtils.decodeRequestString(request, uri)).indexOf(59);
        return semicolonIndex != -1 ? uri.substring(0, semicolonIndex) : uri;
    }

    public static String getContextPath(HttpServletRequest request) {
        String contextPath = (String)request.getAttribute(INCLUDE_CONTEXT_PATH_ATTRIBUTE);
        if (contextPath == null) {
            contextPath = request.getContextPath();
        }
        if ("/".equals(contextPath)) {
            contextPath = "";
        }
        return ServletUtils.decodeRequestString(request, contextPath);
    }

    public static String decodeRequestString(HttpServletRequest request, String source) {
        String enc = ServletUtils.determineEncoding(request);
        try {
            return URLDecoder.decode(source, enc);
        }
        catch (UnsupportedEncodingException ex) {
            log.warn("Could not decode request string [{}] with encoding '{}': falling back to platform default encoding; exception message: {}", new Object[]{source, enc, ex.getMessage(), ex});
            try {
                return URLDecoder.decode(source, DEFAULT_CHARACTER_ENCODING);
            }
            catch (UnsupportedEncodingException e) {
                String msg = "ISO-8859-1 encoding is not available as a fallback." + e.getMessage();
                throw new IllegalStateException(msg, e);
            }
        }
    }

    protected static String determineEncoding(HttpServletRequest request) {
        String enc = request.getCharacterEncoding();
        if (enc == null) {
            enc = DEFAULT_CHARACTER_ENCODING;
        }
        return enc;
    }

    public static void issueRedirect(HttpServletRequest request, HttpServletResponse response, String url, Map queryParams, boolean contextRelative, boolean http10Compatible) throws IOException {
        String targetUrl = new RedirectUrlBuilder(request).setUrl(url).setQueryParameters(queryParams).setContextRelative(contextRelative).build();
        if (http10Compatible) {
            response.sendRedirect(response.encodeRedirectURL(targetUrl));
        } else {
            response.setStatus(303);
            response.setHeader("Location", response.encodeRedirectURL(targetUrl));
        }
    }

    public static void issueRedirect(HttpServletRequest request, HttpServletResponse response, String url) throws IOException {
        ServletUtils.issueRedirect(request, response, url, null, true, true);
    }

    public static void issueRedirect(HttpServletRequest request, HttpServletResponse response, String url, Map queryParams) throws IOException {
        ServletUtils.issueRedirect(request, response, url, queryParams, true, true);
    }

    public static void issueRedirect(HttpServletRequest request, HttpServletResponse response, String url, Map queryParams, boolean contextRelative) throws IOException {
        ServletUtils.issueRedirect(request, response, url, queryParams, contextRelative, true);
    }

    public static boolean isTrue(ServletRequest request, String paramName) {
        String value = ServletUtils.getCleanParam(request, paramName);
        return value != null && (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("t") || value.equalsIgnoreCase("1") || value.equalsIgnoreCase("enabled") || value.equalsIgnoreCase("y") || value.equalsIgnoreCase("yes") || value.equalsIgnoreCase("on"));
    }

    public static String getCleanParam(ServletRequest request, String paramName) {
        return Strings.clean((String)request.getParameter(paramName));
    }
}

