/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.sdk.servlet.util;

import com.stormpath.sdk.lang.Collections;
import com.stormpath.sdk.lang.Strings;
import com.stormpath.sdk.servlet.http.Resolver;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SubdomainResolver
implements Resolver<List<String>> {
    private String baseDomainName;

    public void setBaseDomainName(String baseDomainName) {
        this.baseDomainName = baseDomainName;
    }

    @Override
    public List<String> get(HttpServletRequest request, HttpServletResponse response) {
        String host = this.getHost(request);
        if (host == null) {
            return java.util.Collections.emptyList();
        }
        host = host.toLowerCase(Locale.ENGLISH);
        String base = this.baseDomainName;
        if (host.endsWith("localhost")) {
            base = "localhost";
        } else if (host.endsWith("localdomain")) {
            base = "localdomain";
        }
        List<String> domainTokens = this.toDomainTokens(host);
        if (Collections.isEmpty(domainTokens)) {
            return domainTokens;
        }
        int domainTokensSize = domainTokens.size();
        if (Strings.hasText((String)base)) {
            String[] baseTokens = this.tokenize(base);
            int sizeDiff = domainTokensSize - baseTokens.length;
            for (int i = domainTokensSize - 1; i >= sizeDiff; --i) {
                String baseToken = baseTokens[i - sizeDiff];
                String domainToken = domainTokens.get(i);
                if (baseToken.equalsIgnoreCase(domainToken)) continue;
                return java.util.Collections.emptyList();
            }
            domainTokens = domainTokens.subList(0, sizeDiff);
        } else {
            if (domainTokens.size() <= 2) {
                return java.util.Collections.emptyList();
            }
            domainTokens = domainTokens.subList(0, domainTokens.size() - 2);
        }
        return domainTokens;
    }

    private String[] tokenize(String s) {
        return Strings.tokenizeToStringArray((String)s, (String)".");
    }

    protected List<String> toDomainTokens(String s) {
        StringBuilder sb = new StringBuilder();
        boolean isIPV4 = true;
        boolean isIPV6 = true;
        ArrayList<String> tokens = new ArrayList<String>();
        for (char c : s.toCharArray()) {
            if (c == '.') {
                if (sb.length() > 0) {
                    String token = sb.toString();
                    tokens.add(token);
                    sb = new StringBuilder();
                }
            } else {
                sb.append(c);
            }
            if (c >= '0' && c <= '9') continue;
            if (c != '.') {
                isIPV4 = false;
            } else {
                isIPV6 = false;
            }
            if (c >= 'a' && c <= 'f') continue;
            if (c != ':') {
                isIPV6 = false;
                continue;
            }
            isIPV4 = false;
        }
        if (isIPV4 || isIPV6) {
            return java.util.Collections.emptyList();
        }
        if (sb.length() > 0) {
            String token = sb.toString();
            tokens.add(token);
        }
        return tokens;
    }

    protected String getHost(HttpServletRequest request) {
        String host = request.getHeader("Host");
        if (host == null) {
            host = request.getServerName();
        }
        if (host.startsWith("[")) {
            return null;
        }
        int i = host.lastIndexOf(58);
        if (i > -1) {
            host = host.substring(0, i);
        }
        return host;
    }
}

