/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.encryption;

import com.structurizr.encryption.EncryptionStrategy;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.bind.DatatypeConverter;

public final class AesEncryptionStrategy
extends EncryptionStrategy {
    private static final String CIPHER_SPECIFICATION = "AES/CBC/PKCS5PADDING";
    private static final int INITIALIZATION_VECTOR_SIZE_IN_BYTES = 16;
    private int keySize;
    private int iterationCount;
    private String salt;
    private String iv;

    AesEncryptionStrategy() {
    }

    public AesEncryptionStrategy(String passphrase) {
        this(128, 1000, passphrase);
    }

    public AesEncryptionStrategy(int keySize, int iterationCount, String passphrase) {
        super(passphrase);
        this.keySize = keySize;
        this.iterationCount = iterationCount;
        byte[] saltAsBytes = new byte[keySize / 8];
        SecureRandom secureRandom = new SecureRandom();
        secureRandom.nextBytes(saltAsBytes);
        this.salt = DatatypeConverter.printHexBinary((byte[])saltAsBytes);
        byte[] ivAsBytes = new byte[16];
        SecureRandom prng = new SecureRandom();
        prng.nextBytes(ivAsBytes);
        this.iv = DatatypeConverter.printHexBinary((byte[])ivAsBytes);
    }

    public AesEncryptionStrategy(int keySize, int iterationCount, String salt, String iv, String passphrase) {
        super(passphrase);
        this.keySize = keySize;
        this.iterationCount = iterationCount;
        this.salt = salt;
        this.iv = iv;
    }

    @Override
    public String encrypt(String plaintext) throws Exception {
        SecretKey secretKey = this.createSecretKey();
        Cipher cipher = Cipher.getInstance(CIPHER_SPECIFICATION);
        cipher.init(1, (Key)secretKey, new IvParameterSpec(DatatypeConverter.parseHexBinary((String)this.iv)));
        byte[] byteDataToEncrypt = plaintext.getBytes();
        byte[] byteCipherText = cipher.doFinal(byteDataToEncrypt);
        return Base64.getEncoder().encodeToString(byteCipherText);
    }

    @Override
    public String decrypt(String ciphertext) throws Exception {
        SecretKey secretKey = this.createSecretKey();
        Cipher cipher = Cipher.getInstance(CIPHER_SPECIFICATION);
        cipher.init(2, (Key)secretKey, new IvParameterSpec(DatatypeConverter.parseHexBinary((String)this.iv)));
        byte[] unencrypted = cipher.doFinal(Base64.getDecoder().decode(ciphertext));
        return new String(unencrypted, "UTF-8");
    }

    private SecretKey createSecretKey() throws NoSuchAlgorithmException, InvalidKeySpecException {
        SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
        PBEKeySpec spec = new PBEKeySpec(this.getPassphrase().toCharArray(), DatatypeConverter.parseHexBinary((String)this.salt), this.iterationCount, this.keySize);
        return new SecretKeySpec(factory.generateSecret(spec).getEncoded(), "AES");
    }

    public int getKeySize() {
        return this.keySize;
    }

    public int getIterationCount() {
        return this.iterationCount;
    }

    public String getSalt() {
        return this.salt;
    }

    public String getIv() {
        return this.iv;
    }
}

