/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.component;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.el.ELException;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.application.Application;
import javax.faces.application.FacesMessage;
import javax.faces.component.AttachedObjectListHolder;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.MessageFactory;
import javax.faces.component.MethodBindingValidator;
import javax.faces.component.MethodBindingValueChangeListener;
import javax.faces.component.UIComponent;
import javax.faces.component.UIOutput;
import javax.faces.component.UpdateModelException;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.el.MethodBinding;
import javax.faces.event.ExceptionQueuedEvent;
import javax.faces.event.ExceptionQueuedEventContext;
import javax.faces.event.PhaseId;
import javax.faces.event.ValueChangeEvent;
import javax.faces.event.ValueChangeListener;
import javax.faces.render.Renderer;
import javax.faces.validator.BeanValidator;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UIInput
extends UIOutput
implements EditableValueHolder {
    private static Logger LOGGER = Logger.getLogger("javax.faces.component", "javax.faces.LogStrings");
    public static final String COMPONENT_TYPE = "javax.faces.Input";
    public static final String COMPONENT_FAMILY = "javax.faces.Input";
    public static final String CONVERSION_MESSAGE_ID = "javax.faces.component.UIInput.CONVERSION";
    public static final String REQUIRED_MESSAGE_ID = "javax.faces.component.UIInput.REQUIRED";
    public static final String UPDATE_MESSAGE_ID = "javax.faces.component.UIInput.UPDATE";
    public static final String VALIDATE_EMPTY_FIELDS_PARAM_NAME = "javax.faces.VALIDATE_EMPTY_FIELDS";
    public static final String DEFAULT_VALIDATOR_IDS_KEY = "javax.faces.component.DEFAULT_VALIDATOR_IDS";
    private static final Validator[] EMPTY_VALIDATOR = new Validator[0];
    private Boolean emptyStringIsNull;
    private Boolean validateEmptyFields;
    private boolean defaultValidatorsProcessed;
    private Object submittedValue = null;
    AttachedObjectListHolder<Validator> validators;
    private Object[] values;

    public UIInput() {
        this.setRendererType("javax.faces.Text");
    }

    @Override
    public String getFamily() {
        return "javax.faces.Input";
    }

    @Override
    public Object getSubmittedValue() {
        return this.submittedValue;
    }

    @Override
    public void setSubmittedValue(Object submittedValue) {
        this.submittedValue = submittedValue;
    }

    @Override
    public void setValue(Object value) {
        super.setValue(value);
        this.setLocalValueSet(true);
    }

    @Override
    public void resetValue() {
        this.setValue(null);
        this.setSubmittedValue(null);
        this.setLocalValueSet(false);
        this.setValid(true);
    }

    @Override
    public boolean isLocalValueSet() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.localValueSet), false);
    }

    @Override
    public void setLocalValueSet(boolean localValueSet) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.localValueSet), localValueSet);
    }

    @Override
    public boolean isRequired() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.required), false);
    }

    public String getRequiredMessage() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.requiredMessage));
    }

    public void setRequiredMessage(String message) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.requiredMessage), message);
    }

    public String getConverterMessage() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.converterMessage));
    }

    public void setConverterMessage(String message) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.converterMessage), message);
    }

    public String getValidatorMessage() {
        return (String)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.validatorMessage));
    }

    public void setValidatorMessage(String message) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.validatorMessage), message);
    }

    @Override
    public boolean isValid() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.valid), true);
    }

    @Override
    public void setValid(boolean valid) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.valid), valid);
    }

    @Override
    public void setRequired(boolean required) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.required), required);
    }

    @Override
    public boolean isImmediate() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.immediate), false);
    }

    @Override
    public void setImmediate(boolean immediate) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.immediate), immediate);
    }

    @Override
    public MethodBinding getValidator() {
        MethodBinding result = null;
        Validator[] curValidators = this.getValidators();
        if (null != curValidators) {
            for (int i = 0; i < curValidators.length; ++i) {
                if (MethodBindingValidator.class != curValidators[i].getClass()) continue;
                result = ((MethodBindingValidator)curValidators[i]).getWrapped();
                break;
            }
        }
        return result;
    }

    @Override
    public void setValidator(MethodBinding validatorBinding) {
        Validator[] curValidators = this.getValidators();
        if (null != curValidators) {
            for (int i = 0; i < curValidators.length; ++i) {
                if (null == validatorBinding) {
                    if (MethodBindingValidator.class != curValidators[i].getClass()) continue;
                    this.removeValidator(curValidators[i]);
                    return;
                }
                if (validatorBinding != curValidators[i]) continue;
                this.removeValidator(curValidators[i]);
                break;
            }
        }
        this.addValidator(new MethodBindingValidator(validatorBinding));
    }

    @Override
    public MethodBinding getValueChangeListener() {
        MethodBinding result = null;
        ValueChangeListener[] curListeners = this.getValueChangeListeners();
        if (null != curListeners) {
            for (int i = 0; i < curListeners.length; ++i) {
                if (MethodBindingValueChangeListener.class != curListeners[i].getClass()) continue;
                result = ((MethodBindingValueChangeListener)curListeners[i]).getWrapped();
                break;
            }
        }
        return result;
    }

    @Override
    public void setValueChangeListener(MethodBinding valueChangeListener) {
        ValueChangeListener[] curListeners = this.getValueChangeListeners();
        if (null != curListeners) {
            for (int i = 0; i < curListeners.length; ++i) {
                if (null == valueChangeListener) {
                    if (MethodBindingValueChangeListener.class != curListeners[i].getClass()) continue;
                    this.removeFacesListener(curListeners[i]);
                    return;
                }
                if (valueChangeListener != curListeners[i]) continue;
                this.removeFacesListener(curListeners[i]);
                break;
            }
        }
        this.addValueChangeListener(new MethodBindingValueChangeListener(valueChangeListener));
    }

    @Override
    public void markInitialState() {
        this.addDefaultValidators(FacesContext.getCurrentInstance());
        super.markInitialState();
        if (this.validators != null) {
            this.validators.markInitialState();
        }
    }

    @Override
    public void clearInitialState() {
        if (this.initialStateMarked()) {
            super.clearInitialState();
            if (this.validators != null) {
                this.validators.clearInitialState();
            }
        }
    }

    @Override
    public void encodeEnd(FacesContext context) throws IOException {
        super.encodeEnd(context);
        this.addDefaultValidators(context);
    }

    @Override
    public void processDecodes(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (!this.isRendered()) {
            return;
        }
        super.processDecodes(context);
        if (this.isImmediate()) {
            this.executeValidate(context);
        }
    }

    @Override
    public void processValidators(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (!this.isRendered()) {
            return;
        }
        super.processValidators(context);
        if (!this.isImmediate()) {
            this.executeValidate(context);
        }
    }

    @Override
    public void processUpdates(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (!this.isRendered()) {
            return;
        }
        super.processUpdates(context);
        try {
            this.updateModel(context);
        }
        catch (RuntimeException e) {
            context.renderResponse();
            throw e;
        }
        if (!this.isValid()) {
            context.renderResponse();
        }
    }

    @Override
    public void decode(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        this.setValid(true);
        super.decode(context);
    }

    public void updateModel(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (!this.isValid() || !this.isLocalValueSet()) {
            return;
        }
        ValueExpression ve = this.getValueExpression("value");
        if (ve != null) {
            Throwable caught = null;
            FacesMessage message = null;
            try {
                ve.setValue(context.getELContext(), this.getLocalValue());
                this.setValue(null);
                this.setLocalValueSet(false);
            }
            catch (ELException e) {
                caught = e;
                String messageStr = e.getMessage();
                for (Throwable result = e.getCause(); null != result && result.getClass().isAssignableFrom(ELException.class); result = result.getCause()) {
                    messageStr = result.getMessage();
                }
                message = null == messageStr ? MessageFactory.getMessage(context, UPDATE_MESSAGE_ID, MessageFactory.getLabel(context, this)) : new FacesMessage(FacesMessage.SEVERITY_ERROR, messageStr, messageStr);
                this.setValid(false);
            }
            catch (Exception e) {
                caught = e;
                message = MessageFactory.getMessage(context, UPDATE_MESSAGE_ID, MessageFactory.getLabel(context, this));
                this.setValid(false);
            }
            if (caught != null) {
                assert (message != null);
                UpdateModelException toQueue = new UpdateModelException(message, caught);
                ExceptionQueuedEventContext eventContext = new ExceptionQueuedEventContext(context, toQueue, this, PhaseId.UPDATE_MODEL_VALUES);
                context.getApplication().publishEvent(ExceptionQueuedEvent.class, eventContext);
            }
        }
    }

    public void validate(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        Object submittedValue = this.getSubmittedValue();
        if (submittedValue == null) {
            return;
        }
        if (this.considerEmptyStringNull(context) && submittedValue instanceof String && ((String)submittedValue).length() == 0) {
            this.setSubmittedValue(null);
            submittedValue = null;
        }
        Object newValue = null;
        try {
            newValue = this.getConvertedValue(context, submittedValue);
        }
        catch (ConverterException ce) {
            this.addConversionErrorMessage(context, ce);
            this.setValid(false);
        }
        this.validateValue(context, newValue);
        if (this.isValid()) {
            Object previous = this.getValue();
            this.setValue(newValue);
            this.setSubmittedValue(null);
            if (this.compareValues(previous, newValue)) {
                this.queueEvent(new ValueChangeEvent(this, previous, newValue));
            }
        }
    }

    protected Object getConvertedValue(FacesContext context, Object newSubmittedValue) throws ConverterException {
        Converter converter;
        Renderer renderer = this.getRenderer(context);
        Object newValue = renderer != null ? renderer.getConvertedValue(context, this, newSubmittedValue) : (newSubmittedValue instanceof String ? ((converter = this.getConverterWithType(context)) != null ? converter.getAsObject(context, this, (String)newSubmittedValue) : newSubmittedValue) : newSubmittedValue);
        return newValue;
    }

    protected void validateValue(FacesContext context, Object newValue) {
        if (this.isValid() && this.isRequired() && UIInput.isEmpty(newValue)) {
            String requiredMessageStr = this.getRequiredMessage();
            FacesMessage message = null != requiredMessageStr ? new FacesMessage(FacesMessage.SEVERITY_ERROR, requiredMessageStr, requiredMessageStr) : MessageFactory.getMessage(context, REQUIRED_MESSAGE_ID, MessageFactory.getLabel(context, this));
            context.addMessage(this.getClientId(context), message);
            this.setValid(false);
        }
        if (this.isValid() && (!UIInput.isEmpty(newValue) || this.validateEmptyFields(context)) && this.validators != null) {
            Validator[] validators;
            for (Validator validator : validators = this.validators.asArray(Validator.class)) {
                try {
                    validator.validate(context, this, newValue);
                }
                catch (ValidatorException ve) {
                    FacesMessage message;
                    this.setValid(false);
                    String validatorMessageString = this.getValidatorMessage();
                    if (null != validatorMessageString) {
                        message = new FacesMessage(FacesMessage.SEVERITY_ERROR, validatorMessageString, validatorMessageString);
                        message.setSeverity(FacesMessage.SEVERITY_ERROR);
                    } else {
                        Collection<FacesMessage> messages = ve.getFacesMessages();
                        if (null != messages) {
                            message = null;
                            Iterator<FacesMessage> iter = messages.iterator();
                            while (iter.hasNext()) {
                                context.addMessage(this.getClientId(context), iter.next());
                            }
                        } else {
                            message = ve.getFacesMessage();
                        }
                    }
                    if (message == null) continue;
                    context.addMessage(this.getClientId(context), message);
                }
            }
        }
    }

    protected boolean compareValues(Object previous, Object value) {
        if (previous == null) {
            return value != null;
        }
        if (value == null) {
            return true;
        }
        return !previous.equals(value);
    }

    private void executeValidate(FacesContext context) {
        try {
            this.validate(context);
        }
        catch (RuntimeException e) {
            context.renderResponse();
            throw e;
        }
        if (!this.isValid()) {
            context.validationFailed();
            context.renderResponse();
        }
    }

    public static boolean isEmpty(Object value) {
        if (value == null) {
            return true;
        }
        if (value instanceof String && ((String)value).length() < 1) {
            return true;
        }
        return value.getClass().isArray() ? 0 == Array.getLength(value) : value instanceof List && ((List)value).isEmpty();
    }

    @Override
    public void addValidator(Validator validator) {
        if (validator == null) {
            throw new NullPointerException();
        }
        if (this.validators == null) {
            this.validators = new AttachedObjectListHolder();
        }
        this.validators.add(validator);
    }

    @Override
    public Validator[] getValidators() {
        return this.validators != null ? this.validators.asArray(Validator.class) : EMPTY_VALIDATOR;
    }

    @Override
    public void removeValidator(Validator validator) {
        if (validator == null) {
            return;
        }
        if (this.validators != null) {
            this.validators.remove(validator);
        }
    }

    @Override
    public void addValueChangeListener(ValueChangeListener listener) {
        this.addFacesListener(listener);
    }

    @Override
    public ValueChangeListener[] getValueChangeListeners() {
        return (ValueChangeListener[])this.getFacesListeners(ValueChangeListener.class);
    }

    @Override
    public void removeValueChangeListener(ValueChangeListener listener) {
        this.removeFacesListener(listener);
    }

    @Override
    public Object saveState(FacesContext context) {
        if (this.values == null) {
            this.values = new Object[5];
        }
        this.values[0] = super.saveState(context);
        this.values[1] = this.emptyStringIsNull;
        this.values[2] = this.validateEmptyFields;
        this.values[3] = this.defaultValidatorsProcessed;
        this.values[4] = this.validators != null ? this.validators.saveState(context) : null;
        return this.values;
    }

    @Override
    public void restoreState(FacesContext context, Object state) {
        this.values = (Object[])state;
        super.restoreState(context, this.values[0]);
        this.emptyStringIsNull = (Boolean)this.values[1];
        this.validateEmptyFields = (Boolean)this.values[2];
        this.defaultValidatorsProcessed = (Boolean)this.values[3];
        if (this.values[4] != null) {
            if (this.validators == null) {
                this.validators = new AttachedObjectListHolder();
            }
            this.validators.restoreState(context, this.values[4]);
        }
    }

    private Converter getConverterWithType(FacesContext context) {
        Class converterType;
        Converter converter = this.getConverter();
        if (converter != null) {
            return converter;
        }
        ValueExpression valueExpression = this.getValueExpression("value");
        if (valueExpression == null) {
            return null;
        }
        try {
            converterType = valueExpression.getType(context.getELContext());
        }
        catch (ELException e) {
            throw new FacesException(e);
        }
        if (converterType == null || converterType == String.class || converterType == Object.class) {
            return null;
        }
        try {
            Application application = context.getApplication();
            return application.createConverter(converterType);
        }
        catch (Exception e) {
            return null;
        }
    }

    private void addConversionErrorMessage(FacesContext context, ConverterException ce) {
        FacesMessage message;
        String converterMessageString = this.getConverterMessage();
        if (null != converterMessageString) {
            message = new FacesMessage(FacesMessage.SEVERITY_ERROR, converterMessageString, converterMessageString);
        } else {
            message = ce.getFacesMessage();
            if (message == null && (message = MessageFactory.getMessage(context, CONVERSION_MESSAGE_ID, new Object[0])).getDetail() == null) {
                message.setDetail(ce.getMessage());
            }
        }
        context.addMessage(this.getClientId(context), message);
    }

    private boolean considerEmptyStringNull(FacesContext ctx) {
        if (this.emptyStringIsNull == null) {
            String val = ctx.getExternalContext().getInitParameter("javax.faces.INTERPRET_EMPTY_STRING_SUBMITTED_VALUES_AS_NULL");
            this.emptyStringIsNull = Boolean.valueOf(val);
        }
        return this.emptyStringIsNull;
    }

    private boolean validateEmptyFields(FacesContext ctx) {
        if (this.validateEmptyFields == null) {
            ExternalContext extCtx = ctx.getExternalContext();
            String val = extCtx.getInitParameter(VALIDATE_EMPTY_FIELDS_PARAM_NAME);
            if (null == val) {
                val = (String)extCtx.getApplicationMap().get(VALIDATE_EMPTY_FIELDS_PARAM_NAME);
            }
            this.validateEmptyFields = val == null || val.equals("auto") ? Boolean.valueOf(this.isBeansValidationAvailable(ctx)) : Boolean.valueOf(val);
        }
        return this.validateEmptyFields;
    }

    private boolean isBeansValidationAvailable(FacesContext context) {
        boolean result = false;
        String beansValidationAvailabilityCacheKey = "javax.faces.BEANS_VALIDATION_AVAILABLE";
        Map<String, Object> appMap = context.getExternalContext().getApplicationMap();
        if (appMap.containsKey("javax.faces.BEANS_VALIDATION_AVAILABLE")) {
            result = (Boolean)appMap.get("javax.faces.BEANS_VALIDATION_AVAILABLE");
        } else {
            try {
                new BeanValidator();
                result = true;
                appMap.put("javax.faces.BEANS_VALIDATION_AVAILABLE", true);
            }
            catch (Throwable t) {
                appMap.put("javax.faces.BEANS_VALIDATION_AVAILABLE", Boolean.FALSE);
            }
        }
        return result;
    }

    private void addDefaultValidators(FacesContext context) {
        if (!this.defaultValidatorsProcessed) {
            Set exclusions;
            Validator[] validators = this.getValidators();
            if (validators.length != 0) {
                exclusions = new HashSet(validators.length, 1.0f);
                for (Validator v : validators) {
                    exclusions.add(v.getClass().getName());
                }
            } else {
                exclusions = Collections.emptySet();
            }
            ArrayList<String> defaultValidatorIds = new ArrayList<String>();
            Map<String, String> defaultValidatorInfo = context.getApplication().getDefaultValidatorInfo();
            if (!defaultValidatorInfo.isEmpty()) {
                for (Map.Entry<String, String> valInfo : defaultValidatorInfo.entrySet()) {
                    defaultValidatorIds.add(valInfo.getKey());
                }
            }
            this.collectDefaultValidatorIds(defaultValidatorIds, this);
            for (String validatorId : defaultValidatorIds) {
                String defaultValClassName = defaultValidatorInfo.get(validatorId);
                if (exclusions.contains(defaultValClassName)) continue;
                this.addValidator(context.getApplication().createValidator(validatorId));
            }
            this.defaultValidatorsProcessed = true;
        }
    }

    private void collectDefaultValidatorIds(List<String> defaultValidatorIds, UIComponent component) {
        Object branchState = component.getAttributes().get(DEFAULT_VALIDATOR_IDS_KEY);
        if (branchState instanceof List) {
            if (defaultValidatorIds.isEmpty()) {
                defaultValidatorIds.addAll((List)branchState);
            } else {
                for (String validatorId : (List)branchState) {
                    if (defaultValidatorIds.contains(validatorId)) continue;
                    defaultValidatorIds.add(0, validatorId);
                }
            }
            return;
        }
        if (component.getParent() != null) {
            this.collectDefaultValidatorIds(defaultValidatorIds, component.getParent());
        }
        if (branchState instanceof Map) {
            Map validatorIdStates = (Map)branchState;
            for (Map.Entry e : validatorIdStates.entrySet()) {
                if (((Boolean)e.getValue()).booleanValue()) {
                    if (defaultValidatorIds.contains(e.getKey())) continue;
                    defaultValidatorIds.add(0, (String)e.getKey());
                    continue;
                }
                defaultValidatorIds.remove(e.getKey());
            }
        }
        component.getAttributes().put(DEFAULT_VALIDATOR_IDS_KEY, new ArrayList<String>(defaultValidatorIds));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum PropertyKeys {
        localValueSet,
        required,
        requiredMessage,
        converterMessage,
        validatorMessage,
        valid,
        immediate;

    }
}

