/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web.connector.grizzly;

import com.sun.enterprise.web.connector.grizzly.SelectorFactory;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;

public class ByteBufferInputStream
extends InputStream {
    private static int defaultReadTimeout = 15000;
    protected ByteBuffer byteBuffer;
    protected SelectionKey key = null;
    protected int readTimeout = defaultReadTimeout;
    protected int readTry = 2;

    public ByteBufferInputStream() {
    }

    public ByteBufferInputStream(ByteBuffer byteBuffer) {
        this.byteBuffer = byteBuffer;
    }

    public void setByteBuffer(ByteBuffer byteBuffer) {
        this.byteBuffer = byteBuffer;
    }

    public ByteBuffer getByteBuffer() {
        return this.byteBuffer;
    }

    public int available() {
        return this.byteBuffer.remaining();
    }

    public void close() {
    }

    public boolean markSupported() {
        return false;
    }

    public int read() throws IOException {
        if (!this.byteBuffer.hasRemaining()) {
            int eof = 0;
            for (int i = 0; i < this.readTry && (eof = this.doRead()) == 0; ++i) {
            }
        }
        return this.byteBuffer.hasRemaining() ? this.byteBuffer.get() & 0xFF : -1;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int offset, int length) throws IOException {
        if (!this.byteBuffer.hasRemaining()) {
            int eof = 0;
            for (int i = 0; i < this.readTry && (eof = this.doRead()) == 0; ++i) {
            }
            if (eof <= 0) {
                return -1;
            }
        }
        if (length > this.byteBuffer.remaining()) {
            length = this.byteBuffer.remaining();
        }
        this.byteBuffer.get(b, offset, length);
        return length;
    }

    public int read(ByteBuffer bb) throws IOException {
        this.byteBuffer = bb;
        int eof = 0;
        for (int i = 0; i < this.readTry && (eof = this.doRead()) == 0; ++i) {
        }
        if (eof <= 0) {
            return -1;
        }
        return this.byteBuffer.limit();
    }

    public void recycle() {
        this.byteBuffer = null;
        this.key = null;
        this.readTimeout = defaultReadTimeout;
    }

    public void setSelectionKey(SelectionKey key) {
        this.key = key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int doRead() throws IOException {
        if (this.key == null) {
            return -1;
        }
        this.byteBuffer.clear();
        try {
            int n = ByteBufferInputStream.readBlocking((SocketChannel)this.key.channel(), this.byteBuffer, this.readTimeout);
            return n;
        }
        finally {
            this.byteBuffer.flip();
        }
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(int rt) {
        this.readTimeout = rt;
    }

    public static int getDefaultReadTimeout() {
        return defaultReadTimeout;
    }

    public static void setDefaultReadTimeout(int aDefaultReadTimeout) {
        defaultReadTimeout = aDefaultReadTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int readBlocking(SocketChannel socketChannel, ByteBuffer byteBuffer, int readTimeout) throws IOException {
        int count = 1;
        int byteRead = 0;
        Selector readSelector = null;
        SelectionKey tmpKey = null;
        try {
            while (count > 0) {
                count = socketChannel.read(byteBuffer);
                if (count > -1) {
                    byteRead += count;
                    continue;
                }
                if (count != -1 || byteRead != 0) continue;
                byteRead = -1;
            }
            if (byteRead == 0) {
                readSelector = SelectorFactory.getSelector();
                if (readSelector == null) {
                    int n = 0;
                    return n;
                }
                count = 1;
                tmpKey = socketChannel.register(readSelector, 1);
                tmpKey.interestOps(tmpKey.interestOps() | 1);
                int code = readSelector.select(readTimeout);
                tmpKey.interestOps(tmpKey.interestOps() & 0xFFFFFFFE);
                if (code == 0) {
                    int n = 0;
                    return n;
                }
                while (count > 0) {
                    count = socketChannel.read(byteBuffer);
                    if (count > -1) {
                        byteRead += count;
                        continue;
                    }
                    if (count != -1 || byteRead != 0) continue;
                    byteRead = -1;
                }
            }
        }
        finally {
            if (tmpKey != null) {
                tmpKey.cancel();
            }
            if (readSelector != null) {
                SelectorFactory.selectNowAndReturnSelector(readSelector);
            }
        }
        return byteRead;
    }
}

