/*
 * Decompiled with CFR 0.152.
 */
package com.taskadapter.redmineapi.bean;

import com.taskadapter.redmineapi.bean.Attachment;
import com.taskadapter.redmineapi.bean.Changeset;
import com.taskadapter.redmineapi.bean.CustomField;
import com.taskadapter.redmineapi.bean.Identifiable;
import com.taskadapter.redmineapi.bean.IssueCategory;
import com.taskadapter.redmineapi.bean.IssueRelation;
import com.taskadapter.redmineapi.bean.Journal;
import com.taskadapter.redmineapi.bean.Property;
import com.taskadapter.redmineapi.bean.PropertyStorage;
import com.taskadapter.redmineapi.bean.Tracker;
import com.taskadapter.redmineapi.bean.Version;
import com.taskadapter.redmineapi.bean.Watcher;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

public class Issue
implements Identifiable {
    private final PropertyStorage storage = new PropertyStorage();
    public static final Property<Integer> DATABASE_ID = new Property<Integer>(Integer.class, "id");
    public static final Property<String> SUBJECT = new Property<String>(String.class, "subject");
    public static final Property<Date> START_DATE = new Property<Date>(Date.class, "startDate");
    public static final Property<Date> DUE_DATE = new Property<Date>(Date.class, "dueDate");
    public static final Property<Date> CREATED_ON = new Property<Date>(Date.class, "createdOn");
    public static final Property<Date> UPDATED_ON = new Property<Date>(Date.class, "updatedOn");
    public static final Property<Integer> DONE_RATIO = new Property<Integer>(Integer.class, "doneRatio");
    public static final Property<Integer> PARENT_ID = new Property<Integer>(Integer.class, "parentId");
    public static final Property<Integer> PRIORITY_ID = new Property<Integer>(Integer.class, "priorityId");
    public static final Property<Float> ESTIMATED_HOURS = new Property<Float>(Float.class, "estimatedHours");
    public static final Property<Float> SPENT_HOURS = new Property<Float>(Float.class, "spentHours");
    public static final Property<Integer> ASSIGNEE_ID = new Property<Integer>(Integer.class, "assigneeId");
    public static final Property<String> ASSIGNEE_NAME = new Property<String>(String.class, "assigneeName");
    public static final Property<String> NOTES = new Property<String>(String.class, "notes");
    public static final Property<String> PRIORITY_TEXT = new Property<String>(String.class, "priorityText");
    public static final Property<Integer> PROJECT_ID = new Property<Integer>(Integer.class, "projectId");
    public static final Property<String> PROJECT_NAME = new Property<String>(String.class, "projectName");
    public static final Property<Integer> AUTHOR_ID = new Property<Integer>(Integer.class, "authorId");
    public static final Property<String> AUTHOR_NAME = new Property<String>(String.class, "authorName");
    public static final Property<Tracker> TRACKER = new Property<Tracker>(Tracker.class, "tracker");
    public static final Property<String> DESCRIPTION = new Property<String>(String.class, "description");
    public static final Property<Date> CLOSED_ON = new Property<Date>(Date.class, "closedOn");
    public static final Property<Integer> STATUS_ID = new Property<Integer>(Integer.class, "statusId");
    public static final Property<String> STATUS_NAME = new Property<String>(String.class, "statusName");
    public static final Property<Version> TARGET_VERSION = new Property<Version>(Version.class, "targetVersion");
    public static final Property<IssueCategory> ISSUE_CATEGORY = new Property<IssueCategory>(IssueCategory.class, "issueCategory");
    public static final Property<Boolean> PRIVATE_ISSUE = new Property<Boolean>(Boolean.class, "privateIssue");
    public static final Property<Set<CustomField>> CUSTOM_FIELDS = new Property<Set>(Set.class, "customFields");
    public static final Property<Set<Journal>> JOURNALS = new Property<Set>(Set.class, "journals");
    public static final Property<Set<IssueRelation>> RELATIONS = new Property<Set>(Set.class, "relations");
    public static final Property<Set<Attachment>> ATTACHMENTS = new Property<Set>(Set.class, "attachments");
    public static final Property<Set<Changeset>> CHANGESETS = new Property<Set>(Set.class, "changesets");
    public static final Property<Set<Watcher>> WATCHERS = new Property<Set>(Set.class, "watchers");
    public static final Property<Set<Issue>> CHILDREN = new Property<Set>(Set.class, "children");

    Issue(Integer id) {
        this();
        this.storage.set(DATABASE_ID, id);
    }

    public Issue() {
        this.initCollections(this.storage);
    }

    private void initCollections(PropertyStorage storage) {
        storage.set(CUSTOM_FIELDS, new HashSet());
        storage.set(CHILDREN, new HashSet());
        storage.set(WATCHERS, new HashSet());
        storage.set(CHANGESETS, new HashSet());
        storage.set(ATTACHMENTS, new HashSet());
        storage.set(RELATIONS, new HashSet());
        storage.set(JOURNALS, new HashSet());
    }

    public Integer getProjectId() {
        return this.storage.get(PROJECT_ID);
    }

    public void setProjectId(Integer projectId) {
        this.storage.set(PROJECT_ID, projectId);
    }

    public String getProjectName() {
        return this.storage.get(PROJECT_NAME);
    }

    public void setProjectName(String name) {
        this.storage.set(PROJECT_NAME, name);
    }

    public Integer getDoneRatio() {
        return this.storage.get(DONE_RATIO);
    }

    public void setDoneRatio(Integer doneRatio) {
        this.storage.set(DONE_RATIO, doneRatio);
    }

    public String getPriorityText() {
        return this.storage.get(PRIORITY_TEXT);
    }

    public void setPriorityText(String priority) {
        this.storage.set(PRIORITY_TEXT, priority);
    }

    public Integer getAssigneeId() {
        return this.storage.get(ASSIGNEE_ID);
    }

    public void setAssigneeId(Integer assigneeId) {
        this.storage.set(ASSIGNEE_ID, assigneeId);
    }

    public String getAssigneeName() {
        return this.storage.get(ASSIGNEE_NAME);
    }

    public void setAssigneeName(String assigneeName) {
        this.storage.set(ASSIGNEE_NAME, assigneeName);
    }

    public Float getEstimatedHours() {
        return this.storage.get(ESTIMATED_HOURS);
    }

    public void setEstimatedHours(Float estimatedTime) {
        this.storage.set(ESTIMATED_HOURS, estimatedTime);
    }

    public Float getSpentHours() {
        return this.storage.get(SPENT_HOURS);
    }

    public void setSpentHours(Float spentHours) {
        this.storage.set(SPENT_HOURS, spentHours);
    }

    public Integer getParentId() {
        return this.storage.get(PARENT_ID);
    }

    public void setParentId(Integer parentId) {
        this.storage.set(PARENT_ID, parentId);
    }

    @Override
    public Integer getId() {
        return this.storage.get(DATABASE_ID);
    }

    public String getSubject() {
        return this.storage.get(SUBJECT);
    }

    public void setSubject(String subject) {
        this.storage.set(SUBJECT, subject);
    }

    public Date getStartDate() {
        return this.storage.get(START_DATE);
    }

    public void setStartDate(Date startDate) {
        this.storage.set(START_DATE, startDate);
    }

    public Date getDueDate() {
        return this.storage.get(DUE_DATE);
    }

    public void setDueDate(Date dueDate) {
        this.storage.set(DUE_DATE, dueDate);
    }

    public Integer getAuthorId() {
        return this.storage.get(AUTHOR_ID);
    }

    public void setAuthorId(Integer id) {
        this.storage.set(AUTHOR_ID, id);
    }

    public String getAuthorName() {
        return this.storage.get(AUTHOR_NAME);
    }

    public void setAuthorName(String name) {
        this.storage.set(AUTHOR_NAME, name);
    }

    public Tracker getTracker() {
        return this.storage.get(TRACKER);
    }

    public void setTracker(Tracker tracker) {
        this.storage.set(TRACKER, tracker);
    }

    public String getDescription() {
        return this.storage.get(DESCRIPTION);
    }

    public void setDescription(String description) {
        this.storage.set(DESCRIPTION, description);
    }

    public Date getCreatedOn() {
        return this.storage.get(CREATED_ON);
    }

    public void setCreatedOn(Date createdOn) {
        this.storage.set(CREATED_ON, createdOn);
    }

    public Date getUpdatedOn() {
        return this.storage.get(UPDATED_ON);
    }

    public void setUpdatedOn(Date updatedOn) {
        this.storage.set(UPDATED_ON, updatedOn);
    }

    public Date getClosedOn() {
        return this.storage.get(CLOSED_ON);
    }

    public void setClosedOn(Date closedOn) {
        this.storage.set(CLOSED_ON, closedOn);
    }

    public Integer getStatusId() {
        return this.storage.get(STATUS_ID);
    }

    public void setStatusId(Integer statusId) {
        this.storage.set(STATUS_ID, statusId);
    }

    public String getStatusName() {
        return this.storage.get(STATUS_NAME);
    }

    public void setStatusName(String statusName) {
        this.storage.set(STATUS_NAME, statusName);
    }

    public Collection<CustomField> getCustomFields() {
        return Collections.unmodifiableCollection((Collection)this.storage.get(CUSTOM_FIELDS));
    }

    public void clearCustomFields() {
        this.storage.set(CUSTOM_FIELDS, new HashSet());
    }

    public void addCustomFields(Collection<CustomField> customFields) {
        this.storage.get(CUSTOM_FIELDS).addAll(customFields);
    }

    public void addCustomField(CustomField customField) {
        this.storage.get(CUSTOM_FIELDS).add(customField);
    }

    public String getNotes() {
        return this.storage.get(NOTES);
    }

    public void setNotes(String notes) {
        this.storage.set(NOTES, notes);
    }

    public Collection<Journal> getJournals() {
        return Collections.unmodifiableCollection((Collection)this.storage.get(JOURNALS));
    }

    public void addJournals(Collection<Journal> journals) {
        this.storage.get(JOURNALS).addAll(journals);
    }

    public Collection<Changeset> getChangesets() {
        return Collections.unmodifiableCollection((Collection)this.storage.get(CHANGESETS));
    }

    public void addChangesets(Collection<Changeset> changesets) {
        this.storage.get(CHANGESETS).addAll(changesets);
    }

    public Collection<Watcher> getWatchers() {
        return Collections.unmodifiableCollection((Collection)this.storage.get(WATCHERS));
    }

    public void addWatchers(Collection<Watcher> watchers) {
        this.storage.get(WATCHERS).addAll(watchers);
    }

    public Collection<Issue> getChildren() {
        return Collections.unmodifiableCollection((Collection)this.storage.get(CHILDREN));
    }

    public void addChildren(Collection<Issue> children) {
        this.storage.get(CHILDREN).addAll(children);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Issue issue = (Issue)o;
        return !(this.getId() != null ? !this.getId().equals(issue.getId()) : issue.getId() != null);
    }

    public int hashCode() {
        return this.getId() != null ? this.getId().hashCode() : 0;
    }

    public CustomField getCustomFieldById(int customFieldId) {
        for (CustomField customField : this.storage.get(CUSTOM_FIELDS)) {
            if (customFieldId != customField.getId()) continue;
            return customField;
        }
        return null;
    }

    public CustomField getCustomFieldByName(String customFieldName) {
        for (CustomField customField : this.storage.get(CUSTOM_FIELDS)) {
            if (!customFieldName.equals(customField.getName())) continue;
            return customField;
        }
        return null;
    }

    public String toString() {
        return "Issue [id=" + this.getId() + ", subject=" + this.getSubject() + "]";
    }

    public Collection<IssueRelation> getRelations() {
        return Collections.unmodifiableCollection((Collection)this.storage.get(RELATIONS));
    }

    public void addRelations(Collection<IssueRelation> collection) {
        this.storage.get(RELATIONS).addAll(collection);
    }

    public Integer getPriorityId() {
        return this.storage.get(PRIORITY_ID);
    }

    public void setPriorityId(Integer priorityId) {
        this.storage.set(PRIORITY_ID, priorityId);
    }

    public Version getTargetVersion() {
        return this.storage.get(TARGET_VERSION);
    }

    public Collection<Attachment> getAttachments() {
        return Collections.unmodifiableCollection((Collection)this.storage.get(ATTACHMENTS));
    }

    public void addAttachments(Collection<Attachment> collection) {
        this.storage.get(ATTACHMENTS).addAll(collection);
    }

    public void addAttachment(Attachment attachment) {
        this.storage.get(ATTACHMENTS).add(attachment);
    }

    public void setTargetVersion(Version version) {
        this.storage.set(TARGET_VERSION, version);
    }

    public IssueCategory getCategory() {
        return this.storage.get(ISSUE_CATEGORY);
    }

    public void setCategory(IssueCategory category) {
        this.storage.set(ISSUE_CATEGORY, category);
    }

    public boolean isPrivateIssue() {
        return this.storage.get(PRIVATE_ISSUE);
    }

    public void setPrivateIssue(boolean privateIssue) {
        this.storage.set(PRIVATE_ISSUE, privateIssue);
    }

    public PropertyStorage getStorage() {
        return this.storage;
    }
}

