/*
 * Decompiled with CFR 0.152.
 */
package com.qq.tars.spring.bean;

import com.qq.tars.server.config.ConfigurationManager;
import com.qq.tars.spring.annotation.RemotePropertySource;
import com.qq.tars.support.config.ConfigHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import org.springframework.boot.context.event.ApplicationEnvironmentPreparedEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.env.PropertySource;

public class PropertiesListener
implements ApplicationListener<ApplicationEnvironmentPreparedEvent> {
    public void onApplicationEvent(ApplicationEnvironmentPreparedEvent event) {
        RemotePropertySource sources = event.getSpringApplication().getMainApplicationClass().getAnnotation(RemotePropertySource.class);
        String configPath = ConfigurationManager.getInstance().getserverConfig().getBasePath() + "/conf/";
        if (sources != null) {
            for (String name : sources.value()) {
                try {
                    ConfigHelper.getInstance().loadConfig(name);
                    File config = new File(configPath + name);
                    if (!config.exists()) {
                        throw new RuntimeException("[TARS] load config failed file not exists");
                    }
                    Properties properties = new Properties();
                    properties.load(new FileInputStream(config));
                    event.getEnvironment().getPropertySources().addFirst((PropertySource)new PropertiesPropertySource(name, properties));
                }
                catch (IOException e) {
                    System.err.println("[TARS] load config failed: " + name);
                    e.printStackTrace();
                }
            }
        }
    }
}

