/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.trpc.limiter.sentinel;

import com.alibaba.csp.sentinel.Entry;
import com.alibaba.csp.sentinel.SphU;
import com.alibaba.csp.sentinel.Tracer;
import com.alibaba.csp.sentinel.slots.block.BlockException;
import com.tencent.trpc.core.common.config.PluginConfig;
import com.tencent.trpc.core.exception.LimiterBlockException;
import com.tencent.trpc.core.exception.LimiterException;
import com.tencent.trpc.core.exception.LimiterFallbackException;
import com.tencent.trpc.core.exception.TRpcExtensionException;
import com.tencent.trpc.core.extension.Extension;
import com.tencent.trpc.core.extension.ExtensionLoader;
import com.tencent.trpc.core.extension.InitializingExtension;
import com.tencent.trpc.core.extension.PluginConfigAware;
import com.tencent.trpc.core.limiter.spi.Limiter;
import com.tencent.trpc.core.limiter.spi.LimiterBlockHandler;
import com.tencent.trpc.core.limiter.spi.LimiterFallback;
import com.tencent.trpc.core.limiter.spi.LimiterResourceExtractor;
import com.tencent.trpc.core.logger.Logger;
import com.tencent.trpc.core.logger.LoggerFactory;
import com.tencent.trpc.core.rpc.Invoker;
import com.tencent.trpc.core.rpc.Request;
import com.tencent.trpc.core.rpc.Response;
import com.tencent.trpc.limiter.sentinel.config.SentinelConfig;
import com.tencent.trpc.limiter.sentinel.config.SentinelLimiterConfig;
import com.tencent.trpc.limiter.sentinel.config.datasource.DatasourceConfig;
import java.util.concurrent.CompletionStage;

@Extension(value="sentinel")
public class SentinelLimiter
implements Limiter,
PluginConfigAware,
InitializingExtension {
    private static final Logger logger = LoggerFactory.getLogger(SentinelLimiter.class);
    private PluginConfig sentinelPluginConfig;
    private LimiterBlockHandler limiterBlockHandler;
    private LimiterFallback limiterFallback;
    private LimiterResourceExtractor limiterResourceExtractor;

    public void setPluginConfig(PluginConfig pluginConfig) throws TRpcExtensionException {
        this.sentinelPluginConfig = pluginConfig;
    }

    public void init() throws TRpcExtensionException {
        SentinelConfig sentinelConfig = SentinelConfig.parse(this.sentinelPluginConfig.getProperties());
        this.initLimiterConfig(sentinelConfig);
        this.registerDataSource(sentinelConfig);
    }

    private void initLimiterConfig(SentinelConfig sentinelConfig) {
        SentinelLimiterConfig limiterConfig = sentinelConfig.getLimiterConfig();
        this.limiterBlockHandler = this.loadLimiterComponent(LimiterBlockHandler.class, limiterConfig.getBlockHandler());
        this.limiterResourceExtractor = this.loadLimiterComponent(LimiterResourceExtractor.class, limiterConfig.getResourceExtractor());
        this.limiterFallback = this.loadLimiterComponent(LimiterFallback.class, limiterConfig.getFallback());
    }

    private <T> T loadLimiterComponent(Class<T> clazz, String name) {
        Object limiterComponent = ExtensionLoader.getExtensionLoader(clazz).getExtension(name);
        if (limiterComponent == null) {
            throw new LimiterException("not found the limiter plugin(name=" + name + ",class=" + clazz.getName() + ")");
        }
        return (T)limiterComponent;
    }

    private void registerDataSource(SentinelConfig sentinelConfig) {
        DatasourceConfig datasourceConfig = sentinelConfig.getDataSourceConfig();
        if (datasourceConfig == null) {
            logger.warn("not use datasource for sentinel flow rule");
            return;
        }
        datasourceConfig.register();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletionStage<Response> block(Invoker<?> filterChain, Request request) {
        Entry entry = null;
        String resource = this.limiterResourceExtractor.extract(filterChain, request);
        try {
            entry = SphU.entry((String)resource);
            CompletionStage completionStage = filterChain.invoke(request);
            return completionStage;
        }
        catch (BlockException e) {
            CompletionStage completionStage = this.limiterBlockHandler.handle(filterChain, request, new LimiterBlockException((Throwable)e));
            return completionStage;
        }
        catch (Throwable t) {
            Tracer.traceEntry((Throwable)t, (Entry)entry);
            CompletionStage completionStage = this.limiterFallback.fallback(filterChain, request, new LimiterFallbackException(t));
            return completionStage;
        }
        finally {
            if (entry != null) {
                entry.exit();
            }
        }
    }
}

