/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.trpc.limiter.sentinel.config;

import com.tencent.trpc.limiter.sentinel.config.SentinelLimiterConfig;
import com.tencent.trpc.limiter.sentinel.config.datasource.DatasourceConfig;
import com.tencent.trpc.limiter.sentinel.config.datasource.factory.DatasourceConfigFactoryManger;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;

public class SentinelConfig {
    private static final String DATASOURCE = "datasource";
    private DatasourceConfig dataSourceConfig;
    private SentinelLimiterConfig limiterConfig;

    public static SentinelConfig parse(Map<String, Object> yamlMapConfig) {
        SentinelConfig sentinelConfig = new SentinelConfig();
        if (MapUtils.isEmpty(yamlMapConfig)) {
            return sentinelConfig;
        }
        sentinelConfig.setDataSourceConfig(SentinelConfig.parseDataSourceConfig(yamlMapConfig));
        sentinelConfig.setLimiterConfig(SentinelLimiterConfig.parse(yamlMapConfig));
        return sentinelConfig;
    }

    private static DatasourceConfig parseDataSourceConfig(Map<String, Object> yamlMapConfig) {
        Map datasourceMapConfig = MapUtils.getMap(yamlMapConfig, (Object)DATASOURCE);
        if (MapUtils.isEmpty((Map)datasourceMapConfig)) {
            return null;
        }
        String datasourceName = (String)datasourceMapConfig.keySet().iterator().next();
        Map configMap = MapUtils.getMap((Map)datasourceMapConfig, (Object)datasourceName);
        return DatasourceConfigFactoryManger.getDatasourceConfigFactory(datasourceName).create(configMap);
    }

    public DatasourceConfig getDataSourceConfig() {
        return this.dataSourceConfig;
    }

    public void setDataSourceConfig(DatasourceConfig dataSourceConfig) {
        this.dataSourceConfig = dataSourceConfig;
    }

    public SentinelLimiterConfig getLimiterConfig() {
        return this.limiterConfig;
    }

    public void setLimiterConfig(SentinelLimiterConfig limiterConfig) {
        this.limiterConfig = limiterConfig;
    }
}

