/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.trpc.limiter.sentinel.config.datasource;

import com.alibaba.csp.sentinel.datasource.Converter;
import com.alibaba.csp.sentinel.datasource.FileInJarReadableDataSource;
import com.alibaba.csp.sentinel.datasource.FileRefreshableDataSource;
import com.alibaba.csp.sentinel.property.SentinelProperty;
import com.alibaba.csp.sentinel.slots.block.flow.FlowRule;
import com.alibaba.csp.sentinel.slots.block.flow.FlowRuleManager;
import com.fasterxml.jackson.core.type.TypeReference;
import com.tencent.trpc.core.exception.LimiterDataSourceException;
import com.tencent.trpc.core.utils.JsonUtils;
import com.tencent.trpc.core.utils.StringUtils;
import com.tencent.trpc.limiter.sentinel.config.datasource.AbstractDatasourceConfig;
import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.List;

public class LocalFileDatasourceConfig
extends AbstractDatasourceConfig {
    private static final String CLASSPATH_PREFIX = "classpath:";
    private static final String JAR_PREFIX = "jar:";
    private static final String FILE_PREFIX = "file:";
    private String path;

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    @Override
    protected void validate() {
        if (StringUtils.isEmpty((CharSequence)this.path)) {
            throw new LimiterDataSourceException("sentinel local file path cannot be empty");
        }
    }

    @Override
    public void register() {
        super.register();
        FileRefreshableDataSource dataSource = null;
        Converter converter = source -> (List)JsonUtils.fromJson((String)source, (TypeReference)new TypeReference<List<FlowRule>>(){});
        String externalPath = this.path;
        try {
            File file;
            if (externalPath.startsWith(CLASSPATH_PREFIX)) {
                externalPath = externalPath.substring(CLASSPATH_PREFIX.length());
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                URL resource = classLoader.getResource(externalPath);
                if (resource != null) {
                    externalPath = resource.toExternalForm();
                    if (externalPath.startsWith(JAR_PREFIX)) {
                        JarURLConnection conn = (JarURLConnection)resource.openConnection();
                        dataSource = new FileInJarReadableDataSource(conn.getJarFileURL().getPath(), conn.getEntryName(), converter);
                    } else if (externalPath.startsWith(FILE_PREFIX)) {
                        externalPath = externalPath.substring(FILE_PREFIX.length());
                    }
                }
            }
            if (dataSource == null && (file = new File(externalPath)).exists()) {
                dataSource = new FileRefreshableDataSource(file, converter);
            }
        }
        catch (IOException e) {
            logger.error("failed to register local file as sentinel flow rule datasource, flowRulePath = {}, error = {}", new Object[]{this.path, e});
            throw new LimiterDataSourceException((Throwable)e);
        }
        if (dataSource == null) {
            throw new LimiterDataSourceException("file path=" + this.path + " not exists");
        }
        FlowRuleManager.register2Property((SentinelProperty)dataSource.getProperty());
        logger.warn("succeed to register local file as sentinel flow rule data source");
    }
}

