/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.trpc.limiter.sentinel.config.datasource;

import com.alibaba.csp.sentinel.datasource.nacos.NacosDataSource;
import com.alibaba.csp.sentinel.property.SentinelProperty;
import com.alibaba.csp.sentinel.slots.block.flow.FlowRule;
import com.alibaba.csp.sentinel.slots.block.flow.FlowRuleManager;
import com.fasterxml.jackson.core.type.TypeReference;
import com.tencent.trpc.core.exception.LimiterDataSourceException;
import com.tencent.trpc.core.utils.JsonUtils;
import com.tencent.trpc.core.utils.StringUtils;
import com.tencent.trpc.limiter.sentinel.config.datasource.AbstractDatasourceConfig;
import java.util.List;

public class NacosDatasourceConfig
extends AbstractDatasourceConfig {
    private String remoteAddress;
    private String groupId;
    private String dataId;

    public void setRemoteAddress(String remoteAddress) {
        this.remoteAddress = remoteAddress;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public void setDataId(String dataId) {
        this.dataId = dataId;
    }

    @Override
    protected void validate() {
        if (StringUtils.isEmpty((CharSequence)this.remoteAddress)) {
            throw new LimiterDataSourceException("sentinel nacos datasource config error: remote address is empty");
        }
        if (StringUtils.isEmpty((CharSequence)this.groupId)) {
            throw new LimiterDataSourceException("sentinel nacos datasource config error: groupId is empty");
        }
        if (StringUtils.isEmpty((CharSequence)this.dataId)) {
            throw new LimiterDataSourceException("sentinel nacos datasource config error: dataId is empty");
        }
    }

    @Override
    public void register() {
        super.register();
        logger.warn("start to register nacos as sentinel flow rule data source, remoteAddress = {}, groupId = {}, dataId= {}", new Object[]{this.remoteAddress, this.groupId, this.dataId});
        NacosDataSource flowRuleDataSource = new NacosDataSource(this.remoteAddress, this.groupId, this.dataId, source -> (List)JsonUtils.fromJson((String)source, (TypeReference)new TypeReference<List<FlowRule>>(){}));
        FlowRuleManager.register2Property((SentinelProperty)flowRuleDataSource.getProperty());
        logger.warn("succeed to register nacos as sentinel flow rule datasource");
    }
}

