/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.trpc.limiter.sentinel.config.datasource;

import com.alibaba.csp.sentinel.datasource.redis.RedisDataSource;
import com.alibaba.csp.sentinel.datasource.redis.config.RedisConnectionConfig;
import com.alibaba.csp.sentinel.property.SentinelProperty;
import com.alibaba.csp.sentinel.slots.block.flow.FlowRule;
import com.alibaba.csp.sentinel.slots.block.flow.FlowRuleManager;
import com.fasterxml.jackson.core.type.TypeReference;
import com.tencent.trpc.core.exception.LimiterDataSourceException;
import com.tencent.trpc.core.utils.JsonUtils;
import com.tencent.trpc.core.utils.StringUtils;
import com.tencent.trpc.limiter.sentinel.config.datasource.AbstractDatasourceConfig;
import java.util.List;

public class RedisDatasourceConfig
extends AbstractDatasourceConfig {
    RedisConnectionConfig redisConnectionConfig;
    private String channel;
    private String ruleKey;

    public void setChannel(String channel) {
        this.channel = channel;
    }

    public void setRuleKey(String ruleKey) {
        this.ruleKey = ruleKey;
    }

    public void setRedisConnectionConfig(RedisConnectionConfig redisConnectionConfig) {
        this.redisConnectionConfig = redisConnectionConfig;
    }

    @Override
    protected void validate() {
        if (StringUtils.isEmpty((CharSequence)this.ruleKey)) {
            throw new LimiterDataSourceException("sentinel redis datasource config error, rule key is empty");
        }
        if (StringUtils.isEmpty((CharSequence)this.channel)) {
            throw new LimiterDataSourceException("sentinel redis datasource config error, channel is empty");
        }
    }

    @Override
    public void register() {
        super.register();
        RedisDataSource flowRuleDataSource = new RedisDataSource(this.redisConnectionConfig, this.ruleKey, this.channel, source -> (List)JsonUtils.fromJson((String)source, (TypeReference)new TypeReference<List<FlowRule>>(){}));
        FlowRuleManager.register2Property((SentinelProperty)flowRuleDataSource.getProperty());
    }
}

