/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.trpc.limiter.sentinel.config.datasource;

import com.alibaba.csp.sentinel.datasource.zookeeper.ZookeeperDataSource;
import com.alibaba.csp.sentinel.property.SentinelProperty;
import com.alibaba.csp.sentinel.slots.block.flow.FlowRule;
import com.alibaba.csp.sentinel.slots.block.flow.FlowRuleManager;
import com.fasterxml.jackson.core.type.TypeReference;
import com.tencent.trpc.core.exception.LimiterDataSourceException;
import com.tencent.trpc.core.utils.JsonUtils;
import com.tencent.trpc.core.utils.StringUtils;
import com.tencent.trpc.limiter.sentinel.config.datasource.AbstractDatasourceConfig;
import java.util.List;

public class ZookeeperDatasourceConfig
extends AbstractDatasourceConfig {
    private String remoteAddress;
    private String path;

    public void setRemoteAddress(String remoteAddress) {
        this.remoteAddress = remoteAddress;
    }

    public void setPath(String path) {
        this.path = path;
    }

    @Override
    protected void validate() {
        if (StringUtils.isEmpty((CharSequence)this.remoteAddress)) {
            throw new LimiterDataSourceException("sentinel zookeeper datasource config error, remote address is empty");
        }
        if (StringUtils.isEmpty((CharSequence)this.path)) {
            throw new LimiterDataSourceException("sentinel zookeeper datasource config error, path is empty");
        }
    }

    @Override
    public void register() {
        super.register();
        logger.warn("start to register zookeeper as sentinel flow rule data source, remoteAddress = {}, path = {}", new Object[]{this.remoteAddress, this.path});
        ZookeeperDataSource flowRuleDataSource = new ZookeeperDataSource(this.remoteAddress, this.path, source -> (List)JsonUtils.fromJson((String)source, (TypeReference)new TypeReference<List<FlowRule>>(){}));
        FlowRuleManager.register2Property((SentinelProperty)flowRuleDataSource.getProperty());
        logger.warn("succeed to register zookeeper as sentinel flow rule datasource");
    }
}

