/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.trpc.limiter.sentinel.config.datasource.factory;

import com.tencent.trpc.limiter.sentinel.config.datasource.factory.DatasourceConfigFactory;
import com.tencent.trpc.limiter.sentinel.config.datasource.factory.DatasourceType;
import com.tencent.trpc.limiter.sentinel.config.datasource.factory.LocalFileDatasourceConfigFactory;
import com.tencent.trpc.limiter.sentinel.config.datasource.factory.NacosDatasourceConfigFactory;
import com.tencent.trpc.limiter.sentinel.config.datasource.factory.RedisDatasourceConfigFactory;
import com.tencent.trpc.limiter.sentinel.config.datasource.factory.ZookeeperDatasourceConfigFactory;
import java.util.concurrent.ConcurrentHashMap;

public class DatasourceConfigFactoryManger {
    private static final ConcurrentHashMap<String, DatasourceConfigFactory> FACTORY_MAP = new ConcurrentHashMap();

    public static DatasourceConfigFactory getDatasourceConfigFactory(String name) {
        return FACTORY_MAP.get(name);
    }

    static {
        FACTORY_MAP.put(DatasourceType.LOCAL_FILE.getName(), new LocalFileDatasourceConfigFactory());
        FACTORY_MAP.put(DatasourceType.NACOS.getName(), new NacosDatasourceConfigFactory());
        FACTORY_MAP.put(DatasourceType.REDIS.getName(), new RedisDatasourceConfigFactory());
        FACTORY_MAP.put(DatasourceType.ZOOKEEPER.getName(), new ZookeeperDatasourceConfigFactory());
    }
}

