/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.trpc.limiter.sentinel.config.datasource.factory;

import com.tencent.trpc.limiter.sentinel.config.datasource.DatasourceConfig;
import com.tencent.trpc.limiter.sentinel.config.datasource.NacosDatasourceConfig;
import com.tencent.trpc.limiter.sentinel.config.datasource.factory.DatasourceConfigFactory;
import com.tencent.trpc.limiter.sentinel.config.datasource.factory.DatasourceType;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;

public class NacosDatasourceConfigFactory
implements DatasourceConfigFactory {
    public static final String GROUP_ID = "group_id";
    public static final String DATA_ID = "data_id";
    public static final String REMOTE_ADDRESS = "remote_address";

    @Override
    public String name() {
        return DatasourceType.NACOS.getName();
    }

    @Override
    public DatasourceConfig create(Map<String, Object> configs) {
        String remoteAddress = MapUtils.getString(configs, (Object)REMOTE_ADDRESS);
        String groupId = MapUtils.getString(configs, (Object)GROUP_ID);
        String dataId = MapUtils.getString(configs, (Object)DATA_ID);
        NacosDatasourceConfig nacosDataSourceConfig = new NacosDatasourceConfig();
        nacosDataSourceConfig.setRemoteAddress(remoteAddress);
        nacosDataSourceConfig.setGroupId(groupId);
        nacosDataSourceConfig.setDataId(dataId);
        return nacosDataSourceConfig;
    }
}

