/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.trpc.limiter.sentinel.config.datasource.factory;

import com.alibaba.csp.sentinel.datasource.redis.config.RedisConnectionConfig;
import com.tencent.trpc.limiter.sentinel.config.datasource.DatasourceConfig;
import com.tencent.trpc.limiter.sentinel.config.datasource.RedisDatasourceConfig;
import com.tencent.trpc.limiter.sentinel.config.datasource.factory.DatasourceConfigFactory;
import com.tencent.trpc.limiter.sentinel.config.datasource.factory.DatasourceType;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;

public class RedisDatasourceConfigFactory
implements DatasourceConfigFactory {
    private static final String HOST = "host";
    private static final String PASSWORD = "password";
    private static final String DATABASE = "db";
    private static final String PORT = "port";
    private static final String CHANNEL = "channel";
    private static final String FLOW_RULE_KRY = "rule_key";
    private static final String TIMEOUT_MS = "timeout";
    private static final String CLIENT_NAME = "client_name";
    private static final String SENTINEL_MASTER_ID = "sentinel_master_id";

    @Override
    public String name() {
        return DatasourceType.REDIS.getName();
    }

    @Override
    public DatasourceConfig create(Map<String, Object> configs) {
        String channel = MapUtils.getString(configs, (Object)CHANNEL);
        String ruleKey = MapUtils.getString(configs, (Object)FLOW_RULE_KRY);
        RedisDatasourceConfig redisDataSourceConfig = new RedisDatasourceConfig();
        redisDataSourceConfig.setRuleKey(ruleKey);
        redisDataSourceConfig.setChannel(channel);
        redisDataSourceConfig.setRedisConnectionConfig(RedisDatasourceConfigFactory.buildConnectionConfig(configs));
        return redisDataSourceConfig;
    }

    private static RedisConnectionConfig buildConnectionConfig(Map<String, Object> dataSourceConfigMap) {
        RedisConnectionConfig.Builder builder = RedisConnectionConfig.builder();
        String host = MapUtils.getString(dataSourceConfigMap, (Object)HOST);
        Integer port = MapUtils.getInteger(dataSourceConfigMap, (Object)PORT);
        builder.withHost(host).withPort(port.intValue());
        if (dataSourceConfigMap.containsKey(CLIENT_NAME)) {
            builder.withClientName(MapUtils.getString(dataSourceConfigMap, (Object)CLIENT_NAME));
        }
        if (dataSourceConfigMap.containsKey(SENTINEL_MASTER_ID)) {
            builder.withSentinelMasterId(MapUtils.getString(dataSourceConfigMap, (Object)SENTINEL_MASTER_ID));
        }
        if (dataSourceConfigMap.containsKey(PASSWORD)) {
            builder.withPassword(MapUtils.getString(dataSourceConfigMap, (Object)PASSWORD));
        }
        if (dataSourceConfigMap.containsKey(DATABASE)) {
            builder.withDatabase(MapUtils.getIntValue(dataSourceConfigMap, (Object)DATABASE));
        }
        if (dataSourceConfigMap.containsKey(TIMEOUT_MS)) {
            builder.withTimeout(MapUtils.getLong(dataSourceConfigMap, (Object)TIMEOUT_MS).longValue());
        }
        return builder.build();
    }
}

