/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.trpc.limiter.sentinel.config.datasource.factory;

import com.tencent.trpc.limiter.sentinel.config.datasource.DatasourceConfig;
import com.tencent.trpc.limiter.sentinel.config.datasource.ZookeeperDatasourceConfig;
import com.tencent.trpc.limiter.sentinel.config.datasource.factory.DatasourceConfigFactory;
import com.tencent.trpc.limiter.sentinel.config.datasource.factory.DatasourceType;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;

public class ZookeeperDatasourceConfigFactory
implements DatasourceConfigFactory {
    private static final String REMOTE_ADDRESS = "remote_address";
    private static final String FLOW_RULE_PATH = "path";

    @Override
    public String name() {
        return DatasourceType.ZOOKEEPER.getName();
    }

    @Override
    public DatasourceConfig create(Map<String, Object> configs) {
        String zkRemoteAddress = MapUtils.getString(configs, (Object)REMOTE_ADDRESS);
        String path = MapUtils.getString(configs, (Object)FLOW_RULE_PATH);
        ZookeeperDatasourceConfig zookeeperDataSourceConfig = new ZookeeperDatasourceConfig();
        zookeeperDataSourceConfig.setRemoteAddress(zkRemoteAddress);
        zookeeperDataSourceConfig.setPath(path);
        return zookeeperDataSourceConfig;
    }
}

