/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.benchto.driver.execution;

import com.google.common.collect.Lists;
import com.teradata.benchto.driver.Benchmark;
import com.teradata.benchto.driver.BenchmarkProperties;
import com.teradata.benchto.driver.FailedBenchmarkExecutionException;
import com.teradata.benchto.driver.execution.BenchmarkExecutionDriver;
import com.teradata.benchto.driver.execution.BenchmarkExecutionResult;
import com.teradata.benchto.driver.listeners.benchmark.BenchmarkStatusReporter;
import com.teradata.benchto.driver.loader.BenchmarkLoader;
import com.teradata.benchto.driver.macro.MacroService;
import com.teradata.benchto.driver.utils.TimeUtils;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ExecutionDriver {
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss:SSS");
    private static final Logger LOG = LoggerFactory.getLogger(BenchmarkExecutionDriver.class);
    @Autowired
    private BenchmarkProperties properties;
    @Autowired
    private BenchmarkStatusReporter benchmarkStatusReporter;
    @Autowired
    private BenchmarkLoader benchmarkLoader;
    @Autowired
    private BenchmarkExecutionDriver benchmarkExecutionDriver;
    @Autowired
    private MacroService macroService;
    private final ZonedDateTime startTime = TimeUtils.nowUtc();

    public void execute() {
        List<Benchmark> benchmarks = this.loadBenchmarks();
        if (benchmarks.isEmpty()) {
            LOG.warn("No benchmarks selected, exiting...");
            return;
        }
        this.executeBeforeAllMacros();
        try {
            this.executeBenchmarks(benchmarks);
        }
        finally {
            try {
                this.executeAfterAllMacros();
            }
            catch (RuntimeException e) {
                LOG.error("Exception during execution of after-all macros: {}", (Throwable)e);
            }
        }
    }

    private void executeBeforeAllMacros() {
        this.runOptionalMacros(this.properties.getBeforeAllMacros(), "before all");
    }

    private void executeAfterAllMacros() {
        this.runOptionalMacros(this.properties.getAfterAllMacros(), "after all");
    }

    private void runOptionalMacros(Optional<List<String>> macros, String kind) {
        if (macros.isPresent()) {
            LOG.info("Running {} macros: {}", (Object)kind, macros.get());
            this.macroService.runBenchmarkMacros(macros.get());
        }
    }

    private List<Benchmark> loadBenchmarks() {
        String executionSequenceId = this.benchmarkExecutionSequenceId();
        LOG.info("Running benchmarks(executionSequenceId={}) with properties: {}", (Object)executionSequenceId, (Object)this.properties);
        List<Benchmark> benchmarks = this.benchmarkLoader.loadBenchmarks(executionSequenceId);
        LOG.info("Loaded {} benchmarks", (Object)benchmarks.size());
        return benchmarks;
    }

    private String benchmarkExecutionSequenceId() {
        return this.properties.getExecutionSequenceId().orElse(TimeUtils.nowUtc().format(DATE_TIME_FORMATTER));
    }

    private void executeBenchmarks(List<Benchmark> benchmarks) {
        ArrayList benchmarkExecutionResults = Lists.newArrayList();
        int benchmarkOrdinalNumber = 1;
        for (Benchmark benchmark : benchmarks) {
            if (this.isTimeLimitEnded()) {
                LOG.warn("Time limit for running benchmarks has run out");
                break;
            }
            this.executeHealthCheck(benchmark);
            benchmarkExecutionResults.add(this.benchmarkExecutionDriver.execute(benchmark, benchmarkOrdinalNumber++, benchmarks.size()));
            this.benchmarkStatusReporter.processCompletedFutures();
        }
        List<BenchmarkExecutionResult> failedBenchmarkResults = benchmarkExecutionResults.stream().filter(benchmarkExecutionResult -> !benchmarkExecutionResult.isSuccessful()).collect(Collectors.toList());
        this.benchmarkStatusReporter.awaitAllFutures(10L, TimeUnit.MINUTES);
        if (!failedBenchmarkResults.isEmpty()) {
            throw new FailedBenchmarkExecutionException(failedBenchmarkResults, benchmarkExecutionResults.size());
        }
    }

    private boolean isTimeLimitEnded() {
        Optional<Duration> timeLimit = this.properties.getTimeLimit();
        return timeLimit.isPresent() && timeLimit.get().compareTo(Duration.between(this.startTime, TimeUtils.nowUtc())) < 0;
    }

    private void executeHealthCheck(Benchmark benchmark) {
        Optional<List<String>> macros = this.properties.getHealthCheckMacros();
        if (macros.isPresent()) {
            LOG.info("Running health check macros: {}", macros.get());
            this.macroService.runBenchmarkMacros(macros.get(), benchmark);
        }
    }
}

