/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.benchto.driver.execution;

import com.teradata.benchto.driver.Benchmark;
import com.teradata.benchto.driver.execution.QueryExecutionResult;
import com.teradata.benchto.driver.graphite.GraphiteProperties;
import com.teradata.benchto.driver.utils.TimeUtils;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ExecutionSynchronizer {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExecutionSynchronizer.class);
    private static final double GRAPHITE_WAIT_BETWEEN_REPORTING_RESOLUTION_COUNT = 2.0;
    private static final Duration SHUTDOWN_ASYNC_TASKS_WAIT_TIMEOUT = Duration.ofMinutes(20L);
    private static final int SHUTDOWN_ASYNC_TASKS_WAIT_REPORT_TIMES = 20;
    @Autowired
    private GraphiteProperties properties;
    private ScheduledExecutorService executorService = Executors.newScheduledThreadPool(2);

    @PreDestroy
    public void shutdown() throws InterruptedException {
        this.executorService.shutdown();
        this.executorService.awaitTermination(100L, TimeUnit.MILLISECONDS);
        for (int i = 0; i < 20 && !this.executorService.isTerminated(); ++i) {
            LOGGER.info("Waiting for asynchronous tasks to complete ...");
            this.executorService.awaitTermination(SHUTDOWN_ASYNC_TASKS_WAIT_TIMEOUT.dividedBy(20L).toMillis(), TimeUnit.MILLISECONDS);
        }
        if (!this.executorService.isTerminated()) {
            throw new RuntimeException("Some tasks did not finish on time");
        }
    }

    public void awaitAfterQueryExecutionAndBeforeResultReport(QueryExecutionResult queryExecutionResult) {
        if (this.properties.isGraphiteMetricsCollectionEnabled() && queryExecutionResult.getBenchmark().isSerial()) {
            int waitSecondsBetweenRuns = this.waitSecondsBetweenRuns();
            LOGGER.info("Waiting {}s between queries - thread ({})", (Object)waitSecondsBetweenRuns, (Object)this.currThreadName());
            TimeUtils.sleep(waitSecondsBetweenRuns, TimeUnit.SECONDS);
        }
    }

    public void awaitAfterBenchmarkExecutionAndBeforeResultReport(Benchmark benchmark) {
        if (this.properties.isGraphiteMetricsCollectionEnabled() && benchmark.isConcurrent()) {
            int waitSecondsBetweenRuns = this.waitSecondsBetweenRuns();
            LOGGER.info("Waiting {}s between benchmarks - thread ({})", (Object)waitSecondsBetweenRuns, (Object)this.currThreadName());
            TimeUtils.sleep(waitSecondsBetweenRuns, TimeUnit.SECONDS);
        }
    }

    public <T> CompletableFuture<T> execute(Instant when, Callable<T> callable) {
        if (!Instant.now().isBefore(when)) {
            try {
                return CompletableFuture.completedFuture(callable.call());
            }
            catch (Exception e) {
                CompletableFuture future = new CompletableFuture();
                future.completeExceptionally(e);
                return future;
            }
        }
        long delay = Instant.now().until(when, ChronoUnit.MILLIS);
        CompletableFuture future = new CompletableFuture();
        this.executorService.schedule(() -> {
            try {
                future.complete(callable.call());
            }
            catch (Throwable e) {
                future.completeExceptionally(e);
                throw e;
            }
            return null;
        }, delay, TimeUnit.MILLISECONDS);
        return future;
    }

    private int waitSecondsBetweenRuns() {
        return (int)((double)this.properties.getGraphiteResolutionSeconds() * 2.0);
    }

    private String currThreadName() {
        return Thread.currentThread().getName();
    }
}

