/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.benchto.driver.execution;

import com.google.common.base.MoreObjects;
import com.teradata.benchto.driver.Benchmark;
import com.teradata.benchto.driver.Measurable;
import com.teradata.benchto.driver.execution.QueryExecution;
import java.util.Optional;

public class QueryExecutionResult
extends Measurable {
    private final QueryExecution queryExecution;
    private int rowsCount;
    private Exception failureCause;
    private Optional<String> prestoQueryId = Optional.empty();

    public QueryExecutionResult(QueryExecution queryExecution) {
        this.queryExecution = queryExecution;
    }

    public QueryExecution getQueryExecution() {
        return this.queryExecution;
    }

    @Override
    public Benchmark getBenchmark() {
        return this.queryExecution.getBenchmark();
    }

    @Override
    public String getEnvironment() {
        return this.getBenchmark().getEnvironment();
    }

    @Override
    public boolean isSuccessful() {
        return this.failureCause == null;
    }

    public int getRowsCount() {
        return this.rowsCount;
    }

    public Exception getFailureCause() {
        return this.failureCause;
    }

    public Optional<String> getPrestoQueryId() {
        return this.prestoQueryId;
    }

    public String getQueryName() {
        return this.queryExecution.getQueryName();
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("queryExecution", (Object)this.queryExecution).add("successful", this.isSuccessful()).add("rowsCount", this.rowsCount).add("failureCause", (Object)this.failureCause).add("queryDuration", (Object)(this.getQueryDuration().toMillis() + " ms")).add("prestoQueryId", this.prestoQueryId).toString();
    }

    public static class QueryExecutionResultBuilder
    extends Measurable.MeasuredBuilder<QueryExecutionResult, QueryExecutionResultBuilder> {
        public QueryExecutionResultBuilder(QueryExecution queryExecution) {
            super(new QueryExecutionResult(queryExecution));
        }

        public QueryExecutionResultBuilder failed(Exception cause) {
            ((QueryExecutionResult)this.object).failureCause = cause;
            return this;
        }

        public QueryExecutionResultBuilder setRowsCount(int rowsCount) {
            ((QueryExecutionResult)this.object).rowsCount = rowsCount;
            return this;
        }

        public QueryExecutionResultBuilder setPrestoQueryId(String prestoQueryId) {
            ((QueryExecutionResult)this.object).prestoQueryId = Optional.of(prestoQueryId);
            return this;
        }
    }
}

