/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.benchto.driver.utils;

import com.google.common.base.Preconditions;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.measure.unit.NonSI;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;

public final class UnitConverter {
    private static final Pattern VALUE_WITH_UNIT_PATTERN = Pattern.compile("^([+-]?(?:\\d+|\\d*\\.\\d+))([a-zA-Z]*)$");
    private static final int VALUE_GROUP_INDEX = 1;
    private static final int UNIT_GROUP_INDEX = 2;

    private UnitConverter() {
    }

    public static double parseValueAsUnit(String string, Unit<?> unit) {
        double parsedValue = UnitConverter.parseValue(string);
        Unit<?> parsedUnit = UnitConverter.parseUnit(string);
        return parsedUnit.getConverterTo(unit).convert(parsedValue);
    }

    public static double parseValue(String string) {
        Matcher matcher = UnitConverter.matchValueWithUnit(string);
        return Double.parseDouble(matcher.group(1));
    }

    public static Unit<?> parseUnit(String string) {
        Matcher matcher = UnitConverter.matchValueWithUnit(string);
        switch (matcher.group(2)) {
            case "d": {
                return NonSI.DAY;
            }
            case "h": {
                return NonSI.HOUR;
            }
            case "m": {
                return NonSI.MINUTE;
            }
            case "s": {
                return SI.SECOND;
            }
            case "ms": {
                return SI.MILLI((Unit)SI.SECOND);
            }
            case "ns": {
                return SI.NANO((Unit)SI.SECOND);
            }
            case "us": {
                return SI.MICRO((Unit)SI.SECOND);
            }
            case "B": {
                return NonSI.BYTE;
            }
            case "kB": 
            case "KB": {
                return SI.KILO((Unit)NonSI.BYTE);
            }
            case "MB": {
                return SI.MEGA((Unit)NonSI.BYTE);
            }
            case "GB": {
                return SI.GIGA((Unit)NonSI.BYTE);
            }
            case "TB": {
                return SI.TERA((Unit)NonSI.BYTE);
            }
        }
        throw new IllegalArgumentException(string + " unit is not supported");
    }

    public static String format(Unit<?> unit) {
        if (unit.equals((Object)NonSI.BYTE)) {
            return "BYTES";
        }
        if (unit.equals((Object)SI.MILLI((Unit)SI.SECOND))) {
            return "MILLISECONDS";
        }
        throw new IllegalArgumentException(unit + " is not supported");
    }

    private static Matcher matchValueWithUnit(String string) {
        Matcher matcher = VALUE_WITH_UNIT_PATTERN.matcher(string);
        Preconditions.checkState((boolean)matcher.matches(), (String)"String %s does not match value with unit pattern", (Object)string);
        return matcher;
    }
}

