/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc_4.statemachine;

import com.teradata.jdbc.DeferredLob;
import com.teradata.jdbc.jdbc_4.io.TDPacketStream;
import com.teradata.jdbc.jdbc_4.statemachine.ReceiveElicitDataReceivedSubState;
import com.teradata.jdbc.jdbc_4.statemachine.SendState;
import com.teradata.jdbc.jdbc_4.statemachine.StatementAbortState;
import com.teradata.jdbc.jdbc_4.statemachine.StatementController;
import com.teradata.jdbc.jdbc_4.statemachine.StatementReceiveState;
import com.teradata.jdbc.jdbc_4.statemachine.TDParcelState;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import java.io.IOException;
import java.sql.SQLException;

public class LobSendState
extends SendState {
    private DeferredLob lob;
    private int lobToken;
    private TDPacketStream buffer;
    private boolean eof = false;
    private boolean needLength = true;
    private boolean altHeader;
    private long lobBytesSent = 0L;

    public LobSendState(StatementController statementController, int n) {
        super(statementController);
        this.lobToken = n;
        this.altHeader = false;
        this.lobBytesSent = 0L;
    }

    @Override
    public TDParcelState action() throws SQLException {
        int n = 0;
        try {
            if (this.lob == null) {
                this.lob = this.controller.getSession().unregisterDeferredLob(this.lobToken);
                if (this.lob == null) {
                    throw ErrorFactory.makeDriverJDBCException("TJ794", this.lobToken);
                }
                this.altHeader = this.lob.getDeferredLobLength() > 64000L;
            }
        }
        catch (SQLException sQLException) {
            return this.sendAbort(sQLException);
        }
        if (this.controller.getStatement().abortLobTransfer()) {
            return this.sendAbort(null);
        }
        this.initPacket();
        this.buffer = this.packet.getBuffer();
        try {
            n = this.putMultiPartData();
            n += this.putLobData();
            n += this.putLength(n);
            if (this.lob.isDeferredLobAtEof()) {
                n += this.putEndMultiPart();
                this.eof = true;
            }
        }
        catch (SQLException sQLException) {
            return this.sendAbort(sQLException);
        }
        catch (IOException iOException) {
            SQLException sQLException = ErrorFactory.makeDriverJDBCException("TJ363", iOException.getMessage());
            sQLException.initCause(iOException);
            return this.sendAbort(sQLException);
        }
        this.packet.addToMsgLength(n);
        this.sendPacket();
        this.log.debug("Sending " + n + " of data");
        this.log.debug("Total LOB data sent so far: " + this.lobBytesSent);
        return this.returnToController();
    }

    protected void initPacket() throws SQLException {
        this.initializePacket(this.altHeader ? 2 : 1);
        this.packet.setLANClass((byte)2);
        this.packet.setLANKind((byte)13);
        this.packet.setRequestNumber(this.controller.getCurrentRequestNumber());
    }

    private int putMultiPartData() {
        if (this.altHeader) {
            this.buffer.putShort((short)-32628);
        } else {
            this.buffer.putShort((short)140);
        }
        return 2;
    }

    private int putEndMultiPart() {
        if (this.altHeader) {
            this.buffer.putShort((short)-32627);
            this.buffer.putShort((short)0);
            this.buffer.putInt(8);
            return 8;
        }
        this.buffer.putShort((short)141);
        this.buffer.putShort((short)4);
        return 4;
    }

    private int putLength(int n) {
        if (this.altHeader) {
            this.buffer.putShort(54, (short)0);
            this.buffer.putInt(56, n + 6);
            return 6;
        }
        this.buffer.putShort(54, (short)(n + 2));
        return 2;
    }

    private int putLobData() throws IOException, SQLException {
        int n = 0;
        if (this.altHeader) {
            this.buffer.position(60);
        } else {
            this.buffer.position(56);
        }
        if (this.needLength) {
            this.buffer.putLong(0L);
            this.needLength = false;
            n += 8;
        }
        int n2 = this.lob.writeDeferredLob(this.buffer, this.maxSize());
        this.lobBytesSent += (long)n2;
        return n += n2;
    }

    private TDParcelState returnToController() {
        StatementReceiveState statementReceiveState = new StatementReceiveState(this.controller);
        if (!this.eof) {
            ReceiveElicitDataReceivedSubState receiveElicitDataReceivedSubState = new ReceiveElicitDataReceivedSubState(statementReceiveState, this);
            statementReceiveState.setHistoricalState(receiveElicitDataReceivedSubState);
        }
        return statementReceiveState;
    }

    private int maxSize() {
        if (this.altHeader) {
            return 1024000;
        }
        return 64000;
    }

    private TDParcelState sendAbort(SQLException sQLException) throws SQLException {
        this.log.debug("LOBSendState: Sending an Abort Message");
        StatementAbortState statementAbortState = new StatementAbortState(this.controller);
        statementAbortState.setUCAbort(true);
        this.controller.setStoredException(sQLException);
        return statementAbortState;
    }
}

