/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc_4.statemachine;

import com.teradata.jdbc.jdbc_4.parcel.AbortParcel;
import com.teradata.jdbc.jdbc_4.parcel.AbortUCParcel;
import com.teradata.jdbc.jdbc_4.statemachine.SendState;
import com.teradata.jdbc.jdbc_4.statemachine.StatementController;
import com.teradata.jdbc.jdbc_4.statemachine.StatementReceiveState;
import com.teradata.jdbc.jdbc_4.statemachine.TDParcelState;
import java.sql.SQLException;

public class StatementAbortState
extends SendState {
    private boolean abortTimeoutFlag = false;
    private boolean ucAbort = false;

    public StatementAbortState(StatementController statementController) {
        super(statementController);
    }

    @Override
    public TDParcelState action() throws SQLException {
        this.initPacket();
        this.initAbortParcel();
        if (this.controller.getStatement().getState() == 8) {
            this.abortTimeoutFlag = true;
            this.controller.getStatement().setState(9);
        } else {
            this.controller.getStatement().setState(10);
        }
        this.sendPacket();
        return this.returnToController();
    }

    protected void initPacket() throws SQLException {
        this.initializePacket(1);
        this.packet.setLANKind((byte)7);
        this.packet.setRequestNumber(this.controller.getCurrentRequestNumber());
    }

    protected void initAbortParcel() throws SQLException {
        AbortParcel abortParcel = this.ucAbort ? new AbortUCParcel(this.controller.getSession()) : new AbortParcel(this.controller.getSession());
        this.packet.addParcel(abortParcel);
    }

    protected TDParcelState returnToController() {
        if (this.abortTimeoutFlag || this.ucAbort) {
            return new StatementReceiveState(this.controller);
        }
        return null;
    }

    public void setUCAbort(boolean bl) {
        this.ucAbort = bl;
    }
}

