/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc;

import com.teradata.jdbc.ErrorMessage;
import com.teradata.jdbc.URLParameters;
import com.teradata.jdbc.Utility;
import com.teradata.jdbc.encode.Encoder;
import com.teradata.jdbc.jdbc.ConnectionFactory;
import com.teradata.jdbc.jdbc.GenericTeradataConnection;
import com.teradata.jdbc.jdbc_4.logging.Log;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.sql.SQLException;

public class DeviceCodeFlow {
    public static void deviceCodeFlow(GenericTeradataConnection genericTeradataConnection, String string, String string2) throws SQLException {
        String string3;
        String string4;
        String string5;
        URLParameters uRLParameters = genericTeradataConnection.getURLParameters();
        Log log = genericTeradataConnection.getLog();
        if (string != null && string.length() > 0) {
            throw ErrorFactory.makeDriverJDBCException("TJ1572", uRLParameters.getLogMech());
        }
        if (string2 != null && string2.length() > 0) {
            throw ErrorFactory.makeDriverJDBCException("TJ1573", uRLParameters.getLogMech());
        }
        if (uRLParameters.getLogData() != null && uRLParameters.getLogData().length() > 0) {
            throw ErrorFactory.makeDriverJDBCException("TJ1574", "LOGDATA", uRLParameters.getLogMech());
        }
        GenericTeradataConnection genericTeradataConnection2 = ConnectionFactory.makeLogMechNoneConnection(genericTeradataConnection);
        if (genericTeradataConnection2.getGtwConfig() == null || genericTeradataConnection2.getGtwConfig().getIdentityProviderURL() == null || genericTeradataConnection2.getGtwConfig().getIdentityProviderClientID() == null) {
            throw ErrorFactory.makeDriverJDBCException("TJ1579", uRLParameters.getLogMech());
        }
        String string6 = Utility.coalesce(uRLParameters.getOIDCMetadata(), genericTeradataConnection2.getGtwConfig().getIdentityProviderURL());
        String string7 = uRLParameters.getOIDCClientID();
        if (string7 == null) {
            string7 = genericTeradataConnection2.getGtwConfig().getIdentityProviderClientID();
        }
        if ((string5 = uRLParameters.getOIDCScope()) == null) {
            string5 = genericTeradataConnection2.getGtwConfig().getOIDCScope();
        }
        if (string5 == null) {
            string5 = "openid";
        }
        if (log.isDebugEnabled()) {
            log.debug("sIdProURL=" + string6);
            log.debug("sClientID=" + string7);
            log.debug("sOIDCScope=" + string5);
        }
        if ((string6 = string6.replaceFirst("/+$", "")).length() == 0 || string7.length() == 0) {
            throw ErrorFactory.makeDriverJDBCException("TJ1579", uRLParameters.getLogMech());
        }
        String string8 = "/.well-known/openid-configuration";
        if (!string6.toLowerCase().endsWith(string8)) {
            string6 = string6 + string8;
            if (log.isDebugEnabled()) {
                log.debug("Modified sIdProURL=" + string6);
            }
        }
        Utility.HttpResponse httpResponse = Utility.doHttpRequest(uRLParameters, log, "GET", string6, null, null, true, new int[]{200});
        genericTeradataConnection.addExtraClientAttribute("IDPC", httpResponse.sCertStatus);
        String string9 = httpResponse.sBody;
        String string10 = Utility.getStringFromJSON("device_authorization_endpoint", string9, "TJ1544", string6);
        String string11 = Utility.getStringFromJSON("token_endpoint", string9, "TJ1544", string6);
        String string12 = "client_id=" + Utility.safeForURL(string7) + "&scope=" + Utility.safeForURL(string5);
        if (log.isDebugEnabled()) {
            log.debug("sJSON=" + string9);
            log.debug("sAuthURL=" + string10);
            log.debug("sTokenURL=" + string11);
            log.debug("sFormData=" + string12);
        }
        byte[] byArray = Encoder.encodeStringUTF8(string12);
        string9 = Utility.doHttpRequest((URLParameters)uRLParameters, (Log)log, (String)"POST", (String)string10, (String[])new String[]{"Content-Type: application/x-www-form-urlencoded"}, (byte[])byArray, (boolean)true, (int[])new int[]{200}).sBody;
        int n = Utility.getIntFromJSON("interval", string9, null, null, 5) * 1000;
        int n2 = Utility.getIntFromJSON("expires_in", string9, "TJ1575", string10, 0) * 1000;
        String string13 = Utility.getStringFromJSON("device_code", string9, "TJ1552", string10);
        String string14 = Utility.getStringFromJSON("user_code", string9, "TJ1552", string10);
        String string15 = Utility.getStringFromJSON("verification_uri", string9, "TJ1552", string10);
        String string16 = Utility.getStringFromJSON("verification_uri_complete", string9, null, null);
        String string17 = string16 != null ? string16 : string15 + "?user_code=" + Utility.safeForURL(string14);
        string12 = "grant_type=urn:ietf:params:oauth:grant-type:device_code&client_id=" + Utility.safeForURL(string7) + "&device_code=" + Utility.safeForURL(string13);
        String string18 = uRLParameters.getOIDCToken();
        if (log.isDebugEnabled()) {
            log.debug("sJSON=" + string9);
            log.debug("nIntervalInMs=" + n);
            log.debug("nExpiresInMs=" + n2);
            log.debug("sDeviceCode=" + string13);
            log.debug("sUserCode=" + string14);
            log.debug("sVerificationURL=" + string15);
            log.debug("sCompleteURL=" + string16);
            log.debug("sDisplayURL=" + string17);
            log.debug("sFormData=" + string12);
            log.debug("sOIDCToken=" + string18);
        }
        DeviceCodeFlow.displayCodeToUser(uRLParameters, string17, string14);
        byArray = Encoder.encodeStringUTF8(string12);
        while (true) {
            Utility.threadSleep(log, n);
            httpResponse = Utility.doHttpRequest(uRLParameters, log, "POST", string11, new String[]{"Content-Type: application/x-www-form-urlencoded"}, byArray, true, null);
            string9 = httpResponse.sBody;
            if (log.isDebugEnabled()) {
                log.debug("resp.nCode=" + httpResponse.nCode + " resp.sMessage=" + httpResponse.sMessage);
                log.debug("sJSON=" + string9);
            }
            if (httpResponse.nCode == 200) {
                string4 = Utility.getStringFromJSON(string18, string9, "TJ1552", string11);
                if (log.isDebugEnabled()) {
                    log.debug("sJWT=" + string4);
                }
                uRLParameters.changeLogMech("JWT", "token=" + string4);
                return;
            }
            string4 = Utility.getStringFromJSON("error", string9, null, null);
            string3 = Utility.getStringFromJSON("error_description", string9, null, null);
            if (log.isDebugEnabled()) {
                log.debug("sError=" + string4);
                log.debug("sErrorDesc=" + string3);
            }
            if (httpResponse.nCode == 400 && "authorization_pending".equals(string4)) continue;
            if (httpResponse.nCode != 400 || !"slow_down".equals(string4)) break;
            n += 5000;
        }
        String string19 = httpResponse.nCode + (string3 != null ? " " + string3 : (string4 != null ? " " + string4 : (httpResponse.sMessage != null ? " " + httpResponse.sMessage : "")));
        throw ErrorFactory.makeDriverJDBCException("TJ1549", string19, string11);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void displayCodeToUser(URLParameters uRLParameters, String string, String string2) throws SQLException {
        try (PrintStream printStream = null;){
            PrintStream printStream2;
            if (uRLParameters.getCodeAppendFile() == null || "-out".equalsIgnoreCase(uRLParameters.getCodeAppendFile())) {
                printStream2 = System.out;
            } else if ("-err".equalsIgnoreCase(uRLParameters.getCodeAppendFile())) {
                printStream2 = System.err;
            } else {
                try {
                    printStream2 = printStream = new PrintStream(new FileOutputStream(uRLParameters.getCodeAppendFile(), true), true);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    SQLException sQLException = ErrorFactory.makeDriverJDBCException("TJ1578", uRLParameters.getCodeAppendFile(), "CODE_APPEND_FILE");
                    sQLException.initCause(fileNotFoundException);
                    throw sQLException;
                }
            }
            String string3 = Log.currentDateTime();
            printStream2.println(string3);
            printStream2.println(string3 + " -----------------------------------------------------------------------------------------");
            printStream2.println(string3);
            printStream2.println(string3 + " " + ErrorMessage.messages.getString("TJ1576"));
            printStream2.println(string3);
            printStream2.println(string3 + "   " + string);
            printStream2.println(string3);
            printStream2.println(string3 + " " + ErrorMessage.messages.getString("TJ1577"));
            printStream2.println(string3);
            printStream2.println(string3 + "   " + string2);
            printStream2.println(string3);
            printStream2.println(string3 + " -----------------------------------------------------------------------------------------");
            printStream2.println(string3);
        }
    }
}

