/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.tdgss.jgssp2gss;

import com.teradata.tdgss.jgssp2gss.GssCredential;
import com.teradata.tdgss.jgssp2gss.GssMinorStatus;
import com.teradata.tdgss.jgssp2gss.GssUtil;
import com.teradata.tdgss.jgssp2gss.TdSecretKey;
import com.teradata.tdgss.jtdgss.TdgssConfigApi;
import com.teradata.tdgss.jtdgss.TdgssException;
import com.teradata.tdgss.jtdgss.TdgssLogger;
import com.teradata.tdgss.jtdgss.TdgssUtil;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.SecureRandom;
import javax.crypto.SecretKey;
import org.ietf.jgss.ChannelBinding;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.MessageProp;
import org.ietf.jgss.Oid;

public class GssContext
implements GSSContext {
    private final TdgssLogger logger;
    private byte contextInit = 0;
    private byte delegRequest = 0;
    private static final int BYTESININT = 4;
    private static final int BITSPERBYTE = 8;
    private static final byte KEYMSG = 3;
    private static final byte CONFMSG = 4;
    private static final byte LOGDATAMSG = 5;
    private static final byte CLIENT = 0;
    private static final byte SERVER = 1;
    protected static final byte BIT0 = 1;
    private static final byte BIT1 = 2;
    private static final byte BIT2 = 4;
    private static final byte BIT3 = 8;
    private static final byte BIT4 = 16;
    private static final byte CAP_LOGDATA = 2;
    protected static final byte FLAG_BYTE = 8;
    private static final byte INFOLEN = 16;
    private GssCredential cred;
    private GSSContext ctx = null;
    private Oid mechOid = null;
    private int msgsequence;
    private byte gss_or_sspi = 0;
    private byte cli_or_server = 0;
    private static final int KEYLEN = 16;
    private byte krb5_gss = 0;
    private String extlogdata = null;
    private int peercapabilities = 0;

    public GssContext(GSSContext gSSContext, Oid oid, GssCredential gssCredential, TdgssLogger tdgssLogger) throws GSSException {
        if (gSSContext == null) {
            throw new TdgssException(11, GssMinorStatus.GSSP2GSS_ERR_NO_CONTEXT);
        }
        this.logger = tdgssLogger;
        this.ctx = gSSContext;
        this.mechOid = oid;
        this.cred = gssCredential;
        if (gssCredential != null) {
            this.extlogdata = gssCredential.getExtraLogdata();
        }
        if (this.mechOid.toString().equals("1.2.840.113554.1.2.2")) {
            this.gss_or_sspi = 0;
        } else if (this.mechOid.toString().equals("1.3.6.1.4.1.191.1.1012.1.6")) {
            this.gss_or_sspi = 1;
        } else {
            throw new TdgssException(11, GssMinorStatus.GSSP2GSS_ERR_NOT_SSPI_OR_GSS_OID);
        }
        this.msgsequence = 0;
    }

    private byte[] GetMsgInfo(byte by, byte by2, int n) {
        byte[] byArray = new byte[16];
        int n2 = 2;
        byArray[0] = 2;
        byArray[1] = by;
        byArray[2] = by2;
        byArray[3] = this.cli_or_server;
        System.arraycopy(GssUtil.inttobytearray(n), 0, byArray, 4, 4);
        byArray[8] = 3;
        if (this.delegRequest == 1) {
            byArray[8] = (byte)(byArray[8] | 8);
        }
        System.arraycopy(GssUtil.inttobytearray(n2), 0, byArray, 9, 4);
        for (int i = 13; i < 16; ++i) {
            byArray[i] = 0;
        }
        return byArray;
    }

    private int ValidateMsgInfo(byte[] byArray, int n, int n2, byte by, byte by2) throws GSSException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(TdgssUtil.dump("", byArray));
        }
        if (byArray[n + 1] != by) {
            throw new TdgssException(10, GssMinorStatus.GSSP2GSS_ERR_WRONG_MSGINFO);
        }
        byte[] byArray2 = new byte[4];
        System.arraycopy(byArray, n + 4, byArray2, 0, 4);
        BigInteger bigInteger = new BigInteger(byArray2);
        int n3 = bigInteger.intValue();
        if (n2 != n3 + 16) {
            throw new TdgssException(10, GssMinorStatus.GSSP2GSS_ERR_WRONG_MSGINFO);
        }
        if ((byArray[n + 8] & 1) == 1) {
            this.krb5_gss = 1;
        }
        return n3;
    }

    private byte[] GetTrailerBytes() throws GSSException {
        byte[] byArray = null;
        TdgssConfigApi tdgssConfigApi = TdgssConfigApi.getInstance();
        if (tdgssConfigApi == null) {
            throw new TdgssException(11, GssMinorStatus.TDGSS_ERR_CFG_BIN_FILE_NAME_BAD);
        }
        byte[] byArray2 = this.getMech().getDER();
        String[] stringArray = tdgssConfigApi.GetInforForOID(this.getMech().toString());
        Integer[] integerArray = new Integer[5];
        for (int i = 0; i < 5; ++i) {
            integerArray[0] = tdgssConfigApi.GetPropertyForLegal("AlgorithmName", stringArray[0]);
            integerArray[1] = tdgssConfigApi.GetPropertyForLegal("KeyLength", stringArray[1]);
            integerArray[2] = tdgssConfigApi.GetPropertyForLegal("Mode", stringArray[2]);
            integerArray[3] = tdgssConfigApi.GetPropertyForLegal("Padding", stringArray[3]);
            integerArray[4] = tdgssConfigApi.GetPropertyForLegal("AlgorithmName", stringArray[4]);
        }
        String string = "0.0." + integerArray[0] + "." + integerArray[1] + "." + integerArray[2] + "." + integerArray[3] + "." + integerArray[4] + ".0";
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("QOP : " + string);
        }
        Oid oid = new Oid(string);
        byte[] byArray3 = oid.getDER();
        byArray = new byte[byArray2.length + 1 + byArray3.length - 1 + 1 + 4 + 1];
        System.arraycopy(byArray2, 0, byArray, 0, byArray2.length);
        byArray[byArray2.length] = 70;
        System.arraycopy(byArray3, 1, byArray, byArray2.length + 1, byArray3.length - 1);
        byArray[byArray2.length + 1 + byArray3.length - 1] = 1;
        byte[] byArray4 = GssUtil.inttobytearray(byArray.length);
        System.arraycopy(byArray4, 0, byArray, byArray2.length + byArray3.length + 1, 4);
        byArray[byArray2.length + byArray3.length + 1 + 4] = 1;
        return byArray;
    }

    @Override
    public byte[] initSecContext(byte[] byArray, int n, int n2) throws GSSException {
        Object object;
        byte[] byArray2;
        byte[] byArray3 = null;
        byte[] byArray4 = null;
        if (this.contextInit == 0) {
            this.contextInit = 1;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Establishing Context ... ");
        }
        byArray4 = this.GetTrailerBytes();
        if (this.msgsequence == 0) {
            this.cli_or_server = 0;
            if (this.ctx.getCredDelegState()) {
                this.delegRequest = 1;
            }
            this.ctx.requestMutualAuth(true);
            byArray3 = this.ctx.initSecContext(byArray, n, n2);
        } else {
            int n3 = this.ValidateMsgInfo(byArray, n, n2, (byte)2, this.msgsequence == 1 ? (byte)1 : 2);
            if (this.msgsequence == 1) {
                byArray2 = new byte[4];
                System.arraycopy(byArray, n + 8 + 1, byArray2, 0, 4);
                object = new BigInteger(byArray2);
                this.peercapabilities = ((BigInteger)object).intValue();
                if (this.extlogdata != null && (this.peercapabilities & 2) != 2) {
                    throw new TdgssException(11, GssMinorStatus.GSSP2GSS_ERR_NO_LOGDATA_CAPABILITIES);
                }
            }
            byArray3 = this.ctx.initSecContext(byArray, n + 16, n3);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(TdgssUtil.dump("", byArray3));
            }
        }
        if (byArray3 == null) {
            ++this.msgsequence;
            if ((this.peercapabilities & 2) == 2) {
                MessageProp messageProp = new MessageProp(0, true);
                try {
                    byArray2 = this.extlogdata != null ? this.extlogdata.getBytes("UTF8") : "".getBytes("UTF8");
                    byArray3 = this.wrap(byArray2, 0, byArray2.length, messageProp);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.error(unsupportedEncodingException.getMessage());
                    }
                    throw new TdgssException(11, GssMinorStatus.GSSP2GSS_ERR_INVALID_NAME_ENCODING, unsupportedEncodingException);
                }
                int n4 = byArray3.length;
                object = new byte[16 + n4];
                for (int i = 0; i < ((Object)object).length; ++i) {
                    object[i] = false;
                }
                byte[] byArray5 = this.GetMsgInfo((byte)2, (byte)5, n4);
                System.arraycopy(byArray5, 0, object, 0, byArray5.length);
                System.arraycopy(byArray3, 0, object, 16, byArray3.length);
                return object;
            }
            return byArray3;
        }
        byte[] byArray6 = new byte[16 + byArray3.length];
        byArray2 = this.GetMsgInfo((byte)1, this.msgsequence == 0 ? (byte)1 : 2, byArray3.length);
        System.arraycopy(byArray2, 0, byArray6, 0, byArray2.length);
        System.arraycopy(byArray3, 0, byArray6, 16, byArray3.length);
        if (this.msgsequence == 0 && this.gss_or_sspi == 0) {
            object = new byte[16 + byArray3.length + byArray4.length];
            System.arraycopy(byArray6, 0, object, 0, byArray6.length);
            System.arraycopy(byArray4, 0, object, byArray6.length, byArray4.length);
            ++this.msgsequence;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(TdgssUtil.dump("", (byte[])object));
            }
            return object;
        }
        ++this.msgsequence;
        return byArray6;
    }

    @Override
    public int initSecContext(InputStream inputStream, OutputStream outputStream) throws GSSException {
        return this.ctx.initSecContext(inputStream, outputStream);
    }

    @Override
    public byte[] acceptSecContext(byte[] byArray, int n, int n2) throws GSSException {
        if (this.msgsequence == 0) {
            this.cli_or_server = 1;
        }
        int n3 = this.ValidateMsgInfo(byArray, n, n2, (byte)1, this.msgsequence == 0 ? (byte)1 : 2);
        byte[] byArray2 = this.ctx.acceptSecContext(byArray, n + 16, n3);
        byte[] byArray3 = new byte[16 + byArray2.length];
        byte[] byArray4 = this.GetMsgInfo((byte)2, this.msgsequence == 0 ? (byte)1 : 2, byArray2.length);
        System.arraycopy(byArray4, 0, byArray3, 0, byArray4.length);
        System.arraycopy(byArray2, 0, byArray3, 16, byArray2.length);
        ++this.msgsequence;
        return byArray3;
    }

    @Override
    public void acceptSecContext(InputStream inputStream, OutputStream outputStream) throws GSSException {
        this.ctx.acceptSecContext(inputStream, outputStream);
    }

    @Override
    public boolean isEstablished() {
        return this.ctx.isEstablished();
    }

    @Override
    public void dispose() throws GSSException {
        this.ctx.dispose();
    }

    @Override
    public int getWrapSizeLimit(int n, boolean bl, int n2) throws GSSException {
        return this.ctx.getWrapSizeLimit(n, bl, n2 - 8 - 16);
    }

    @Override
    public byte[] wrap(byte[] byArray, int n, int n2, MessageProp messageProp) throws GSSException {
        byte[] byArray2 = this.ctx.wrap(byArray, n, n2, messageProp);
        int n3 = this.krb5_gss == 1 ? byArray2.length : byArray2.length + 8;
        byte[] byArray3 = new byte[16 + n3];
        for (int i = 0; i < byArray3.length; ++i) {
            byArray3[i] = 0;
        }
        byte[] byArray4 = this.GetMsgInfo((byte)3, (byte)2, n3);
        System.arraycopy(byArray4, 0, byArray3, 0, byArray4.length);
        System.arraycopy(byArray2, 0, byArray3, 16, byArray2.length);
        return byArray3;
    }

    @Override
    public void wrap(InputStream inputStream, OutputStream outputStream, MessageProp messageProp) throws GSSException {
        this.ctx.wrap(inputStream, outputStream, messageProp);
    }

    @Override
    public byte[] unwrap(byte[] byArray, int n, int n2, MessageProp messageProp) throws GSSException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("UNWRAP ");
        }
        int n3 = this.ValidateMsgInfo(byArray, n, n2, (byte)3, (byte)2);
        if (this.krb5_gss == 1) {
            return this.ctx.unwrap(byArray, n + 16, n3, messageProp);
        }
        return this.ctx.unwrap(byArray, n + 16, n3 - 8, messageProp);
    }

    @Override
    public void unwrap(InputStream inputStream, OutputStream outputStream, MessageProp messageProp) throws GSSException {
        this.ctx.unwrap(inputStream, outputStream, messageProp);
    }

    @Override
    public byte[] getMIC(byte[] byArray, int n, int n2, MessageProp messageProp) throws GSSException {
        byte[] byArray2 = this.ctx.getMIC(byArray, n, n2, messageProp);
        byte[] byArray3 = this.GetMsgInfo((byte)4, (byte)2, byArray2.length);
        byte[] byArray4 = new byte[16 + byArray2.length];
        System.arraycopy(byArray3, 0, byArray4, 0, byArray3.length);
        System.arraycopy(byArray2, 0, byArray4, 16, byArray2.length);
        return byArray4;
    }

    @Override
    public void getMIC(InputStream inputStream, OutputStream outputStream, MessageProp messageProp) throws GSSException {
        this.ctx.getMIC(inputStream, outputStream, messageProp);
    }

    @Override
    public void verifyMIC(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4, MessageProp messageProp) throws GSSException {
        int n5 = this.ValidateMsgInfo(byArray, n, n2, (byte)4, (byte)2);
        if (n2 != n5 + 16) {
            throw new TdgssException(6, GssMinorStatus.GSSP2GSS_ERR_CANT_VERIFY_MIC);
        }
        this.ctx.verifyMIC(byArray, n + 16, n5, byArray2, n3, n4, messageProp);
    }

    @Override
    public void verifyMIC(InputStream inputStream, InputStream inputStream2, MessageProp messageProp) throws GSSException {
        this.ctx.verifyMIC(inputStream, inputStream2, messageProp);
    }

    @Override
    public byte[] export() throws GSSException {
        return this.ctx.export();
    }

    @Override
    public void requestMutualAuth(boolean bl) throws GSSException {
        if (this.isEstablished()) {
            throw new TdgssException(11, GssMinorStatus.GSSP2GSS_ERR_INVALID_REQUEST);
        }
        this.ctx.requestMutualAuth(bl);
    }

    @Override
    public void requestReplayDet(boolean bl) throws GSSException {
        if (this.isEstablished()) {
            throw new TdgssException(11, GssMinorStatus.GSSP2GSS_ERR_INVALID_REQUEST);
        }
        this.ctx.requestReplayDet(bl);
    }

    @Override
    public void requestSequenceDet(boolean bl) throws GSSException {
        if (this.isEstablished()) {
            throw new TdgssException(11, GssMinorStatus.GSSP2GSS_ERR_INVALID_REQUEST);
        }
        this.ctx.requestSequenceDet(bl);
    }

    @Override
    public void requestCredDeleg(boolean bl) throws GSSException {
        if (this.isEstablished()) {
            throw new TdgssException(11, GssMinorStatus.GSSP2GSS_ERR_INVALID_REQUEST);
        }
        this.ctx.requestCredDeleg(bl);
        this.ctx.requestMutualAuth(bl);
    }

    @Override
    public void requestAnonymity(boolean bl) throws GSSException {
        if (this.isEstablished()) {
            throw new TdgssException(11, GssMinorStatus.GSSP2GSS_ERR_INVALID_REQUEST);
        }
        this.ctx.requestAnonymity(bl);
    }

    @Override
    public void requestConf(boolean bl) throws GSSException {
        if (this.isEstablished()) {
            throw new TdgssException(11, GssMinorStatus.GSSP2GSS_ERR_INVALID_REQUEST);
        }
        this.ctx.requestConf(bl);
    }

    @Override
    public void requestInteg(boolean bl) throws GSSException {
        if (this.isEstablished()) {
            throw new TdgssException(11, GssMinorStatus.GSSP2GSS_ERR_INVALID_REQUEST);
        }
        this.ctx.requestInteg(bl);
    }

    @Override
    public void requestLifetime(int n) throws GSSException {
        if (this.isEstablished()) {
            throw new TdgssException(11, GssMinorStatus.GSSP2GSS_ERR_INVALID_REQUEST);
        }
        this.ctx.requestLifetime(n);
    }

    @Override
    public void setChannelBinding(ChannelBinding channelBinding) throws GSSException {
        this.ctx.setChannelBinding(channelBinding);
    }

    @Override
    public boolean getCredDelegState() {
        return this.contextInit == 0 ? false : this.ctx.getCredDelegState();
    }

    @Override
    public boolean getMutualAuthState() {
        return this.contextInit == 0 ? false : this.ctx.getMutualAuthState();
    }

    @Override
    public boolean getReplayDetState() {
        return this.contextInit == 0 ? false : this.ctx.getReplayDetState();
    }

    @Override
    public boolean getSequenceDetState() {
        return this.contextInit == 0 ? false : this.ctx.getSequenceDetState();
    }

    @Override
    public boolean getAnonymityState() {
        return false;
    }

    @Override
    public boolean getConfState() {
        return this.contextInit == 0 ? false : this.ctx.getConfState();
    }

    @Override
    public boolean getIntegState() {
        return this.contextInit == 0 ? false : this.ctx.getIntegState();
    }

    @Override
    public int getLifetime() {
        return this.contextInit == 0 ? 0 : this.ctx.getLifetime();
    }

    @Override
    public boolean isTransferable() throws GSSException {
        if (this.contextInit == 0) {
            throw new TdgssException(11, GssMinorStatus.GSSP2GSS_ERR_NO_CONTEXT);
        }
        return false;
    }

    @Override
    public boolean isProtReady() {
        return this.contextInit == 0 ? false : this.isEstablished();
    }

    @Override
    public GSSName getSrcName() throws GSSException {
        return this.ctx.getSrcName();
    }

    @Override
    public GSSName getTargName() throws GSSException {
        return this.ctx.getTargName();
    }

    @Override
    public Oid getMech() throws GSSException {
        return this.mechOid;
    }

    @Override
    public GSSCredential getDelegCred() throws GSSException {
        return this.contextInit == 0 ? null : this.ctx.getDelegCred();
    }

    @Override
    public boolean isInitiator() throws GSSException {
        return this.ctx.isInitiator();
    }

    public byte[] GenerateKey() throws GSSException {
        byte[] byArray = new byte[16];
        try {
            SecureRandom secureRandom = new SecureRandom();
            secureRandom.nextBytes(byArray);
        }
        catch (Exception exception) {
            throw new TdgssException(11, GssMinorStatus.GSSP2GSS_ERR_GENERATE_SECRET_KEY, exception);
        }
        return byArray;
    }

    public GSSCredential getCredential() {
        return this.cred;
    }

    public SecretKey BytetoKey(String string, byte[] byArray, int n, int n2) {
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        TdSecretKey tdSecretKey = new TdSecretKey(string, byArray2);
        return tdSecretKey;
    }
}

