/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.client;

import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ClientBlob
implements Blob {
    private boolean m_bFreed = false;
    private static final int MAX_BUFFER_SIZE = 0x100000;
    private List<byte[]> m_bufferList = new ArrayList<byte[]>();
    private final Object lock = new Object();
    private long m_nTotalSize = 0L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void free() throws SQLException {
        Object object = this.lock;
        synchronized (object) {
            if (this.m_bFreed) {
                return;
            }
            this.m_bFreed = true;
            this.m_bufferList.clear();
            this.m_nTotalSize = 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long length() throws SQLException {
        Object object = this.lock;
        synchronized (object) {
            this.verifyFreedStatus();
            return this.m_nTotalSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getBinaryStream() throws SQLException {
        Object object = this.lock;
        synchronized (object) {
            this.verifyFreedStatus();
            return this.getBinaryStream(1L, this.m_nTotalSize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getBinaryStream(long l, long l2) throws SQLException {
        Object object = this.lock;
        synchronized (object) {
            this.verifyFreedStatus();
            if (l < 1L || l2 < 0L) {
                throw ErrorFactory.makeDriverJDBCException("TJ218", "Blob.getBinaryStream");
            }
            if (l + l2 > this.m_nTotalSize + 1L) {
                throw ErrorFactory.makeDriverJDBCException("TJ219", "Blob.getBinaryStream");
            }
            if (l - 1L + l2 > this.m_nTotalSize) {
                l2 = this.m_nTotalSize - (l - 1L);
            }
            return new BlobInputStream(l - 1L, l2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getBytes(long l, int n) throws SQLException {
        Object object = this.lock;
        synchronized (object) {
            this.verifyFreedStatus();
            if (l < 1L || n < 0) {
                throw ErrorFactory.makeDriverJDBCException("TJ218", "Blob.getBytes");
            }
            if (n == 0 || l > this.m_nTotalSize) {
                return new byte[0];
            }
            if ((long)n + l > this.m_nTotalSize + 1L) {
                n = (int)this.m_nTotalSize - (int)l + 1;
            }
            byte[] byArray = new byte[n];
            long l2 = l - 1L;
            long l3 = 0L;
            while (l3 < (long)n) {
                int n2 = (int)l2 / 0x100000;
                int n3 = (int)l2 % 0x100000;
                byte[] byArray2 = this.m_bufferList.get(n2);
                int n4 = Math.min(n - (int)l3, 0x100000 - n3);
                System.arraycopy(byArray2, n3, byArray, (int)l3, n4);
                l3 += (long)n4;
                l2 += (long)n4;
            }
            return byArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long position(byte[] byArray, long l) throws SQLException {
        Object object = this.lock;
        synchronized (object) {
            this.verifyFreedStatus();
            if (byArray == null) {
                throw ErrorFactory.makeDriverJDBCException("TJ516", "ClientBlob.position");
            }
            if (l < 1L) {
                throw ErrorFactory.makeDriverJDBCException("TJ218", "position");
            }
            if (l + (long)byArray.length > this.m_nTotalSize + 1L) {
                return -1L;
            }
            long l2 = this.m_nTotalSize - (long)byArray.length + 1L;
            for (long i = l; i <= l2; ++i) {
                if (!this.matchesPattern(i - 1L, byArray)) continue;
                return i;
            }
            return -1L;
        }
    }

    @Override
    public long position(Blob blob, long l) throws SQLException {
        return this.position(blob == null ? null : blob.getBytes(1L, (int)blob.length()), l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void truncate(long l) throws SQLException {
        Object object = this.lock;
        synchronized (object) {
            this.verifyFreedStatus();
            if (l < 0L) {
                throw ErrorFactory.makeDriverJDBCException("TJ218", "Blob.truncate");
            }
            if (l >= this.m_nTotalSize) {
                return;
            }
            long l2 = (l + 0x100000L - 1L) / 0x100000L;
            while ((long)this.m_bufferList.size() > l2) {
                this.m_bufferList.remove(this.m_bufferList.size() - 1);
            }
            if (this.m_bufferList.size() > 0) {
                int n = this.m_bufferList.size() - 1;
                byte[] byArray = this.m_bufferList.get(n);
                int n2 = (int)(l % 0x100000L);
                if (n2 == 0) {
                    n2 = 0x100000;
                }
                Arrays.fill(byArray, n2, byArray.length, (byte)0);
            }
        }
        this.m_nTotalSize = l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OutputStream setBinaryStream(long l) throws SQLException {
        Object object = this.lock;
        synchronized (object) {
            this.verifyFreedStatus();
            if (l <= 0L) {
                throw ErrorFactory.makeDriverJDBCException("TJ218", "Blob.setBinaryStream");
            }
            return new BlobOutputStream(l - 1L);
        }
    }

    @Override
    public int setBytes(long l, byte[] byArray) throws SQLException {
        return this.setBytes(l, byArray, 0, byArray == null ? 0 : byArray.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int setBytes(long l, byte[] byArray, int n, int n2) throws SQLException {
        Object object = this.lock;
        synchronized (object) {
            this.verifyFreedStatus();
            if (byArray == null) {
                throw ErrorFactory.makeDriverJDBCException("TJ516", "Blob.setBytes");
            }
            if (l < 1L || n2 < 0) {
                throw ErrorFactory.makeDriverJDBCException("TJ218", "Blob.setBytes");
            }
            if (n2 == 0 || n >= byArray.length) {
                return 0;
            }
            if (n + n2 > byArray.length) {
                n2 = byArray.length - n;
            }
            long l2 = l - 1L;
            long l3 = Math.max(this.m_nTotalSize, l2 + (long)n2);
            this.ensureCapacity(l3);
            int n3 = 0;
            while (n3 < n2) {
                int n4 = (int)(l2 / 0x100000L);
                int n5 = (int)(l2 % 0x100000L);
                byte[] byArray2 = this.m_bufferList.get(n4);
                int n6 = Math.min(n2 - n3, 0x100000 - n5);
                System.arraycopy(byArray, n + n3, byArray2, n5, n6);
                n3 += n6;
                l2 += (long)n6;
            }
            this.m_nTotalSize = l3;
            return n2;
        }
    }

    private void ensureCapacity(long l) {
        while (l > (long)(this.m_bufferList.size() * 0x100000)) {
            this.m_bufferList.add(new byte[0x100000]);
        }
    }

    private boolean matchesPattern(long l, byte[] byArray) {
        long l2 = l;
        for (int i = 0; i < byArray.length; ++i) {
            int n = (int)l2 / 0x100000;
            int n2 = (int)l2 % 0x100000;
            byte[] byArray2 = this.m_bufferList.get(n);
            if (byArray2[n2] != byArray[i]) {
                return false;
            }
            ++l2;
        }
        return true;
    }

    private void verifyFreedStatus() throws SQLException {
        if (this.m_bFreed) {
            throw ErrorFactory.makeDriverJDBCException("TJ760");
        }
    }

    private void verifyParameters(String string, boolean bl, Object object, int n, int n2, int n3) throws IOException, NullPointerException, IndexOutOfBoundsException {
        if (bl) {
            SQLException sQLException = ErrorFactory.makeDriverJDBCException("TJ550", string);
            throw new IOException(sQLException.getErrorCode() + ": " + sQLException);
        }
        if (object == null) {
            SQLException sQLException = ErrorFactory.makeDriverJDBCException("TJ516", string);
            throw new NullPointerException(sQLException.getErrorCode() + ": " + sQLException);
        }
        if (n < 0 || n2 < 0) {
            SQLException sQLException = ErrorFactory.makeDriverJDBCException("TJ218", string);
            throw new IndexOutOfBoundsException(sQLException.getErrorCode() + ": " + sQLException);
        }
        if (n2 > n3 - n) {
            SQLException sQLException = ErrorFactory.makeDriverJDBCException("TJ219", string);
            throw new IndexOutOfBoundsException(sQLException.getErrorCode() + ": " + sQLException);
        }
    }

    public class BlobOutputStream
    extends OutputStream {
        private long m_nStreamPosition;
        private boolean m_bClosed = false;

        public BlobOutputStream(long l) throws SQLException {
            this.m_nStreamPosition = l;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            Object object = ClientBlob.this.lock;
            synchronized (object) {
                this.m_bClosed = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(int n) throws IOException {
            Object object = ClientBlob.this.lock;
            synchronized (object) {
                if (this.m_bClosed) {
                    SQLException sQLException = ErrorFactory.makeDriverJDBCException("TJ550", "BlobOutputStream.write");
                    throw new IOException(sQLException.getErrorCode() + ": " + sQLException);
                }
                ClientBlob.this.ensureCapacity(this.m_nStreamPosition + 1L);
                int n2 = (int)this.m_nStreamPosition / 0x100000;
                int n3 = (int)this.m_nStreamPosition % 0x100000;
                byte[] byArray = (byte[])ClientBlob.this.m_bufferList.get(n2);
                byArray[n3] = (byte)n;
                ++this.m_nStreamPosition;
                if (this.m_nStreamPosition > ClientBlob.this.m_nTotalSize) {
                    ClientBlob.this.m_nTotalSize = this.m_nStreamPosition;
                }
            }
        }

        @Override
        public void write(byte[] byArray) throws IOException {
            this.write(byArray, 0, byArray == null ? 0 : byArray.length);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(byte[] byArray, int n, int n2) throws IOException {
            Object object = ClientBlob.this.lock;
            synchronized (object) {
                ClientBlob.this.verifyParameters("ClientBlob@BlobOutputStream.write", this.m_bClosed, byArray, n, n2, byArray == null ? 0 : byArray.length);
                ClientBlob.this.ensureCapacity(this.m_nStreamPosition + (long)n2);
                int n3 = 0;
                long l = this.m_nStreamPosition;
                while (n3 < n2) {
                    int n4 = (int)this.m_nStreamPosition / 0x100000;
                    int n5 = (int)(this.m_nStreamPosition % 0x100000L);
                    byte[] byArray2 = (byte[])ClientBlob.this.m_bufferList.get(n4);
                    int n6 = Math.min(n2 - n3, 0x100000 - n5);
                    System.arraycopy(byArray, n + n3, byArray2, n5, n6);
                    n3 += n6;
                    this.m_nStreamPosition += (long)n6;
                }
                if ((long)n3 + l > ClientBlob.this.m_nTotalSize) {
                    ClientBlob.this.m_nTotalSize = (long)n3 + l;
                }
            }
        }
    }

    public class BlobInputStream
    extends InputStream {
        private long m_nPos;
        private final long m_nEndPosition;
        private boolean m_bClosed = false;

        public BlobInputStream(long l, long l2) {
            this.m_nPos = l;
            this.m_nEndPosition = l + l2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read() throws IOException {
            Object object = ClientBlob.this.lock;
            synchronized (object) {
                if (this.m_bClosed) {
                    SQLException sQLException = ErrorFactory.makeDriverJDBCException("TJ550", "BlobInputStream.read");
                    throw new IOException(sQLException.getErrorCode() + ": " + sQLException);
                }
                if (this.m_nPos >= this.m_nEndPosition) {
                    return -1;
                }
                int n = (int)this.m_nPos / 0x100000;
                int n2 = (int)this.m_nPos % 0x100000;
                byte[] byArray = (byte[])ClientBlob.this.m_bufferList.get(n);
                int n3 = byArray[n2] & 0xFF;
                ++this.m_nPos;
                return n3;
            }
        }

        @Override
        public int read(byte[] byArray) throws IOException {
            return this.read(byArray, 0, byArray == null ? 0 : byArray.length);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read(byte[] byArray, int n, int n2) throws IOException {
            Object object = ClientBlob.this.lock;
            synchronized (object) {
                ClientBlob.this.verifyParameters("ClientBlob@BlobInputStream.read", this.m_bClosed, byArray, n, n2, byArray == null ? 0 : byArray.length);
                if (this.m_nPos >= this.m_nEndPosition) {
                    return -1;
                }
                n2 = (int)Math.min((long)n2, this.m_nEndPosition - this.m_nPos);
                int n3 = 0;
                while (n3 < n2) {
                    int n4 = (int)this.m_nPos / 0x100000;
                    int n5 = (int)this.m_nPos % 0x100000;
                    byte[] byArray2 = (byte[])ClientBlob.this.m_bufferList.get(n4);
                    int n6 = Math.min(n2 - n3, 0x100000 - n5);
                    System.arraycopy(byArray2, n5, byArray, n + n3, n6);
                    n3 += n6;
                    this.m_nPos += (long)n6;
                }
                return n3;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            Object object = ClientBlob.this.lock;
            synchronized (object) {
                this.m_bClosed = true;
            }
        }
    }
}

