/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.encode;

import com.teradata.jdbc.ResultSetHelper;
import com.teradata.jdbc.encode.ConnectionCharsetInfo;
import com.teradata.jdbc.jdbc.GenericTeradataConnection;
import com.teradata.jdbc.jdbc_4.logging.Log;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.sql.SQLException;

public class Encoder {
    public static final int NO_INDEX = -1;
    public static final int NO_ROW_NUMBER = -1;
    private boolean m_bStrictEncode = false;
    private String m_sCharsetName = null;
    private CharsetEncoder m_charsetEncoder = null;
    private CharBuffer m_charBuf = null;
    private byte[] m_abyCharBuf = null;
    private int m_nCharBufLenWritten = 0;

    public Encoder(GenericTeradataConnection genericTeradataConnection, boolean bl) throws SQLException {
        this.m_bStrictEncode = genericTeradataConnection.isStrictEncode();
        String string = this.m_sCharsetName = bl ? "UTF8" : genericTeradataConnection.getCharsetInfo().getSerializeDeserializeCharsetName();
        if (!this.m_bStrictEncode) {
            return;
        }
        CodingErrorAction codingErrorAction = CodingErrorAction.REPORT;
        ThreadLocal threadLocal = bl ? genericTeradataConnection.getCharsetInfo().getUTF8CharsetEncoderReport() : genericTeradataConnection.getCharsetInfo().getCharsetEncoderReport();
        try {
            this.m_charsetEncoder = (CharsetEncoder)ConnectionCharsetInfo.deref(threadLocal);
            if (this.m_charsetEncoder == null) {
                this.m_charsetEncoder = bl ? genericTeradataConnection.getCharsetInfo().getUTF8Charset().newEncoder().onMalformedInput(codingErrorAction).onUnmappableCharacter(codingErrorAction).replaceWith(ConnectionCharsetInfo.REPLACE_WITH_QUESTION_MARK_UTF8) : genericTeradataConnection.getCharsetInfo().getSerializeDeseralizeCharset().newEncoder().onMalformedInput(codingErrorAction).onUnmappableCharacter(codingErrorAction).replaceWith(genericTeradataConnection.getCharsetInfo().getReplacementBytes());
                ConnectionCharsetInfo.set(threadLocal, this.m_charsetEncoder);
            }
        }
        catch (Exception exception) {
            SQLException sQLException = ErrorFactory.makeDriverJDBCException("TJ670", this.m_sCharsetName);
            sQLException.initCause(exception);
            throw sQLException;
        }
    }

    private static byte[] trimByteArrayToSize(byte[] byArray, int n) {
        if (n == byArray.length) {
            return byArray;
        }
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, 0, byArray2, 0, n);
        return byArray2;
    }

    static int scale(int n, float f) {
        return (int)((double)n * (double)f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    private boolean beginEncode(CharBuffer charBuffer, ByteBuffer byteBuffer, String string, int n, String[] stringArray, long l) throws SQLException, IOException {
        this.m_charBuf = charBuffer;
        if (!this.m_bStrictEncode) {
            byte[] byArray = byteBuffer.array();
            try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(byArray.length);){
                boolean bl;
                BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)byteArrayOutputStream, this.m_sCharsetName));
                try {
                    bufferedWriter.write(this.m_charBuf.array(), this.m_charBuf.position(), this.m_charBuf.limit());
                    bufferedWriter.flush();
                    this.m_charBuf.position(this.m_charBuf.limit());
                    this.m_abyCharBuf = byteArrayOutputStream.toByteArray();
                    this.m_nCharBufLenWritten = Math.min(this.m_abyCharBuf.length, byArray.length - byteBuffer.position());
                    System.arraycopy(this.m_abyCharBuf, 0, byArray, byteBuffer.position(), this.m_nCharBufLenWritten);
                    byteBuffer.position(byteBuffer.position() + this.m_nCharBufLenWritten);
                    bl = this.m_abyCharBuf.length > this.m_nCharBufLenWritten;
                }
                catch (Throwable throwable) {
                    bufferedWriter.close();
                    throw throwable;
                }
                bufferedWriter.close();
                return bl;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                SQLException sQLException = ErrorFactory.makeDriverJDBCException("TJ212", this.m_sCharsetName);
                sQLException.initCause(unsupportedEncodingException);
                throw sQLException;
            }
        }
        this.m_charsetEncoder.reset();
        try {
            CoderResult coderResult = this.m_charsetEncoder.encode(this.m_charBuf, byteBuffer, true);
            if (coderResult.isError()) {
                try {
                    coderResult.throwException();
                }
                catch (CharacterCodingException characterCodingException) {
                    String string2 = Log.leadingZeros(Integer.toHexString(this.m_charBuf.charAt(0)), 4);
                    SQLException sQLException = stringArray != null ? ErrorFactory.makeDriverJDBCException(string, stringArray[0], stringArray[1], string2, String.valueOf(l + (long)this.m_charBuf.position()), this.m_sCharsetName) : (n == -1 ? ErrorFactory.makeDriverJDBCException(string, string2, String.valueOf(l + (long)this.m_charBuf.position()), this.m_sCharsetName) : ErrorFactory.makeDriverJDBCException(string, String.valueOf(n), string2, String.valueOf(l + (long)this.m_charBuf.position()), this.m_sCharsetName));
                    sQLException.initCause(characterCodingException);
                    throw sQLException;
                }
            }
            return coderResult.isOverflow();
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            SQLException sQLException = ErrorFactory.makeDriverJDBCException("TJ670", this.m_sCharsetName);
            sQLException.initCause(exception);
            throw sQLException;
        }
    }

    private boolean continueEncode(ByteBuffer byteBuffer, String string, int n, String[] stringArray, long l) throws SQLException {
        if (!this.m_bStrictEncode) {
            byte[] byArray = byteBuffer.array();
            int n2 = Math.min(this.m_abyCharBuf.length - this.m_nCharBufLenWritten, byArray.length - byteBuffer.position());
            System.arraycopy(this.m_abyCharBuf, this.m_nCharBufLenWritten, byArray, byteBuffer.position(), n2);
            byteBuffer.position(n2);
            this.m_nCharBufLenWritten += n2;
            return this.m_abyCharBuf.length > this.m_nCharBufLenWritten;
        }
        try {
            CoderResult coderResult = this.m_charsetEncoder.encode(this.m_charBuf, byteBuffer, true);
            if (coderResult.isError()) {
                try {
                    coderResult.throwException();
                }
                catch (CharacterCodingException characterCodingException) {
                    String string2 = Log.leadingZeros(Integer.toHexString(this.m_charBuf.charAt(0)), 4);
                    SQLException sQLException = stringArray != null ? ErrorFactory.makeDriverJDBCException(string, stringArray[0], stringArray[1], string2, String.valueOf(l + (long)this.m_charBuf.position()), this.m_sCharsetName) : (n == -1 ? ErrorFactory.makeDriverJDBCException(string, string2, String.valueOf(l + (long)this.m_charBuf.position()), this.m_sCharsetName) : ErrorFactory.makeDriverJDBCException(string, String.valueOf(n), string2, String.valueOf(l + (long)this.m_charBuf.position()), this.m_sCharsetName));
                    sQLException.initCause(characterCodingException);
                    throw sQLException;
                }
            }
            return coderResult.isOverflow();
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            SQLException sQLException = ErrorFactory.makeDriverJDBCException("TJ670", this.m_sCharsetName);
            sQLException.initCause(exception);
            throw sQLException;
        }
    }

    public boolean beginEncodeStream(CharBuffer charBuffer, ByteBuffer byteBuffer, int n, int n2, String[] stringArray, long l) throws SQLException, IOException {
        return stringArray != null ? this.beginEncode(charBuffer, byteBuffer, "TJ716", -1, stringArray, l) : (n == -1 && n2 == -1 ? this.beginEncode(charBuffer, byteBuffer, "TJ676", -1, null, l) : (n2 == -1 ? this.beginEncode(charBuffer, byteBuffer, "TJ675", n, null, l) : this.beginEncode(charBuffer, byteBuffer, "TJ714", n2, null, l)));
    }

    public boolean continueEncodeStream(ByteBuffer byteBuffer, int n, int n2, String[] stringArray, long l) throws SQLException {
        return stringArray != null ? this.continueEncode(byteBuffer, "TJ716", -1, stringArray, l) : (n == -1 && n2 == -1 ? this.continueEncode(byteBuffer, "TJ676", -1, null, l) : (n2 == -1 ? this.continueEncode(byteBuffer, "TJ675", n, null, l) : this.continueEncode(byteBuffer, "TJ714", n2, null, l)));
    }

    private static byte[] getEncodedByteArray(ConnectionCharsetInfo connectionCharsetInfo, String string, String string2, int n, int n2, String[] stringArray, int[] nArray, boolean bl, long l) throws SQLException {
        if (string.length() == 0) {
            return new byte[0];
        }
        if (!bl) {
            try {
                return string.getBytes(connectionCharsetInfo.getSerializeDeserializeCharsetName());
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                SQLException sQLException = ErrorFactory.makeDriverJDBCException("TJ212", connectionCharsetInfo.getSerializeDeserializeCharsetName());
                sQLException.initCause(unsupportedEncodingException);
                throw sQLException;
            }
        }
        char[] cArray = string.toCharArray();
        CharBuffer charBuffer = CharBuffer.wrap(cArray, 0, cArray.length);
        Charset charset = connectionCharsetInfo.getSerializeDeseralizeCharset();
        CodingErrorAction codingErrorAction = string2 != null ? CodingErrorAction.REPORT : CodingErrorAction.REPLACE;
        ThreadLocal threadLocal = string2 != null ? connectionCharsetInfo.getCharsetEncoderReport() : connectionCharsetInfo.getCharsetEncoderReplace();
        try {
            CharsetEncoder charsetEncoder = (CharsetEncoder)ConnectionCharsetInfo.deref(threadLocal);
            if (charsetEncoder == null) {
                charsetEncoder = charset.newEncoder().onMalformedInput(codingErrorAction).onUnmappableCharacter(codingErrorAction).replaceWith(connectionCharsetInfo.getReplacementBytes());
                ConnectionCharsetInfo.set(threadLocal, charsetEncoder);
            }
            charsetEncoder.reset();
            byte[] byArray = new byte[Encoder.scale(cArray.length, charsetEncoder.maxBytesPerChar())];
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray, 0, byArray.length);
            CoderResult coderResult = charsetEncoder.encode(charBuffer, byteBuffer, true);
            if (!coderResult.isUnderflow()) {
                coderResult.throwException();
            }
            if (!(coderResult = charsetEncoder.flush(byteBuffer)).isUnderflow()) {
                coderResult.throwException();
            }
            return Encoder.trimByteArrayToSize(byArray, byteBuffer.position());
        }
        catch (CharacterCodingException characterCodingException) {
            String string3 = Log.leadingZeros(Integer.toHexString(charBuffer.charAt(0)), 4);
            SQLException sQLException = stringArray != null ? ErrorFactory.makeDriverJDBCException(string2, stringArray[0], stringArray[1], string3, String.valueOf(l + (long)charBuffer.position()), connectionCharsetInfo.getSerializeDeserializeCharsetName()) : (n == -1 ? ErrorFactory.makeDriverJDBCException(string2, string3, String.valueOf(l + (long)charBuffer.position()), connectionCharsetInfo.getSerializeDeserializeCharsetName()) : (nArray != null ? ErrorFactory.makeDriverJDBCException(string2, String.valueOf(n), Encoder.formatArrayIndexes(nArray), string3, String.valueOf(l + (long)charBuffer.position()), connectionCharsetInfo.getSerializeDeserializeCharsetName()) : (n2 == -1 ? ErrorFactory.makeDriverJDBCException(string2, String.valueOf(n), string3, String.valueOf(l + (long)charBuffer.position()), connectionCharsetInfo.getSerializeDeserializeCharsetName()) : ErrorFactory.makeDriverJDBCException(string2, String.valueOf(n), String.valueOf(n2), string3, String.valueOf(l + (long)charBuffer.position()), connectionCharsetInfo.getSerializeDeserializeCharsetName()))));
            sQLException.initCause(characterCodingException);
            throw sQLException;
        }
        catch (Exception exception) {
            SQLException sQLException = ErrorFactory.makeDriverJDBCException("TJ670", connectionCharsetInfo.getSerializeDeserializeCharsetName());
            sQLException.initCause(exception);
            throw sQLException;
        }
    }

    private static String formatArrayIndexes(int[] nArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = nArray.length - 1; i >= 0; --i) {
            stringBuffer.append("[");
            stringBuffer.append(nArray[i]);
            stringBuffer.append("]");
        }
        return stringBuffer.toString();
    }

    public static byte[] encodeStringUTF8(String string) {
        if (string.length() == 0) {
            return new byte[0];
        }
        try {
            return string.getBytes("UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(unsupportedEncodingException.toString());
            illegalArgumentException.initCause(unsupportedEncodingException);
            throw illegalArgumentException;
        }
    }

    private static byte[] getAsciiEncodedByteArray(ConnectionCharsetInfo connectionCharsetInfo, String string, String string2, int n, String[] stringArray, boolean bl, long l) throws SQLException {
        if (string.length() == 0) {
            return new byte[0];
        }
        if (!bl) {
            try {
                return string.getBytes("ASCII");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                SQLException sQLException = ErrorFactory.makeDriverJDBCException("TJ212", "ASCII");
                sQLException.initCause(unsupportedEncodingException);
                throw sQLException;
            }
        }
        char[] cArray = string.toCharArray();
        CharBuffer charBuffer = CharBuffer.wrap(cArray, 0, cArray.length);
        Charset charset = connectionCharsetInfo.getAsciiCharset();
        CodingErrorAction codingErrorAction = string2 != null ? CodingErrorAction.REPORT : CodingErrorAction.REPLACE;
        ThreadLocal threadLocal = string2 != null ? connectionCharsetInfo.getAsciiCharsetEncoderReport() : connectionCharsetInfo.getAsciiCharsetEncoderReplace();
        try {
            CharsetEncoder charsetEncoder = (CharsetEncoder)ConnectionCharsetInfo.deref(threadLocal);
            if (charsetEncoder == null) {
                charsetEncoder = charset.newEncoder().onMalformedInput(codingErrorAction).onUnmappableCharacter(codingErrorAction).replaceWith(ConnectionCharsetInfo.REPLACE_WITH_QUESTION_MARK_ASCII);
                ConnectionCharsetInfo.set(threadLocal, charsetEncoder);
            }
            charsetEncoder.reset();
            byte[] byArray = new byte[Encoder.scale(cArray.length, charsetEncoder.maxBytesPerChar())];
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray, 0, byArray.length);
            CoderResult coderResult = charsetEncoder.encode(charBuffer, byteBuffer, true);
            if (!coderResult.isUnderflow()) {
                coderResult.throwException();
            }
            if (!(coderResult = charsetEncoder.flush(byteBuffer)).isUnderflow()) {
                coderResult.throwException();
            }
            return Encoder.trimByteArrayToSize(byArray, byteBuffer.position());
        }
        catch (CharacterCodingException characterCodingException) {
            String string3 = Log.leadingZeros(Integer.toHexString(charBuffer.charAt(0)), 4);
            SQLException sQLException = stringArray != null ? ErrorFactory.makeDriverJDBCException(string2, stringArray[0], stringArray[1], string3, String.valueOf(l + (long)charBuffer.position()), "ASCII") : (n == -1 ? ErrorFactory.makeDriverJDBCException(string2, string3, String.valueOf(l + (long)charBuffer.position()), "ASCII") : ErrorFactory.makeDriverJDBCException(string2, String.valueOf(n), string3, String.valueOf(l + (long)charBuffer.position()), "ASCII"));
            sQLException.initCause(characterCodingException);
            throw sQLException;
        }
        catch (Exception exception) {
            SQLException sQLException = ErrorFactory.makeDriverJDBCException("TJ670", "ASCII");
            sQLException.initCause(exception);
            throw sQLException;
        }
    }

    public static byte[] encodeClob(GenericTeradataConnection genericTeradataConnection, String string, long l) throws SQLException {
        return Encoder.getEncodedByteArray(genericTeradataConnection.getCharsetInfo(), string, "TJ677", -1, -1, null, null, genericTeradataConnection.isStrictEncode(), l);
    }

    public static byte[] encodeRequestText(GenericTeradataConnection genericTeradataConnection, String string) throws SQLException {
        return Encoder.getEncodedByteArray(genericTeradataConnection.getCharsetInfo(), string, "TJ671", -1, -1, null, null, genericTeradataConnection.isStrictEncode(), 1L);
    }

    public static byte[] encodeStringParameter(GenericTeradataConnection genericTeradataConnection, int n, String string) throws SQLException {
        return Encoder.getEncodedByteArray(genericTeradataConnection.getCharsetInfo(), string, "TJ672", n, -1, null, null, genericTeradataConnection.isStrictEncode(), 1L);
    }

    public static byte[] encodeStringParameter(GenericTeradataConnection genericTeradataConnection, int n, int n2, String string) throws SQLException {
        return Encoder.getEncodedByteArray(genericTeradataConnection.getCharsetInfo(), string, "TJ673", n, n2, null, null, genericTeradataConnection.isStrictEncode(), 1L);
    }

    public static byte[] encodeStringParameter(GenericTeradataConnection genericTeradataConnection, int n, int n2, String[] stringArray, int[] nArray, String string) throws SQLException {
        return stringArray != null ? Encoder.getEncodedByteArray(genericTeradataConnection.getCharsetInfo(), string, "TJ716", -1, -1, stringArray, null, genericTeradataConnection.isStrictEncode(), 1L) : (n2 == -1 && nArray != null ? Encoder.getEncodedByteArray(genericTeradataConnection.getCharsetInfo(), string, "TJ709", n, -1, null, nArray, genericTeradataConnection.isStrictEncode(), 1L) : (n2 == -1 ? Encoder.encodeStringParameter(genericTeradataConnection, n, string) : (nArray == null ? Encoder.getEncodedByteArray(genericTeradataConnection.getCharsetInfo(), string, "TJ714", n2, -1, null, null, genericTeradataConnection.isStrictEncode(), 1L) : Encoder.getEncodedByteArray(genericTeradataConnection.getCharsetInfo(), string, "TJ710", n2, -1, null, nArray, genericTeradataConnection.isStrictEncode(), 1L))));
    }

    public static byte[] encodeString(GenericTeradataConnection genericTeradataConnection, String string) throws SQLException {
        return Encoder.getEncodedByteArray(genericTeradataConnection.getCharsetInfo(), string, "TJ674", -1, -1, null, null, genericTeradataConnection.isStrictEncode(), 1L);
    }

    public static byte[] encodeStringReplace(GenericTeradataConnection genericTeradataConnection, String string) throws SQLException {
        return Encoder.getEncodedByteArray(genericTeradataConnection.getCharsetInfo(), string, null, -1, -1, null, null, genericTeradataConnection.isStrictEncode(), 1L);
    }

    public static byte[] encodeFieldSep(GenericTeradataConnection genericTeradataConnection, String string) throws SQLException {
        return Encoder.getEncodedByteArray(genericTeradataConnection.getCharsetInfo(), string, "TJ705", -1, -1, null, null, genericTeradataConnection.isStrictEncode(), 1L);
    }

    public static byte[] encodeColumn(ResultSetHelper resultSetHelper, int n, String string) throws SQLException {
        return Encoder.getEncodedByteArray(resultSetHelper.getCharsetInfo(), string, "TJ714", n, -1, null, null, resultSetHelper.isStrictEncode(), 1L);
    }

    public static byte[] encodeStringAsciiReplace(GenericTeradataConnection genericTeradataConnection, String string) throws SQLException {
        return Encoder.getAsciiEncodedByteArray(genericTeradataConnection.getCharsetInfo(), string, null, -1, null, genericTeradataConnection.isStrictEncode(), 1L);
    }

    public static byte[] encodeClobAscii(GenericTeradataConnection genericTeradataConnection, String string, long l) throws SQLException {
        return Encoder.getAsciiEncodedByteArray(genericTeradataConnection.getCharsetInfo(), string, "TJ677", -1, null, genericTeradataConnection.isStrictEncode(), l);
    }

    public static byte[] encodeColumnAscii(ResultSetHelper resultSetHelper, int n, String string) throws SQLException {
        return Encoder.getAsciiEncodedByteArray(resultSetHelper.getCharsetInfo(), string, "TJ714", n, null, resultSetHelper.isStrictEncode(), 1L);
    }
}

