/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc_4.io;

import com.teradata.jdbc.URLParameters;
import com.teradata.jdbc.Utility;
import com.teradata.jdbc.encode.Encoder;
import com.teradata.jdbc.jdbc_4.logging.Log;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public class ProxySupport {
    private static URI parseURI(String string) throws IOException {
        try {
            return new URI(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            IOException iOException = new IOException(uRISyntaxException.getMessage());
            iOException.initCause(uRISyntaxException);
            throw iOException;
        }
    }

    private static boolean matchesRegex(String string, String string2) throws IOException {
        try {
            return string.matches(string2);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            IOException iOException = new IOException(patternSyntaxException.getMessage());
            iOException.initCause(patternSyntaxException);
            throw iOException;
        }
    }

    public static String convertProxyBypassHostsToRegex(String string) {
        return string.replace(".", "\\.").replace("[", "\\[").replace("]", "\\]").replace("*", ".+");
    }

    private static InetSocketAddress getProxyAddress(Log log, String string, String string2, String string3) throws IOException {
        if (string2 == null) {
            return null;
        }
        String string4 = string3;
        if (string4 == null) {
            string4 = "localhost|127.*|[::1]";
        }
        String string5 = ProxySupport.convertProxyBypassHostsToRegex(string4);
        boolean bl = ProxySupport.matchesRegex(string, string5);
        if (log.isDebugEnabled()) {
            log.debug("getProxyAddress: sProxyBypassHostsParam=" + string3 + " sProxyBypassHosts=" + string4 + " sProxyBypassPattern=" + string5 + " sDestHostWithBrackets=" + string + " bBypassProxy=" + bl);
        }
        if (bl) {
            return null;
        }
        URI uRI = ProxySupport.parseURI(string2);
        return new InetSocketAddress(uRI.getHost(), uRI.getPort());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Socket connectSocket(Log log, URLParameters uRLParameters, boolean bl, boolean bl2, Integer n, Integer n2, boolean bl3, int n3, Integer n4, InetSocketAddress inetSocketAddress, int n5, String string, SSLSocketFactory sSLSocketFactory, String[] stringArray, List<Socket> list) throws IOException {
        Object object;
        String string2;
        boolean bl4;
        InetSocketAddress inetSocketAddress2;
        Proxy proxy;
        boolean bl5;
        InetSocketAddress inetSocketAddress3;
        String string3 = inetSocketAddress.getHostString();
        if (string3.contains(":")) {
            string3 = "[" + string3 + "]";
        }
        if (log.isDebugEnabled()) {
            log.debug("connectSocket: bKeepAlive=" + bl + " bNoDelay=" + bl2 + " nReceive=" + n + " nSend=" + n2 + " bLinger=" + bl3 + " nLinger=" + n3 + " nTraffic=" + n4 + " addrDest=" + inetSocketAddress + " nTimeoutMs=" + n5 + " sScheme=" + string + " sDestHostWithBrackets=" + string3);
        }
        InetSocketAddress inetSocketAddress4 = inetSocketAddress3 = (bl5 = "https".equals(string)) ? ProxySupport.getProxyAddress(log, string3, uRLParameters.getHTTPSProxy(), uRLParameters.getProxyBypassHosts()) : null;
        if (inetSocketAddress3 != null) {
            proxy = Proxy.NO_PROXY;
            inetSocketAddress2 = inetSocketAddress3;
            bl4 = true;
        } else {
            string2 = string + "://" + string3 + ":" + inetSocketAddress.getPort();
            if (log.isDebugEnabled()) {
                log.debug("connectSocket: sSelectorURI=" + string2);
            }
            object = ProxySupport.parseURI(string2);
            List<Proxy> list2 = ProxySelector.getDefault().select((URI)object);
            if (log.isDebugEnabled()) {
                log.debug("connectSocket: listProxies.size=" + list2.size());
                for (int i = 0; i < list2.size(); ++i) {
                    log.debug("connectSocket: listProxies[" + i + "]=" + list2.get(i));
                }
            }
            proxy = list2.get(0);
            inetSocketAddress2 = inetSocketAddress;
            bl4 = false;
        }
        if (stringArray != null) {
            if (inetSocketAddress3 != null) {
                stringArray[0] = "" + inetSocketAddress3;
            } else if (!Proxy.NO_PROXY.equals(proxy)) {
                stringArray[0] = "" + proxy;
            }
        }
        string2 = (inetSocketAddress3 != null ? "proxy " + inetSocketAddress3 : (Proxy.NO_PROXY.equals(proxy) ? "direct" : "proxy " + proxy)) + " to " + inetSocketAddress;
        object = new Socket(proxy);
        ((Socket)object).setKeepAlive(bl);
        ((Socket)object).setTcpNoDelay(bl2);
        if (n != null) {
            ((Socket)object).setReceiveBufferSize(n);
        }
        if (n2 != null) {
            ((Socket)object).setSendBufferSize(n2);
        }
        ((Socket)object).setSoLinger(bl3, n3);
        if (n4 != null) {
            ((Socket)object).setTrafficClass(n4);
        }
        boolean bl6 = false;
        long l = System.currentTimeMillis();
        try {
            ((Socket)object).connect(inetSocketAddress2, n5);
            bl6 = true;
            if (log.isTimingEnabled()) {
                log.timing("Socket connect " + string2 + " with timeout " + n5 + " ms took " + (System.currentTimeMillis() - l) + " ms and " + (bl6 ? "succeeded" : "failed"));
            }
        }
        catch (Throwable throwable) {
            if (log.isTimingEnabled()) {
                log.timing("Socket connect " + string2 + " with timeout " + n5 + " ms took " + (System.currentTimeMillis() - l) + " ms and " + (bl6 ? "succeeded" : "failed"));
            }
            throw throwable;
        }
        Object object2 = null;
        if (!bl5) {
            object2 = object;
        } else {
            Socket socket = null;
            try {
                if (bl4) {
                    String string4;
                    Object object3;
                    Object object4;
                    String string5 = inetSocketAddress3 != null && uRLParameters.getHTTPSProxyUser() != null && uRLParameters.getHTTPSProxyPassword() != null ? uRLParameters.getHTTPSProxyUser() + ":" + uRLParameters.getHTTPSProxyPassword() : null;
                    String string6 = string5 != null ? Utility.base64Encode(false, Encoder.encodeStringUTF8(string5)) : null;
                    String string7 = string6 != null ? "Proxy-Authorization: Basic " + string6 + "\r\n" : "";
                    String string8 = "CONNECT " + string3 + ":" + inetSocketAddress.getPort() + " HTTP/1.0\r\n" + string7 + "\r\n";
                    byte[] byArray = string8.getBytes("ASCII");
                    if (log.isDebugEnabled()) {
                        log.debugByteArray("Transmit HTTP request to proxy " + inetSocketAddress2, byArray);
                    }
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    bl6 = false;
                    l = System.currentTimeMillis();
                    try {
                        int n6;
                        object4 = ((Socket)object).getOutputStream();
                        ((OutputStream)object4).write(byArray);
                        ((OutputStream)object4).flush();
                        object3 = ((Socket)object).getInputStream();
                        int n7 = 0xD0A0D0A;
                        int n8 = 0;
                        while ((n6 = ((InputStream)object3).read()) != -1) {
                            byteArrayOutputStream.write(n6);
                            if ((n8 = n8 << 8 | n6) != n7) continue;
                        }
                        bl6 = true;
                        if (log.isTimingEnabled()) {
                            log.timing("HTTPS CONNECT send and receive " + string2 + " took " + (System.currentTimeMillis() - l) + " ms and " + (bl6 ? "succeeded" : "failed"));
                        }
                    }
                    catch (Throwable throwable) {
                        if (log.isTimingEnabled()) {
                            log.timing("HTTPS CONNECT send and receive " + string2 + " took " + (System.currentTimeMillis() - l) + " ms and " + (bl6 ? "succeeded" : "failed"));
                        }
                        throw throwable;
                    }
                    object4 = byteArrayOutputStream.toByteArray();
                    if (log.isDebugEnabled()) {
                        log.debugByteArray("Received HTTP response from proxy " + inetSocketAddress2, (byte[])object4);
                    }
                    object3 = new String((byte[])object4, "ASCII");
                    Matcher matcher = Pattern.compile("(?s)HTTP/[0-9.]+ ([0-9]+) .*").matcher((CharSequence)object3);
                    String string9 = string4 = matcher.matches() ? matcher.group(1) : null;
                    if (!"200".equals(string4)) {
                        throw new IOException(Log.formatPartialByteArray("Unexpected response from proxy " + inetSocketAddress2, (byte[])object4, 0, ((Object)object4).length));
                    }
                }
                socket = (SSLSocket)sSLSocketFactory.createSocket((Socket)object, inetSocketAddress.getHostString(), inetSocketAddress.getPort(), true);
                if (uRLParameters.getSSLCipher() != null) {
                    ((SSLSocket)socket).setEnabledCipherSuites(new String[]{uRLParameters.getSSLCipher()});
                }
                ((SSLSocket)socket).startHandshake();
                object2 = socket;
            }
            finally {
                if (object2 == null) {
                    if (socket != null) {
                        socket.close();
                    } else {
                        ((Socket)object).close();
                    }
                }
            }
        }
        if (list != null) {
            list.add((Socket)object2);
        }
        return object2;
    }
}

