/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc_4.parcel;

import com.teradata.jdbc.encode.Encoder;
import com.teradata.jdbc.jdbc.GenericTeradataConnection;
import com.teradata.jdbc.jdbc_4.io.TDPacketStream;
import com.teradata.jdbc.jdbc_4.parcel.Parcel;
import com.teradata.jdbc.jdbc_4.util.ErrorAnalyzer;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.sql.SQLException;

public class OAuthTokensParcel
extends Parcel {
    private byte[] m_abyBody = null;

    public OAuthTokensParcel(GenericTeradataConnection genericTeradataConnection) throws SQLException {
        super(genericTeradataConnection);
        this.setFlavor((short)228);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            dataOutputStream.writeInt(genericTeradataConnection.m_listOAuthScopeTokenPairs.size());
            for (String[] stringArray : genericTeradataConnection.m_listOAuthScopeTokenPairs) {
                for (String string : stringArray) {
                    byte[] byArray = Encoder.encodeString(genericTeradataConnection, string);
                    dataOutputStream.writeShort((short)byArray.length);
                    dataOutputStream.write(byArray);
                }
            }
        }
        catch (IOException iOException) {
            throw ErrorAnalyzer.analyzeIoError("OAuthTokensParcel", genericTeradataConnection.getIO(), iOException, false, true);
        }
        this.m_abyBody = byteArrayOutputStream.toByteArray();
        this.setLength(4 + this.m_abyBody.length);
        this.createBuffer(this.getLength());
    }

    @Override
    public TDPacketStream toStream() throws SQLException {
        super.toStream();
        this.buffer.put(this.m_abyBody);
        this.buffer.flip();
        return this.buffer;
    }
}

