/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.tdgss.jgssp2td2;

import com.teradata.tdgss.jgssp2td2.Td2Context;
import com.teradata.tdgss.jgssp2td2.Td2Credential;
import com.teradata.tdgss.jgssp2td2.Td2MinorStatus;
import com.teradata.tdgss.jgssp2td2.Td2Name;
import com.teradata.tdgss.jgssspi.GSSMechanism;
import com.teradata.tdgss.jtdgss.TdgssException;
import com.teradata.tdgss.jtdgss.TdgssLogger;
import com.teradata.tdgss.jtdgss.TdgssName;
import java.util.List;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

public final class Td2Mechanism
implements GSSMechanism {
    private final TdgssLogger logger;
    private static Oid _mechOid;
    protected static final int TDATMETHODMAXTOKEN = 80;
    protected static final Oid mechOid;
    protected static final int servicesAvailable = -2147483550;
    protected static int servicesNeeded;

    public Td2Mechanism(TdgssLogger tdgssLogger) {
        this.logger = tdgssLogger;
        servicesNeeded = -2147483550;
    }

    @Override
    public boolean acceptable(Object object, GSSCredential gSSCredential, Object[] objectArray) throws GSSException {
        byte[] byArray;
        if (object == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Token is null");
            }
            return false;
        }
        try {
            byArray = (byte[])object;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        if (byArray.length <= 0 || byArray.length > 80) {
            return false;
        }
        if (gSSCredential != null && !(gSSCredential instanceof Td2Credential)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("GSSException.DEFECTIVE_CREDENTIALmust be a credential created by this mech");
            }
            return false;
        }
        return true;
    }

    @Override
    public GSSContext getContextForAccept(Object object, GSSCredential gSSCredential, Object[] objectArray) throws GSSException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("getContextForAccept ");
        }
        if (!this.acceptable(object, gSSCredential, objectArray)) {
            throw new TdgssException(10, Td2MinorStatus.TD2_ERR_INVALID_TOKEN);
        }
        return new Td2Context((Td2Credential)gSSCredential, objectArray, this.logger);
    }

    @Override
    public GSSContext getContextForInit(GSSCredential gSSCredential, GSSName gSSName, int n, Object[] objectArray, int n2, List<Oid> list) throws GSSException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("getContextForInit ");
        }
        if (list != null && list.contains(_mechOid)) {
            n2 |= Integer.MIN_VALUE;
        }
        if (!this.initable(gSSCredential, gSSName, n, objectArray, n2 &= 0x80000062)) {
            throw new TdgssException(10, Td2MinorStatus.TD2_ERR_INVALID_TOKEN);
        }
        return new Td2Context((Td2Credential)gSSCredential, (Td2Name)gSSName, n, objectArray, n2, this.logger);
    }

    @Override
    public boolean initable(GSSCredential gSSCredential, GSSName gSSName, int n, Object[] objectArray, int n2) {
        if (gSSCredential != null && !(gSSCredential instanceof Td2Credential)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("GSSException.DEFECTIVE_CREDENTIAL: must be a credential created by this mech");
            }
            return false;
        }
        if (gSSName != null && !(gSSName instanceof Td2Name)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("must be a name created by this mech");
            }
            return false;
        }
        return true;
    }

    @Override
    public GSSCredential createCredential(GSSName gSSName, int n, int n2) throws GSSException {
        Td2Name td2Name;
        if (gSSName == null) {
            td2Name = null;
        } else if (gSSName instanceof Td2Name) {
            td2Name = (Td2Name)gSSName;
        } else {
            throw new TdgssException(3, Td2MinorStatus.TD2_ERR_INVALID_ARGUMENT);
        }
        return new Td2Credential(td2Name, n, n2);
    }

    @Override
    public GSSName createName(byte[] byArray, Oid oid) throws GSSException {
        return new Td2Name(byArray, oid);
    }

    @Override
    public Oid[] getNames() {
        Oid[] oidArray = new Oid[]{TdgssName.GSS_TDAT_NT_USER_PASSWORD_ACCOUNT_DATA, TdgssName.GSS_C_NT_TDAT_MECHDATA, TdgssName.GSS_C_NT_TDAT_MECHDATA_UTF8, TdgssName.GSS_C_NT_TDAT_MECHDATA_UTF16, TdgssName.GSS_C_NT_TDAT_MECHDATA_UTF32};
        return oidArray;
    }

    @Override
    public Oid getMech() {
        return mechOid;
    }

    @Override
    public int getServices() {
        return -2147483550;
    }

    static {
        try {
            _mechOid = new Oid("1.3.6.1.4.1.191.1.1012.1.1.9");
        }
        catch (GSSException gSSException) {
            throw new ExceptionInInitializerError(gSSException);
        }
        mechOid = _mechOid;
        servicesNeeded = 0;
    }
}

