/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.tdgss.jtdgss;

import com.teradata.tdgss.jgssspi.GSSMechanism;
import com.teradata.tdgss.jtdgss.TdgssCredential;
import com.teradata.tdgss.jtdgss.TdgssException;
import com.teradata.tdgss.jtdgss.TdgssLogger;
import com.teradata.tdgss.jtdgss.TdgssMinorStatus;
import com.teradata.tdgss.jtdgss.TdgssName;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import org.ietf.jgss.ChannelBinding;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.MessageProp;
import org.ietf.jgss.Oid;

public final class TdgssContext
implements GSSContext {
    private final TdgssLogger logger;
    private Vector mechanisms;
    private boolean busy = false;
    private boolean initiator;
    private Oid mechOid = null;
    private TdgssName targName = null;
    private TdgssCredential cred = null;
    private int lifetime = 0;
    private ChannelBinding channelBindings = null;
    private int servicesRequested = 0;
    private GSSContext context = null;

    public TdgssContext(TdgssName tdgssName, Oid oid, TdgssCredential tdgssCredential, int n, GSSMechanism[] gSSMechanismArray, TdgssLogger tdgssLogger) throws GSSException {
        if (gSSMechanismArray == null || gSSMechanismArray.length == 0) {
            throw new TdgssException(2, TdgssMinorStatus.TDGSS_ERR_NO_MECHANISM_IMPLEMENTATIONS);
        }
        this.logger = tdgssLogger;
        this.targName = tdgssName;
        this.cred = tdgssCredential;
        this.mechOid = oid;
        this.mechanisms = new Vector(gSSMechanismArray.length);
        if (oid != null) {
            for (int i = 0; i < gSSMechanismArray.length; ++i) {
                if (!gSSMechanismArray[i].getMech().equals(oid)) continue;
                this.mechanisms.addElement(gSSMechanismArray[i]);
            }
        } else {
            for (int i = 0; i < gSSMechanismArray.length; ++i) {
                this.mechanisms.addElement(gSSMechanismArray[i]);
            }
        }
        if (this.mechanisms.size() == 0) {
            throw new TdgssException(2, TdgssMinorStatus.TDGSS_ERR_NO_MECHANISMS);
        }
        this.lifetime = n;
        this.initiator = true;
    }

    public TdgssContext(TdgssCredential tdgssCredential, GSSMechanism[] gSSMechanismArray, TdgssLogger tdgssLogger) throws GSSException {
        this.logger = tdgssLogger;
        this.cred = tdgssCredential;
        this.mechanisms = new Vector(gSSMechanismArray.length);
        if (this.mechOid != null) {
            if (tdgssLogger.isDebugEnabled()) {
                tdgssLogger.debug("Requested mechOid is " + this.mechOid.toString());
            }
            for (int i = 0; i < gSSMechanismArray.length; ++i) {
                if (!gSSMechanismArray[i].getMech().equals(this.mechOid)) continue;
                this.mechanisms.addElement(gSSMechanismArray[i]);
            }
        } else {
            for (int i = 0; i < gSSMechanismArray.length; ++i) {
                this.mechanisms.addElement(gSSMechanismArray[i]);
            }
        }
        if (this.mechanisms.size() == 0) {
            throw new TdgssException(2, TdgssMinorStatus.TDGSS_ERR_NO_MECHANISMS);
        }
        this.initiator = false;
    }

    public TdgssContext(byte[] byArray, TdgssLogger tdgssLogger) throws GSSException {
        this.logger = tdgssLogger;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("inter-process tokens not supported");
        }
        throw new TdgssException(16, TdgssMinorStatus.TDGSS_ERR_FTN_NOT_AVAIL);
    }

    @Override
    public byte[] initSecContext(byte[] byArray, int n, int n2) throws GSSException {
        return this.initSecContext(byArray, n, n2, null);
    }

    public byte[] initSecContext(byte[] byArray, int n, int n2, List<Oid> list) throws GSSException {
        Object object;
        if (!this.initiator) {
            throw new TdgssException(15, TdgssMinorStatus.TDGSS_ERR_CANT_INIT_SEC_CONTEXT);
        }
        if (!this.busy) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Searching for an appropriate MI");
            }
            if (this.mechanisms.size() == 0) {
                throw new TdgssException(11, TdgssMinorStatus.TDGSS_ERR_NO_MECHANISMS);
            }
            object = this.mechanisms.elements();
            while (object.hasMoreElements()) {
                GSSMechanism gSSMechanism = (GSSMechanism)object.nextElement();
                GSSName gSSName = null;
                if (this.targName != null && (gSSName = this.targName.getNameImplementation(gSSMechanism)) == null) continue;
                GSSCredential gSSCredential = null;
                if (this.cred != null) {
                    gSSCredential = this.cred.getCredentialImplementation(gSSMechanism);
                }
                Object[] objectArray = new Object[]{this.channelBindings};
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Checking whether mechanism is initable");
                }
                if (!gSSMechanism.initable(gSSCredential, gSSName, this.lifetime, objectArray, this.servicesRequested)) continue;
                this.context = gSSMechanism.getContextForInit(gSSCredential, gSSName, this.lifetime, objectArray, this.servicesRequested, list);
                break;
            }
            if (this.context == null) {
                throw new TdgssException(11, TdgssMinorStatus.TDGSS_ERR_INVALID_CONTEXT);
            }
            this.busy = true;
        }
        object = this.context.initSecContext(byArray, n, n2);
        return object;
    }

    @Override
    public int initSecContext(InputStream inputStream, OutputStream outputStream) throws GSSException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Stream-based methods not supported yet");
        }
        throw new TdgssException(16, TdgssMinorStatus.TDGSS_ERR_FTN_NOT_AVAIL);
    }

    @Override
    public byte[] acceptSecContext(byte[] byArray, int n, int n2) throws GSSException {
        if (byArray == null) {
            throw new TdgssException(10);
        }
        if (this.initiator) {
            throw new TdgssException(15);
        }
        if (!this.busy) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Searching for an appropriate MI");
            }
            if (this.mechanisms.size() == 0) {
                throw new TdgssException(11, TdgssMinorStatus.TDGSS_ERR_NO_MECHANISMS);
            }
            Enumeration enumeration = this.mechanisms.elements();
            while (enumeration.hasMoreElements()) {
                GSSMechanism gSSMechanism = (GSSMechanism)enumeration.nextElement();
                try {
                    GSSCredential gSSCredential = null;
                    if (this.cred != null) {
                        gSSCredential = this.cred.getCredentialImplementation(gSSMechanism);
                    }
                    byte[] byArray2 = new byte[n2];
                    System.arraycopy(byArray, n, byArray2, 0, n2);
                    Object[] objectArray = new Object[]{this.channelBindings};
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Checking whether mechanism is acceptable");
                    }
                    if (!gSSMechanism.acceptable(byArray2, gSSCredential, objectArray)) continue;
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Found an acceptable mechanism");
                    }
                    this.context = gSSMechanism.getContextForAccept(byArray2, gSSCredential, objectArray);
                    if (!this.logger.isDebugEnabled()) break;
                    this.logger.debug("context is " + this.context);
                    break;
                }
                catch (GSSException gSSException) {
                }
            }
            if (this.context == null) {
                throw new TdgssException(11, TdgssMinorStatus.TDGSS_ERR_INVALID_CONTEXT);
            }
            this.busy = true;
        }
        return this.context.acceptSecContext(byArray, n, n2);
    }

    @Override
    public void acceptSecContext(InputStream inputStream, OutputStream outputStream) throws GSSException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Stream-based methods not supported yet");
        }
        throw new TdgssException(16, TdgssMinorStatus.TDGSS_ERR_FTN_NOT_AVAIL);
    }

    @Override
    public boolean isEstablished() {
        if (this.context != null) {
            return this.context.isEstablished();
        }
        return false;
    }

    @Override
    public void dispose() throws GSSException {
        if (this.context != null) {
            this.context.dispose();
        }
    }

    @Override
    public int getWrapSizeLimit(int n, boolean bl, int n2) throws GSSException {
        if (this.context != null) {
            return this.context.getWrapSizeLimit(n, bl, n2);
        }
        return 0;
    }

    @Override
    public byte[] wrap(byte[] byArray, int n, int n2, MessageProp messageProp) throws GSSException {
        if (this.context != null) {
            return this.context.wrap(byArray, n, n2, messageProp);
        }
        return null;
    }

    @Override
    public void wrap(InputStream inputStream, OutputStream outputStream, MessageProp messageProp) throws GSSException {
        if (this.context != null) {
            this.context.wrap(inputStream, outputStream, messageProp);
        }
    }

    @Override
    public byte[] unwrap(byte[] byArray, int n, int n2, MessageProp messageProp) throws GSSException {
        if (this.context != null) {
            return this.context.unwrap(byArray, n, n2, messageProp);
        }
        return null;
    }

    @Override
    public void unwrap(InputStream inputStream, OutputStream outputStream, MessageProp messageProp) throws GSSException {
        if (this.context != null) {
            this.context.unwrap(inputStream, outputStream, messageProp);
        }
    }

    @Override
    public byte[] getMIC(byte[] byArray, int n, int n2, MessageProp messageProp) throws GSSException {
        if (this.context != null) {
            return this.context.getMIC(byArray, n, n2, messageProp);
        }
        return null;
    }

    @Override
    public void getMIC(InputStream inputStream, OutputStream outputStream, MessageProp messageProp) throws GSSException {
        if (this.context != null) {
            this.context.getMIC(inputStream, outputStream, messageProp);
        }
    }

    @Override
    public void verifyMIC(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4, MessageProp messageProp) throws GSSException {
        if (this.context != null) {
            this.context.verifyMIC(byArray, n, n2, byArray2, n3, n4, messageProp);
        }
    }

    @Override
    public void verifyMIC(InputStream inputStream, InputStream inputStream2, MessageProp messageProp) throws GSSException {
        if (this.context != null) {
            this.context.verifyMIC(inputStream, inputStream2, messageProp);
        }
    }

    @Override
    public byte[] export() throws GSSException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("inter-process tokens not supported");
        }
        throw new TdgssException(16, TdgssMinorStatus.TDGSS_ERR_FTN_NOT_AVAIL);
    }

    @Override
    public void requestMutualAuth(boolean bl) throws GSSException {
        if (this.context != null) {
            this.context.requestMutualAuth(bl);
        } else {
            this.servicesRequested = bl ? (this.servicesRequested |= 2) : (this.servicesRequested &= 0xFFFFFFFD);
        }
    }

    @Override
    public void requestReplayDet(boolean bl) throws GSSException {
        if (this.context != null) {
            this.context.requestReplayDet(bl);
        } else {
            this.servicesRequested = bl ? (this.servicesRequested |= 4) : (this.servicesRequested &= 0xFFFFFFFB);
        }
    }

    @Override
    public void requestSequenceDet(boolean bl) throws GSSException {
        if (this.context != null) {
            this.context.requestSequenceDet(bl);
        } else {
            this.servicesRequested = bl ? (this.servicesRequested |= 8) : (this.servicesRequested &= 0xFFFFFFF7);
        }
    }

    @Override
    public void requestCredDeleg(boolean bl) throws GSSException {
        if (this.context != null) {
            this.context.requestCredDeleg(bl);
        } else {
            this.servicesRequested = bl ? (this.servicesRequested |= 1) : (this.servicesRequested &= 0xFFFFFFFE);
        }
    }

    @Override
    public void requestAnonymity(boolean bl) throws GSSException {
        if (this.context != null) {
            this.context.requestAnonymity(bl);
        } else {
            this.servicesRequested = bl ? (this.servicesRequested |= 0x10) : (this.servicesRequested &= 0xFFFFFFEF);
        }
    }

    @Override
    public void requestConf(boolean bl) throws GSSException {
        if (this.context != null) {
            this.context.requestConf(bl);
        } else {
            this.servicesRequested = bl ? (this.servicesRequested |= 0x20) : (this.servicesRequested &= 0xFFFFFFDF);
        }
    }

    @Override
    public void requestInteg(boolean bl) throws GSSException {
        if (this.context != null) {
            this.context.requestInteg(bl);
        } else {
            this.servicesRequested = bl ? (this.servicesRequested |= 0x40) : (this.servicesRequested &= 0xFFFFFFBF);
        }
    }

    @Override
    public void requestLifetime(int n) throws GSSException {
        if (this.context != null) {
            this.context.requestLifetime(n);
        } else {
            this.lifetime = n;
        }
    }

    @Override
    public void setChannelBinding(ChannelBinding channelBinding) throws GSSException {
        if (this.busy) {
            throw new TdgssException(11, TdgssMinorStatus.TDGSS_ERR_CONTEXT_BUSY);
        }
        this.channelBindings = channelBinding;
    }

    @Override
    public boolean getCredDelegState() {
        return this.context == null ? false : this.context.getCredDelegState();
    }

    @Override
    public boolean getMutualAuthState() {
        return this.context == null ? false : this.context.getMutualAuthState();
    }

    @Override
    public boolean getReplayDetState() {
        return this.context == null ? false : this.context.getReplayDetState();
    }

    @Override
    public boolean getSequenceDetState() {
        return this.context == null ? false : this.context.getSequenceDetState();
    }

    @Override
    public boolean getAnonymityState() {
        return this.context == null ? false : this.context.getAnonymityState();
    }

    @Override
    public boolean getConfState() {
        return this.context == null ? false : this.context.getConfState();
    }

    @Override
    public boolean getIntegState() {
        return this.context == null ? false : this.context.getIntegState();
    }

    @Override
    public int getLifetime() {
        return this.context == null ? 0 : this.context.getLifetime();
    }

    @Override
    public boolean isTransferable() throws GSSException {
        if (this.context == null) {
            throw new TdgssException(11, TdgssMinorStatus.TDGSS_ERR_INVALID_CONTEXT);
        }
        return this.context.isTransferable();
    }

    @Override
    public boolean isProtReady() {
        return this.context == null ? false : this.context.isProtReady();
    }

    @Override
    public GSSName getSrcName() throws GSSException {
        if (this.cred != null) {
            return this.cred.getName();
        }
        return null;
    }

    @Override
    public GSSName getTargName() throws GSSException {
        return this.targName;
    }

    @Override
    public Oid getMech() throws GSSException {
        return this.context == null ? this.mechOid : this.context.getMech();
    }

    @Override
    public GSSCredential getDelegCred() throws GSSException {
        if (this.context == null) {
            throw new TdgssException(11, TdgssMinorStatus.TDGSS_ERR_INVALID_CONTEXT);
        }
        return this.context.getDelegCred();
    }

    @Override
    public boolean isInitiator() throws GSSException {
        return this.initiator;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.cred != null) {
            stringBuffer.append("TdgssCredential: ");
            stringBuffer.append(this.cred.toString());
            stringBuffer.append("\n");
        }
        if (this.targName != null) {
            stringBuffer.append("Target: ");
            stringBuffer.append(this.targName.toString());
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }
}

