/*
 * Decompiled with CFR 0.152.
 */
package com.textmagic.sdk;

import com.textmagic.sdk.ClientException;
import com.textmagic.sdk.HttpDeleteEntity;
import com.textmagic.sdk.RequestMethod;
import com.textmagic.sdk.RestException;
import com.textmagic.sdk.RestResponse;
import com.textmagic.sdk.resource.Resource;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.NameValuePair;
import org.apache.http.StatusLine;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

public class RestClient {
    private static final String VERSION = "v2";
    public static final String PRODUCTION_URI = "https://rest.textmagic.com/api/v2";
    private static final int TIMEOUT = 500;
    private final String username;
    private final String token;
    private final String uri;
    private HttpClient client;
    protected long previousRequestTime = 0L;

    public String getApiUri() {
        return this.uri;
    }

    public HttpClient getHttpClient() {
        return this.client;
    }

    public void setHttpClient(HttpClient client) {
        this.client = client;
    }

    public RestClient(String username, String token) {
        this(username, token, PRODUCTION_URI);
    }

    public RestClient(String username, String token, String uri) {
        this.username = username;
        this.token = token;
        this.uri = uri;
        this.setHttpClient((HttpClient)new DefaultHttpClient());
        this.client.getParams().setParameter("http.protocol.version", (Object)HttpVersion.HTTP_1_1);
        this.client.getParams().setParameter("http.socket.timeout", (Object)5000);
        this.client.getParams().setParameter("http.connection.timeout", (Object)5000);
        this.client.getParams().setParameter("http.protocol.content-charset", (Object)"UTF-8");
    }

    public <T extends Resource<RestClient>> T getResource(Class<T> clazz) throws ClientException {
        try {
            return (T)((Resource)clazz.getConstructor(RestClient.class).newInstance(this));
        }
        catch (InstantiationException e) {
            throw new ClientException(e);
        }
        catch (IllegalAccessException e) {
            throw new ClientException(e);
        }
        catch (IllegalArgumentException e) {
            throw new ClientException(e);
        }
        catch (InvocationTargetException e) {
            throw new ClientException(e);
        }
        catch (NoSuchMethodException e) {
            throw new ClientException(e);
        }
        catch (SecurityException e) {
            throw new ClientException(e);
        }
    }

    public <T extends Resource<RestClient>> T getResource(Class<T> clazz, Map<String, String> parameters) throws ClientException {
        try {
            return (T)((Resource)clazz.getConstructor(RestClient.class, Map.class).newInstance(this, parameters));
        }
        catch (InstantiationException e) {
            throw new ClientException(e);
        }
        catch (IllegalAccessException e) {
            throw new ClientException(e);
        }
        catch (IllegalArgumentException e) {
            throw new ClientException(e);
        }
        catch (InvocationTargetException e) {
            throw new ClientException(e);
        }
        catch (NoSuchMethodException e) {
            throw new ClientException(e);
        }
        catch (SecurityException e) {
            throw new ClientException(e);
        }
    }

    private HttpGet buildGetRequest(String path, List<NameValuePair> paramList) {
        URI uri = this.buildUri(path, paramList);
        return new HttpGet(uri);
    }

    private HttpPost buildPostRequest(String path, List<NameValuePair> paramList) {
        URI uri = this.buildUri(path);
        UrlEncodedFormEntity entity = this.buildFormEntity(paramList);
        HttpPost post = new HttpPost(uri);
        post.setEntity((HttpEntity)entity);
        return post;
    }

    private HttpPut buildPutRequest(String path, List<NameValuePair> paramList) {
        URI uri = this.buildUri(path);
        UrlEncodedFormEntity entity = this.buildFormEntity(paramList);
        HttpPut put = new HttpPut(uri);
        put.setEntity((HttpEntity)entity);
        return put;
    }

    private HttpDeleteEntity buildDeleteRequest(String path, List<NameValuePair> paramList) {
        URI uri = this.buildUri(path);
        UrlEncodedFormEntity entity = this.buildFormEntity(paramList);
        HttpDeleteEntity delete = new HttpDeleteEntity(uri);
        delete.setEntity((HttpEntity)entity);
        return delete;
    }

    private UrlEncodedFormEntity buildFormEntity(List<NameValuePair> paramList) {
        UrlEncodedFormEntity entity;
        try {
            entity = new UrlEncodedFormEntity(paramList, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new ClientException(e);
        }
        return entity;
    }

    private URI buildUri(String path) {
        return this.buildUri(path, null);
    }

    private URI buildUri(String path, List<NameValuePair> paramList) {
        URI uri;
        StringBuilder sb = new StringBuilder();
        sb.append(path);
        if (paramList != null && paramList.size() > 0) {
            sb.append("?");
            sb.append(URLEncodedUtils.format(paramList, (String)"UTF-8"));
        }
        try {
            uri = new URI(sb.toString());
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("Invalid uri", e);
        }
        return uri;
    }

    public static List<NameValuePair> buildParametersList(Map<String, String> paramMap) {
        ArrayList<NameValuePair> paramList = new ArrayList<NameValuePair>();
        if (paramMap != null && paramMap.size() > 0) {
            for (String var : paramMap.keySet()) {
                paramList.add((NameValuePair)new BasicNameValuePair(var, paramMap.get(var)));
            }
        }
        return paramList;
    }

    public RestResponse request(String path, RequestMethod method) throws RestException {
        HashMap<String, String> param = new HashMap<String, String>();
        return this.request(path, method, param);
    }

    public RestResponse request(String path, RequestMethod method, List<NameValuePair> paramList) throws RestException, ClientException {
        if (path == null && method == null && paramList == null) {
            return new RestResponse("", 0);
        }
        HttpUriRequest request = this.buildRequest(method, path, paramList);
        try {
            long requestTimeDiff = new Date().getTime() - this.previousRequestTime;
            if (requestTimeDiff < 500L) {
                try {
                    Thread.sleep(500L - requestTimeDiff);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            HttpResponse response = this.client.execute(request);
            this.previousRequestTime = new Date().getTime();
            HttpEntity entity = response.getEntity();
            String responseBody = null;
            if (entity != null) {
                responseBody = EntityUtils.toString((HttpEntity)entity);
            }
            StatusLine status = response.getStatusLine();
            Integer statusCode = status.getStatusCode();
            RestResponse result = new RestResponse(responseBody, statusCode);
            if (200 <= statusCode && statusCode < 300) {
                return result;
            }
            throw RestException.parseResponse(result);
        }
        catch (ClientProtocolException e1) {
            throw new ClientException(e1);
        }
        catch (IOException e1) {
            throw new ClientException(e1);
        }
    }

    public RestResponse request(String path, RequestMethod method, Map<String, String> paramMap) throws RestException {
        List<NameValuePair> paramList = RestClient.buildParametersList(paramMap);
        return this.request(path, method, paramList);
    }

    private HttpUriRequest buildRequest(RequestMethod method, String path, List<NameValuePair> params) {
        Object request;
        String normalizedPath = path.toLowerCase();
        StringBuilder sb = new StringBuilder();
        sb.append(this.getApiUri());
        if (!normalizedPath.startsWith("/")) {
            sb.append("/");
        }
        sb.append(path);
        path = sb.toString();
        switch (method) {
            case GET: {
                request = this.buildGetRequest(path, params);
                break;
            }
            case POST: {
                request = this.buildPostRequest(path, params);
                break;
            }
            case PUT: {
                request = this.buildPutRequest(path, params);
                break;
            }
            case DELETE: {
                request = this.buildDeleteRequest(path, params);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown Method: " + (Object)((Object)method));
            }
        }
        request.addHeader((Header)new BasicHeader("User-Agent", "textmagic-rest-java/v2"));
        request.addHeader((Header)new BasicHeader("Accept", "application/json"));
        request.addHeader((Header)new BasicHeader("Accept-Charset", "utf-8"));
        request.addHeader((Header)new BasicHeader("Accept-Language", "en-US"));
        request.addHeader((Header)new BasicHeader("X-TM-Username", this.username));
        request.addHeader((Header)new BasicHeader("X-TM-Key", this.token));
        return request;
    }
}

