/*
 * Decompiled with CFR 0.152.
 */
package com.textmagic.sdk;

import com.textmagic.sdk.RestResponse;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.text.StrBuilder;

public class RestException
extends Exception {
    private static final long serialVersionUID = -617296495882003033L;
    private static final String KEY_SEPARATOR = " ";
    private Integer code;
    private String message;
    private Map<String, List<String>> errors;

    public RestException(String message, Integer code) {
        this(message, code, null);
    }

    public RestException(String message, Integer code, Map<String, List<String>> errors) {
        super(message);
        this.message = message;
        this.code = code;
        this.errors = errors;
    }

    public static RestException parseResponse(RestResponse response) {
        Map<String, Object> data = response.toMap();
        Integer code = 0;
        String message = "";
        HashMap<String, List<String>> errors = new HashMap<String, List<String>>();
        message = (String)data.get("message");
        if (data.get("code") != null) {
            code = (Integer)data.get("code");
        }
        if (data.get("errors") != null) {
            RestException.addErrors("", (Map)data.get("errors"), errors);
        }
        return new RestException(message, code, errors);
    }

    private static void addErrors(String prefix, Map<String, Object> restErrors, Map<String, List<String>> result) {
        for (Map.Entry<String, Object> entry : restErrors.entrySet()) {
            ArrayList<String> list;
            String resultKey;
            String key = entry.getKey();
            Object value = entry.getValue();
            String string = resultKey = prefix.length() == 0 ? key : prefix + KEY_SEPARATOR + key;
            if (value instanceof Map) {
                RestException.addErrors(resultKey, (Map)value, result);
                continue;
            }
            if (value instanceof List) {
                list = new ArrayList<String>();
                for (Object v : (List)value) {
                    list.add(v.toString());
                }
                result.put(resultKey, list);
                continue;
            }
            list = new ArrayList(1);
            String msg = value != null ? value.toString() : "null";
            list.add(msg);
            result.put(resultKey, list);
        }
    }

    public Integer getErrorCode() {
        return this.code;
    }

    public String getErrorMessage() {
        return this.message;
    }

    public Map<String, List<String>> getErrors() {
        return this.errors;
    }

    public String getTextRepresentation() {
        StrBuilder sb = new StrBuilder();
        sb.append("RestException[\n\t");
        sb.append(this.message).append("\n\t");
        for (Map.Entry<String, List<String>> msgs : this.errors.entrySet()) {
            sb.append(msgs.getKey()).append(" => [");
            sb.appendWithSeparators((Collection)msgs.getValue(), "\n\t\t");
            sb.append("]\n\t");
        }
        sb.setLength(sb.length() - 1);
        return sb.append("]").toString();
    }
}

