/*
 * Decompiled with CFR 0.152.
 */
package com.textmagic.sdk;

import com.textmagic.sdk.ClientException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;

public class RestResponse {
    private String jsonResponse;
    private Integer httpStatus;
    private boolean error;

    public RestResponse(String text, Integer status) {
        this.jsonResponse = text;
        this.httpStatus = status;
        this.error = status >= 400;
    }

    public String getJsonResponse() {
        return this.jsonResponse;
    }

    public Integer getHttpStatus() {
        return this.httpStatus;
    }

    public boolean isError() {
        return this.error;
    }

    public Map<String, Object> toMap() throws ClientException {
        HashMap<String, Object> result = new HashMap();
        try {
            result = (Map)new ObjectMapper().readValue(this.jsonResponse, HashMap.class);
        }
        catch (JsonParseException e) {
            throw new ClientException(e);
        }
        catch (JsonMappingException e) {
            throw new ClientException(e);
        }
        catch (IOException e) {
            throw new ClientException(e);
        }
        return result;
    }

    public List<Object> toList() throws ClientException {
        ArrayList<Object> result = new ArrayList();
        try {
            result = (List)new ObjectMapper().readValue(this.jsonResponse, List.class);
        }
        catch (JsonParseException e) {
            throw new ClientException(e);
        }
        catch (JsonMappingException e) {
            throw new ClientException(e);
        }
        catch (IOException e) {
            throw new ClientException(e);
        }
        return result;
    }
}

