/*
 * Decompiled with CFR 0.152.
 */
package com.textmagic.sdk.resource;

import com.textmagic.sdk.RestClient;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;

public abstract class Resource<C extends RestClient> {
    private C client;
    protected Map<String, String> parameters;
    protected Set<String> requestFields;

    public Resource(C client) {
        this.client = client;
    }

    protected C getClient() {
        return this.client;
    }

    protected abstract String getResourcePath();

    protected Integer getIntValue(Object data) {
        if (data instanceof Integer) {
            return (Integer)data;
        }
        if (data instanceof String) {
            return Integer.parseInt((String)data);
        }
        return -1;
    }

    protected String getStringValue(Object data) {
        if (data instanceof String) {
            return (String)data;
        }
        if (data instanceof Integer) {
            return Integer.toString((Integer)data);
        }
        if (data instanceof Boolean) {
            if (((Boolean)data).booleanValue()) {
                return "1";
            }
            return "0";
        }
        return null;
    }

    protected List<NameValuePair> buildRequestParameters(Map<String, Object> paramMap) {
        ArrayList<NameValuePair> paramList = new ArrayList<NameValuePair>();
        if (paramMap != null && paramMap.size() > 0) {
            for (String var : paramMap.keySet()) {
                String paramStr = this.getStringValue(paramMap.get(var));
                if (paramStr == null || !this.requestFields.contains(var)) continue;
                paramList.add((NameValuePair)new BasicNameValuePair(var, paramStr));
            }
        }
        return paramList;
    }
}

