/*
 * Decompiled with CFR 0.152.
 */
package com.textmagic.sdk.resource.instance;

import com.textmagic.sdk.ClientException;
import com.textmagic.sdk.RequestMethod;
import com.textmagic.sdk.RestClient;
import com.textmagic.sdk.RestException;
import com.textmagic.sdk.RestResponse;
import com.textmagic.sdk.resource.Resource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class TMNewMessage
extends Resource<RestClient> {
    private Map<String, Object> properties = new HashMap<String, Object>();

    public TMNewMessage(RestClient client) {
        super(client);
        this.requestFields = new HashSet<String>(Arrays.asList("text", "templateId", "sendingTime", "contacts", "lists", "phones", "cutExtra", "partsCount", "referenceId", "from", "rrule"));
    }

    @Override
    protected String getResourcePath() {
        return "messages";
    }

    protected String getPriceResourcePath() {
        return "messages/price";
    }

    public boolean send() throws RestException, ClientException {
        RestResponse response = ((RestClient)this.getClient()).request(this.getResourcePath(), RequestMethod.POST, this.buildRequestParameters(this.properties));
        this.properties = new HashMap<String, Object>(response.toMap());
        return !response.isError();
    }

    public Double getPrice() throws RestException, ClientException {
        RestResponse response = ((RestClient)this.getClient()).request(this.getPriceResourcePath(), RequestMethod.GET, this.buildRequestParameters(this.properties));
        HashMap<String, Object> result = new HashMap<String, Object>(response.toMap());
        Object total = result.get("total");
        if (total instanceof Integer) {
            return ((Integer)total).doubleValue();
        }
        return (Double)total;
    }

    protected Object getProperty(String name) {
        return this.properties.get(name);
    }

    private void setProperty(String name, Object value) {
        this.properties.put(name, value);
    }

    public Integer getId() {
        return (Integer)this.getProperty("id");
    }

    public String getType() {
        return (String)this.getProperty("type");
    }

    public void setText(String text) {
        this.setProperty("text", text);
    }

    public void setTemplateId(Integer templateId) {
        this.setProperty("templateId", templateId);
    }

    public void setSendingTime(Date sendingTime) {
        long timestamp = sendingTime.getTime() / 1000L;
        this.setProperty("sendingTime", String.valueOf(timestamp));
    }

    public void setContacts(List<Integer> contacts) {
        ArrayList<String> param = new ArrayList<String>();
        for (Integer id : contacts) {
            param.add(Integer.toString(id));
        }
        this.setProperty("contacts", StringUtils.join(param, (String)","));
    }

    public void setLists(List<Integer> lists) {
        ArrayList<String> param = new ArrayList<String>();
        for (Integer id : lists) {
            param.add(Integer.toString(id));
        }
        this.setProperty("lists", StringUtils.join(param, (String)","));
    }

    public void setPhones(List<String> phones) {
        this.setProperty("phones", StringUtils.join(phones, (String)","));
    }

    public void setCutExtra(Boolean cutExtra) {
        this.setProperty("cutExtra", cutExtra);
    }

    public void setPartsCount(Integer partsCount) {
        this.setProperty("partsCount", partsCount);
    }

    public void setReferenceId(String referenceId) {
        this.setProperty("referenceId", referenceId);
    }

    public void setFrom(String from) {
        this.setProperty("from", from);
    }

    public void setRrule(String rrule) {
        this.setProperty("rrule", rrule);
    }
}

