/*
 * Decompiled with CFR 0.152.
 */
package com.textmagic.sdk.resource.instance;

import com.textmagic.sdk.ClientException;
import com.textmagic.sdk.RequestMethod;
import com.textmagic.sdk.RestClient;
import com.textmagic.sdk.RestException;
import com.textmagic.sdk.RestResponse;
import com.textmagic.sdk.resource.InstanceResource;
import com.textmagic.sdk.resource.instance.TMUser;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class TMNumber
extends InstanceResource<RestClient> {
    public TMNumber(RestClient client) {
        super(client);
        this.requestFields = new HashSet<String>(Arrays.asList("phone", "country", "userId"));
    }

    public TMNumber(RestClient client, Map<String, Object> properties) {
        super(client, properties);
        this.requestFields = new HashSet<String>(Arrays.asList("phone", "country", "userId"));
    }

    @Override
    protected String getResourcePath() {
        return "numbers";
    }

    @Override
    public boolean createOrUpdate() throws RestException {
        if (this.getProperty("id") == null) {
            RestResponse response = ((RestClient)this.getClient()).request(this.getResourcePath(), RequestMethod.POST, this.buildRequestParameters(this.properties));
            Map<String, Object> properties = response.toMap();
            Integer id = (Integer)properties.get("id");
            this.clearProperties();
            return this.get(id);
        }
        throw new UnsupportedOperationException("This operation is unsupported for number");
    }

    public List<String> getAvailableNumbers(String country, String prefix) throws RestException, ClientException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("country", country);
        params.put("prefix", prefix);
        RestResponse response = ((RestClient)this.getClient()).request(this.getResourcePath() + "/available", RequestMethod.GET, params);
        HashMap<String, Object> available = new HashMap<String, Object>(response.toMap());
        return (List)available.get("numbers");
    }

    public Integer getId() {
        return (Integer)this.getProperty("id");
    }

    public Date getPurchasedAt() {
        return this.getDate("purchasedAt");
    }

    public Date getExpireAt() {
        return this.getDate("expireAt");
    }

    public String getPhone() {
        return (String)this.getProperty("phone");
    }

    public void setPhone(String phone) {
        this.setProperty("phone", phone);
    }

    public String getStatus() {
        return (String)this.getProperty("status");
    }

    public String getCountry() {
        Map country = (Map)this.getProperty("country");
        return (String)country.get("id");
    }

    public void setCountry(String country) {
        this.setProperty("country", country);
    }

    public TMUser getUser() {
        return new TMUser((RestClient)this.getClient(), (Map<String, Object>)((Map)this.getProperty("user")));
    }

    public void setUserId(Integer userId) {
        this.setProperty("userId", userId);
    }
}

