/*
 * Decompiled with CFR 0.152.
 */
package com.thetransactioncompany.jsonrpc2;

import com.thetransactioncompany.jsonrpc2.JSONRPC2Error;
import com.thetransactioncompany.jsonrpc2.JSONRPC2Message;
import com.thetransactioncompany.jsonrpc2.JSONRPC2ParseException;
import com.thetransactioncompany.jsonrpc2.JSONRPC2Parser;
import java.util.List;
import java.util.Map;
import net.minidev.json.JSONObject;

public class JSONRPC2Response
extends JSONRPC2Message {
    private Object result = null;
    private JSONRPC2Error error = null;
    private Object id = null;

    public static JSONRPC2Response parse(String jsonString) throws JSONRPC2ParseException {
        return JSONRPC2Response.parse(jsonString, false, false, false);
    }

    public static JSONRPC2Response parse(String jsonString, boolean preserveOrder) throws JSONRPC2ParseException {
        return JSONRPC2Response.parse(jsonString, preserveOrder, false, false);
    }

    public static JSONRPC2Response parse(String jsonString, boolean preserveOrder, boolean ignoreVersion) throws JSONRPC2ParseException {
        return JSONRPC2Response.parse(jsonString, preserveOrder, ignoreVersion, false);
    }

    public static JSONRPC2Response parse(String jsonString, boolean preserveOrder, boolean ignoreVersion, boolean parseNonStdAttributes) throws JSONRPC2ParseException {
        JSONRPC2Parser parser = new JSONRPC2Parser(preserveOrder, ignoreVersion, parseNonStdAttributes);
        return parser.parseJSONRPC2Response(jsonString);
    }

    public JSONRPC2Response(Object result, Object id) {
        this.setResult(result);
        this.setID(id);
    }

    public JSONRPC2Response(Object id) {
        this.setResult(null);
        this.setID(id);
    }

    public JSONRPC2Response(JSONRPC2Error error, Object id) {
        this.setError(error);
        this.setID(id);
    }

    public void setResult(Object result) {
        if (!(result == null || result instanceof Boolean || result instanceof Number || result instanceof String || result instanceof List || result instanceof Map)) {
            throw new IllegalArgumentException("The result must map to a JSON type");
        }
        this.result = result;
        this.error = null;
    }

    public Object getResult() {
        return this.result;
    }

    public void setError(JSONRPC2Error error) {
        if (error == null) {
            throw new IllegalArgumentException("The error object cannot be null");
        }
        this.error = error;
        this.result = null;
    }

    public JSONRPC2Error getError() {
        return this.error;
    }

    public boolean indicatesSuccess() {
        return this.error == null;
    }

    public void setID(Object id) {
        this.id = id == null || id instanceof Boolean || id instanceof Number || id instanceof String ? id : id.toString();
    }

    public Object getID() {
        return this.id;
    }

    @Override
    public JSONObject toJSONObject() {
        JSONObject out = new JSONObject();
        if (this.error != null) {
            out.put((Object)"error", (Object)this.error.toJSONObject());
        } else {
            out.put((Object)"result", this.result);
        }
        out.put((Object)"id", this.id);
        out.put((Object)"jsonrpc", (Object)"2.0");
        Map<String, Object> nonStdAttributes = this.getNonStdAttributes();
        if (nonStdAttributes != null) {
            for (Map.Entry<String, Object> attr : nonStdAttributes.entrySet()) {
                out.put((Object)attr.getKey(), attr.getValue());
            }
        }
        return out;
    }
}

