/*
 * Decompiled with CFR 0.152.
 */
package com.opentok;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.opentok.Archive;
import com.opentok.ArchiveList;
import com.opentok.ArchiveProperties;
import com.opentok.Session;
import com.opentok.SessionProperties;
import com.opentok.TokenOptions;
import com.opentok.exception.InvalidArgumentException;
import com.opentok.exception.OpenTokException;
import com.opentok.exception.RequestException;
import com.opentok.util.Crypto;
import com.opentok.util.HttpClient;
import java.io.IOException;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.xml.sax.InputSource;

public class OpenTok {
    private int apiKey;
    private String apiSecret;
    protected HttpClient client;
    protected static ObjectReader archiveReader = new ObjectMapper().reader(Archive.class);
    protected static ObjectReader archiveListReader = new ObjectMapper().reader(ArchiveList.class);

    public OpenTok(int apiKey, String apiSecret) {
        this(apiKey, apiSecret, "https://api.opentok.com");
    }

    public OpenTok(int apiKey, String apiSecret, String apiUrl) {
        this.apiKey = apiKey;
        this.apiSecret = apiSecret.trim();
        this.client = new HttpClient.Builder(apiKey, apiSecret).apiUrl(apiUrl).build();
    }

    public String generateToken(String sessionId, TokenOptions tokenOptions) throws OpenTokException {
        List<String> sessionIdParts = null;
        if (sessionId == null || sessionId == "") {
            throw new InvalidArgumentException("Session not valid");
        }
        try {
            sessionIdParts = Crypto.decodeSessionId(sessionId);
        }
        catch (UnsupportedEncodingException e) {
            throw new InvalidArgumentException("Session ID was not valid");
        }
        if (!sessionIdParts.contains(Integer.toString(this.apiKey))) {
            throw new InvalidArgumentException("Session ID was not valid");
        }
        Session session = new Session(sessionId, this.apiKey, this.apiSecret);
        return session.generateToken(tokenOptions);
    }

    public String generateToken(String sessionId) throws OpenTokException {
        return this.generateToken(sessionId, new TokenOptions.Builder().build());
    }

    public Session createSession(SessionProperties properties) throws OpenTokException {
        String xpathQuery = "/sessions/Session/session_id";
        Map<String, Collection<String>> params = properties != null ? properties.toMap() : new SessionProperties.Builder().build().toMap();
        String xmlResponse = this.client.createSession(params);
        try {
            if (properties != null) {
                return new Session(OpenTok.readXml(xpathQuery, xmlResponse), this.apiKey, this.apiSecret, properties);
            }
            return new Session(OpenTok.readXml(xpathQuery, xmlResponse), this.apiKey, this.apiSecret);
        }
        catch (XPathExpressionException e) {
            throw new OpenTokException("Cannot create session. Could not read the response: " + xmlResponse);
        }
    }

    public Session createSession() throws OpenTokException {
        return this.createSession(null);
    }

    private static String readXml(String xpathQuery, String xml) throws XPathExpressionException {
        XPathFactory xpathFactory = XPathFactory.newInstance();
        XPath xpath = xpathFactory.newXPath();
        InputSource source = new InputSource(new StringReader(xml));
        return xpath.evaluate(xpathQuery, source);
    }

    public Archive getArchive(String archiveId) throws OpenTokException {
        String archive = this.client.getArchive(archiveId);
        try {
            return (Archive)archiveReader.readValue(archive);
        }
        catch (Exception e) {
            throw new RequestException("Exception mapping json: " + e.getMessage());
        }
    }

    public ArchiveList listArchives() throws OpenTokException {
        return this.listArchives(0, 1000);
    }

    public ArchiveList listArchives(int offset, int count) throws OpenTokException {
        String archives = this.client.getArchives(offset, count);
        try {
            return (ArchiveList)archiveListReader.readValue(archives);
        }
        catch (JsonMappingException e) {
            throw new RequestException("Exception mapping json: " + e.getMessage());
        }
        catch (JsonParseException e) {
            throw new RequestException("Exception mapping json: " + e.getMessage());
        }
        catch (JsonProcessingException e) {
            throw new RequestException("Exception mapping json: " + e.getMessage());
        }
        catch (IOException e) {
            throw new RequestException("Exception mapping json: " + e.getMessage());
        }
    }

    public Archive startArchive(String sessionId, ArchiveProperties properties) throws OpenTokException {
        if (sessionId == null || sessionId == "") {
            throw new InvalidArgumentException("Session not valid");
        }
        String archive = this.client.startArchive(sessionId, properties);
        try {
            return (Archive)archiveReader.readValue(archive);
        }
        catch (Exception e) {
            throw new RequestException("Exception mapping json: " + e.getMessage());
        }
    }

    public Archive startArchive(String sessionId) throws OpenTokException {
        return this.startArchive(sessionId, new ArchiveProperties.Builder().build());
    }

    public Archive startArchive(String sessionId, String name) throws OpenTokException {
        ArchiveProperties properties = new ArchiveProperties.Builder().name(name).build();
        return this.startArchive(sessionId, properties);
    }

    public Archive stopArchive(String archiveId) throws OpenTokException {
        String archive = this.client.stopArchive(archiveId);
        try {
            return (Archive)archiveReader.readValue(archive);
        }
        catch (Exception e) {
            throw new RequestException("Exception mapping json: " + e.getMessage());
        }
    }

    public void deleteArchive(String archiveId) throws OpenTokException {
        this.client.deleteArchive(archiveId);
    }
}

