/*
 * Decompiled with CFR 0.152.
 */
package com.opentok;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.opentok.Archive;
import com.opentok.ArchiveList;
import com.opentok.ArchiveProperties;
import com.opentok.CreatedSession;
import com.opentok.Session;
import com.opentok.SessionProperties;
import com.opentok.TokenOptions;
import com.opentok.exception.InvalidArgumentException;
import com.opentok.exception.OpenTokException;
import com.opentok.exception.RequestException;
import com.opentok.util.Crypto;
import com.opentok.util.HttpClient;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.Proxy;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class OpenTok {
    private int apiKey;
    private String apiSecret;
    protected HttpClient client;
    protected static ObjectReader archiveReader = new ObjectMapper().readerFor(Archive.class);
    protected static ObjectReader archiveListReader = new ObjectMapper().readerFor(ArchiveList.class);
    protected static ObjectReader createdSessionReader = new ObjectMapper().readerFor(CreatedSession[].class);
    static final String defaultApiUrl = "https://api.opentok.com";

    public OpenTok(int apiKey, String apiSecret) {
        this.apiKey = apiKey;
        this.apiSecret = apiSecret.trim();
        this.client = new HttpClient.Builder(apiKey, apiSecret).build();
    }

    private OpenTok(int apiKey, String apiSecret, HttpClient httpClient) {
        this.apiKey = apiKey;
        this.apiSecret = apiSecret.trim();
        this.client = httpClient;
    }

    public String generateToken(String sessionId, TokenOptions tokenOptions) throws OpenTokException {
        List<String> sessionIdParts = null;
        if (sessionId == null || sessionId == "") {
            throw new InvalidArgumentException("Session not valid");
        }
        try {
            sessionIdParts = Crypto.decodeSessionId(sessionId);
        }
        catch (UnsupportedEncodingException e) {
            throw new InvalidArgumentException("Session ID was not valid");
        }
        if (!sessionIdParts.contains(Integer.toString(this.apiKey))) {
            throw new InvalidArgumentException("Session ID was not valid");
        }
        Session session = new Session(sessionId, this.apiKey, this.apiSecret);
        return session.generateToken(tokenOptions);
    }

    public String generateToken(String sessionId) throws OpenTokException {
        return this.generateToken(sessionId, new TokenOptions.Builder().build());
    }

    public Session createSession(SessionProperties properties) throws OpenTokException {
        SessionProperties _properties = properties != null ? properties : new SessionProperties.Builder().build();
        Map<String, Collection<String>> params = _properties.toMap();
        String response = this.client.createSession(params);
        try {
            CreatedSession[] sessions = (CreatedSession[])createdSessionReader.readValue(response);
            if (sessions.length != 1) {
                throw new OpenTokException(String.format("Unexpected number of sessions created %d", sessions.length));
            }
            return new Session(sessions[0].getId(), this.apiKey, this.apiSecret, _properties);
        }
        catch (IOException e) {
            throw new OpenTokException("Cannot create session. Could not read the response: " + response);
        }
    }

    public Session createSession() throws OpenTokException {
        return this.createSession(null);
    }

    public Archive getArchive(String archiveId) throws OpenTokException {
        String archive = this.client.getArchive(archiveId);
        try {
            return (Archive)archiveReader.readValue(archive);
        }
        catch (Exception e) {
            throw new RequestException("Exception mapping json: " + e.getMessage());
        }
    }

    public ArchiveList listArchives() throws OpenTokException {
        return this.listArchives(0, 1000);
    }

    public ArchiveList listArchives(int offset, int count) throws OpenTokException {
        String archives = this.client.getArchives(offset, count);
        try {
            return (ArchiveList)archiveListReader.readValue(archives);
        }
        catch (JsonProcessingException e) {
            throw new RequestException("Exception mapping json: " + e.getMessage());
        }
        catch (IOException e) {
            throw new RequestException("Exception mapping json: " + e.getMessage());
        }
    }

    public ArchiveList listArchives(String sessionId) throws RequestException {
        String archives = this.client.getArchives(sessionId);
        try {
            return (ArchiveList)archiveListReader.readValue(archives);
        }
        catch (Exception e) {
            throw new RequestException("Exception mapping json: " + e.getMessage());
        }
    }

    public Archive startArchive(String sessionId, ArchiveProperties properties) throws OpenTokException {
        if (sessionId == null || sessionId == "") {
            throw new InvalidArgumentException("Session not valid");
        }
        String archive = this.client.startArchive(sessionId, properties);
        try {
            return (Archive)archiveReader.readValue(archive);
        }
        catch (Exception e) {
            throw new RequestException("Exception mapping json: " + e.getMessage());
        }
    }

    public Archive startArchive(String sessionId) throws OpenTokException {
        return this.startArchive(sessionId, new ArchiveProperties.Builder().build());
    }

    public Archive startArchive(String sessionId, String name) throws OpenTokException {
        ArchiveProperties properties = new ArchiveProperties.Builder().name(name).build();
        return this.startArchive(sessionId, properties);
    }

    public Archive stopArchive(String archiveId) throws OpenTokException {
        String archive = this.client.stopArchive(archiveId);
        try {
            return (Archive)archiveReader.readValue(archive);
        }
        catch (Exception e) {
            throw new RequestException("Exception mapping json: " + e.getMessage());
        }
    }

    public void deleteArchive(String archiveId) throws OpenTokException {
        this.client.deleteArchive(archiveId);
    }

    public void close() {
        this.client.close();
    }

    public static class Builder {
        private int apiKey;
        private String apiSecret;
        private String apiUrl;
        private Proxy proxy;
        private HttpClient.ProxyAuthScheme proxyAuthScheme;
        private String principal;
        private String password;

        public Builder(int apiKey, String apiSecret) {
            this.apiKey = apiKey;
            this.apiSecret = apiSecret;
        }

        public Builder apiUrl(String apiUrl) {
            this.apiUrl = apiUrl;
            return this;
        }

        public Builder proxy(Proxy proxy) {
            this.proxy(proxy, null, null, null);
            return this;
        }

        public Builder proxy(Proxy proxy, HttpClient.ProxyAuthScheme proxyAuthScheme, String principal, String password) {
            this.proxy = proxy;
            this.proxyAuthScheme = proxyAuthScheme;
            this.principal = principal;
            this.password = password;
            return this;
        }

        public OpenTok build() {
            HttpClient.Builder clientBuilder = new HttpClient.Builder(this.apiKey, this.apiSecret);
            if (this.apiUrl != null) {
                clientBuilder.apiUrl(this.apiUrl);
            }
            if (this.proxy != null) {
                clientBuilder.proxy(this.proxy, this.proxyAuthScheme, this.principal, this.password);
            }
            return new OpenTok(this.apiKey, this.apiSecret, clientBuilder.build());
        }
    }
}

