/*
 * Decompiled with CFR 0.152.
 */
package com.opentok.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.opentok.ArchiveProperties;
import com.opentok.exception.OpenTokException;
import com.opentok.exception.RequestException;
import com.opentok.util.TokenGenerator;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.asynchttpclient.AsyncHttpClientConfig;
import org.asynchttpclient.BoundRequestBuilder;
import org.asynchttpclient.DefaultAsyncHttpClient;
import org.asynchttpclient.DefaultAsyncHttpClientConfig;
import org.asynchttpclient.ListenableFuture;
import org.asynchttpclient.Realm;
import org.asynchttpclient.RequestBuilder;
import org.asynchttpclient.Response;
import org.asynchttpclient.filter.FilterContext;
import org.asynchttpclient.filter.FilterException;
import org.asynchttpclient.filter.RequestFilter;
import org.asynchttpclient.proxy.ProxyServer;

public class HttpClient
extends DefaultAsyncHttpClient {
    private final String apiUrl;
    private final int apiKey;

    private HttpClient(Builder builder) {
        super(builder.config);
        this.apiKey = builder.apiKey;
        this.apiUrl = builder.apiUrl;
    }

    public String createSession(Map<String, Collection<String>> params) throws RequestException {
        String responseString = null;
        Response response = null;
        HashMap<String, ArrayList<String>> paramsWithList = null;
        if (params != null) {
            paramsWithList = new HashMap<String, ArrayList<String>>();
            for (Map.Entry<String, Collection<String>> entry : params.entrySet()) {
                paramsWithList.put(entry.getKey(), new ArrayList<String>(entry.getValue()));
            }
        }
        ListenableFuture request = ((BoundRequestBuilder)((BoundRequestBuilder)this.preparePost(this.apiUrl + "/session/create").setFormParams(paramsWithList)).addHeader((CharSequence)"Accept", "application/json")).execute();
        try {
            response = (Response)request.get();
            switch (response.getStatusCode()) {
                case 200: {
                    responseString = response.getResponseBody();
                    break;
                }
                default: {
                    throw new RequestException("Could not create an OpenTok Session. The server response was invalid. response code: " + response.getStatusCode());
                }
            }
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RequestException("Could not create an OpenTok Session", e);
        }
        return responseString;
    }

    public String getArchive(String archiveId) throws RequestException {
        String responseString = null;
        String url = this.apiUrl + "/v2/project/" + this.apiKey + "/archive/" + archiveId;
        ListenableFuture request = this.prepareGet(url).execute();
        try {
            Response response = (Response)request.get();
            switch (response.getStatusCode()) {
                case 200: {
                    responseString = response.getResponseBody();
                    break;
                }
                case 400: {
                    throw new RequestException("Could not get an OpenTok Archive. The archiveId was invalid. archiveId: " + archiveId);
                }
                case 403: {
                    throw new RequestException("Could not get an OpenTok Archive. The request was not authorized.");
                }
                case 500: {
                    throw new RequestException("Could not get an OpenTok Archive. A server error occurred.");
                }
                default: {
                    throw new RequestException("Could not get an OpenTok Archive. The server response was invalid. response code: " + response.getStatusCode());
                }
            }
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RequestException("Could not  get an OpenTok Archive", e);
        }
        return responseString;
    }

    public String getArchives(int offset, int count) throws RequestException {
        String responseString = null;
        String url = this.apiUrl + "/v2/project/" + this.apiKey + "/archive";
        if (offset != 0 || count != 1000) {
            url = url + "?";
            if (offset != 0) {
                url = url + "offset=" + Integer.toString(offset) + '&';
            }
            if (count != 1000) {
                url = url + "count=" + Integer.toString(count);
            }
        }
        ListenableFuture request = this.prepareGet(url).execute();
        try {
            Response response = (Response)request.get();
            switch (response.getStatusCode()) {
                case 200: {
                    responseString = response.getResponseBody();
                    break;
                }
                case 403: {
                    throw new RequestException("Could not get OpenTok Archives. The request was not authorized.");
                }
                case 500: {
                    throw new RequestException("Could not get OpenTok Archives. A server error occurred.");
                }
                default: {
                    throw new RequestException("Could not get an OpenTok Archive. The server response was invalid. response code: " + response.getStatusCode());
                }
            }
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RequestException("Could not get OpenTok Archives", e);
        }
        return responseString;
    }

    public String getArchives(String sessionId) throws RequestException {
        String url = this.apiUrl + "/v2/project/" + this.apiKey + "/archive?sessionId=" + sessionId;
        ListenableFuture request = this.prepareGet(url).execute();
        try {
            Response response = (Response)request.get();
            switch (response.getStatusCode()) {
                case 200: {
                    return response.getResponseBody();
                }
                case 403: {
                    throw new RequestException("Could not get OpenTok Archives. The request was not authorized.");
                }
                case 500: {
                    throw new RequestException("Could not get OpenTok Archives. A server error occurred.");
                }
            }
            throw new RequestException("Could not get an OpenTok Archive. The server response was invalid. response code: " + response.getStatusCode());
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RequestException("Could not get OpenTok Archives", e);
        }
    }

    public String startArchive(String sessionId, ArchiveProperties properties) throws OpenTokException {
        String responseString = null;
        String requestBody = null;
        String url = this.apiUrl + "/v2/project/" + this.apiKey + "/archive";
        JsonNodeFactory nodeFactory = JsonNodeFactory.instance;
        ObjectNode requestJson = nodeFactory.objectNode();
        requestJson.put("sessionId", sessionId);
        requestJson.put("hasVideo", properties.hasVideo());
        requestJson.put("hasAudio", properties.hasAudio());
        requestJson.put("outputMode", properties.outputMode().toString());
        if (properties.name() != null) {
            requestJson.put("name", properties.name());
        }
        try {
            requestBody = new ObjectMapper().writeValueAsString((Object)requestJson);
        }
        catch (JsonProcessingException e) {
            throw new OpenTokException("Could not start an OpenTok Archive. The JSON body encoding failed.", e);
        }
        ListenableFuture request = ((BoundRequestBuilder)((BoundRequestBuilder)this.preparePost(url).setBody(requestBody)).setHeader((CharSequence)"Content-Type", "application/json")).execute();
        try {
            Response response = (Response)request.get();
            switch (response.getStatusCode()) {
                case 200: {
                    responseString = response.getResponseBody();
                    break;
                }
                case 403: {
                    throw new RequestException("Could not start an OpenTok Archive. The request was not authorized.");
                }
                case 404: {
                    throw new RequestException("Could not start an OpenTok Archive. The sessionId does not exist. sessionId = " + sessionId);
                }
                case 409: {
                    throw new RequestException("Could not start an OpenTok Archive. The session is either peer-to-peer or already recording. sessionId = " + sessionId);
                }
                case 500: {
                    throw new RequestException("Could not start an OpenTok Archive. A server error occurred.");
                }
                default: {
                    throw new RequestException("Could not start an OpenTok Archive. The server response was invalid. response code: " + response.getStatusCode());
                }
            }
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RequestException("Could not start an OpenTok Archive.", e);
        }
        return responseString;
    }

    public String stopArchive(String archiveId) throws RequestException {
        String responseString = null;
        String url = this.apiUrl + "/v2/project/" + this.apiKey + "/archive/" + archiveId + "/stop";
        ListenableFuture request = this.preparePost(url).execute();
        try {
            Response response = (Response)request.get();
            switch (response.getStatusCode()) {
                case 200: {
                    responseString = response.getResponseBody();
                    break;
                }
                case 400: {
                    throw new RequestException("Could not stop an OpenTok Archive.");
                }
                case 403: {
                    throw new RequestException("Could not stop an OpenTok Archive. The request was not authorized.");
                }
                case 404: {
                    throw new RequestException("Could not stop an OpenTok Archive. The archiveId does not exist. archiveId = " + archiveId);
                }
                case 409: {
                    throw new RequestException("Could not stop an OpenTok Archive. The archive is not being recorded. archiveId = " + archiveId);
                }
                case 500: {
                    throw new RequestException("Could not stop an OpenTok Archive. A server error occurred.");
                }
                default: {
                    throw new RequestException("Could not stop an OpenTok Archive. The server response was invalid. response code: " + response.getStatusCode());
                }
            }
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RequestException("Could not stop an OpenTok Archive.", e);
        }
        return responseString;
    }

    public String deleteArchive(String archiveId) throws RequestException {
        String responseString = null;
        String url = this.apiUrl + "/v2/project/" + this.apiKey + "/archive/" + archiveId;
        ListenableFuture request = this.prepareDelete(url).execute();
        try {
            Response response = (Response)request.get();
            switch (response.getStatusCode()) {
                case 204: {
                    responseString = response.getResponseBody();
                    break;
                }
                case 403: {
                    throw new RequestException("Could not delete an OpenTok Archive. The request was not authorized.");
                }
                case 409: {
                    throw new RequestException("Could not delete an OpenTok Archive. The status was not \"uploaded\", \"available\", or \"deleted\". archiveId = " + archiveId);
                }
                case 500: {
                    throw new RequestException("Could not delete an OpenTok Archive. A server error occurred.");
                }
                default: {
                    throw new RequestException("Could not get an OpenTok Archive. The server response was invalid. response code: " + response.getStatusCode());
                }
            }
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RequestException("Could not delete an OpenTok Archive. archiveId = " + archiveId, e);
        }
        return responseString;
    }

    static class TokenAuthRequestFilter
    implements RequestFilter {
        private final int apiKey;
        private final String apiSecret;
        private final String authHeader = "X-OPENTOK-AUTH";

        public TokenAuthRequestFilter(int apiKey, String apiSecret) {
            this.apiKey = apiKey;
            this.apiSecret = apiSecret;
        }

        public <T> FilterContext<T> filter(FilterContext<T> ctx) throws FilterException {
            try {
                return new FilterContext.FilterContextBuilder(ctx).request(((RequestBuilder)new RequestBuilder(ctx.getRequest()).addHeader((CharSequence)"X-OPENTOK-AUTH", TokenGenerator.generateToken(this.apiKey, this.apiSecret))).build()).build();
            }
            catch (OpenTokException e) {
                e.printStackTrace();
                return null;
            }
        }
    }

    public static class Builder {
        private final int apiKey;
        private final String apiSecret;
        private Proxy proxy;
        private ProxyAuthScheme proxyAuthScheme;
        private String principal;
        private String password;
        private String apiUrl;
        private AsyncHttpClientConfig config;

        public Builder(int apiKey, String apiSecret) {
            this.apiKey = apiKey;
            this.apiSecret = apiSecret;
        }

        public Builder apiUrl(String apiUrl) {
            this.apiUrl = apiUrl;
            return this;
        }

        public Builder proxy(Proxy proxy) {
            this.proxy(proxy, null, null, null);
            return this;
        }

        public Builder proxy(Proxy proxy, ProxyAuthScheme proxyAuthScheme, String principal, String password) {
            this.proxy = proxy;
            this.proxyAuthScheme = proxyAuthScheme;
            this.principal = principal;
            this.password = password;
            return this;
        }

        public HttpClient build() {
            DefaultAsyncHttpClientConfig.Builder configBuilder = new DefaultAsyncHttpClientConfig.Builder().setUserAgent("Opentok-Java-SDK/4.0.0 JRE/" + System.getProperty("java.version")).addRequestFilter((RequestFilter)new TokenAuthRequestFilter(this.apiKey, this.apiSecret));
            if (this.apiUrl == null) {
                this.apiUrl = "https://api.opentok.com";
            }
            if (this.proxy != null) {
                configBuilder.setProxyServer(Builder.createProxyServer(this.proxy, this.proxyAuthScheme, this.principal, this.password));
            }
            this.config = configBuilder.build();
            HttpClient client = new HttpClient(this);
            return client;
        }

        static ProxyServer createProxyServer(Proxy proxy, ProxyAuthScheme proxyAuthScheme, String principal, String password) {
            switch (proxy.type()) {
                case DIRECT: {
                    return null;
                }
                case SOCKS: {
                    throw new IllegalArgumentException("Only DIRECT and HTTP Proxies are supported!");
                }
            }
            SocketAddress sa = proxy.address();
            if (!(sa instanceof InetSocketAddress)) {
                throw new IllegalArgumentException("Only Internet Address sockets are supported!");
            }
            InetSocketAddress isa = (InetSocketAddress)sa;
            String isaHost = isa.isUnresolved() ? isa.getHostName() : isa.getAddress().getHostAddress();
            ProxyServer.Builder builder = new ProxyServer.Builder(isaHost, isa.getPort());
            if (principal != null) {
                Realm.AuthScheme authScheme = null;
                switch (proxyAuthScheme) {
                    case BASIC: {
                        authScheme = Realm.AuthScheme.BASIC;
                        break;
                    }
                    case DIGEST: {
                        authScheme = Realm.AuthScheme.DIGEST;
                        break;
                    }
                    case NTLM: {
                        authScheme = Realm.AuthScheme.NTLM;
                        break;
                    }
                    case KERBEROS: {
                        authScheme = Realm.AuthScheme.KERBEROS;
                        break;
                    }
                    case SPNEGO: {
                        authScheme = Realm.AuthScheme.SPNEGO;
                    }
                }
                Realm.Builder rb = new Realm.Builder(principal, password);
                rb.setScheme(authScheme);
                builder.setRealm(rb.build());
            }
            return builder.build();
        }
    }

    public static enum ProxyAuthScheme {
        BASIC,
        DIGEST,
        NTLM,
        SPNEGO,
        KERBEROS;

    }
}

