/*
 * Decompiled with CFR 0.152.
 */
package com.opentok;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.opentok.Rtmp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Broadcast {
    @JsonProperty
    private String id;
    @JsonProperty
    private String sessionId;
    @JsonProperty
    private int projectId;
    @JsonProperty
    private long createdAt;
    @JsonProperty
    private long updatedAt;
    @JsonProperty
    private String resolution;
    @JsonProperty
    private String status;
    private List<Rtmp> rtmpList = new ArrayList<Rtmp>();
    private String hls;

    protected Broadcast() {
    }

    @JsonCreator
    public static Broadcast makeBroadcast() {
        return new Broadcast();
    }

    public String getId() {
        return this.id;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public int getProjectId() {
        return this.projectId;
    }

    public long getCreatedAt() {
        return this.createdAt;
    }

    public long getUpdatedAt() {
        return this.updatedAt;
    }

    public String getResolution() {
        return this.resolution;
    }

    public String getStatus() {
        return this.status;
    }

    @JsonProperty(value="broadcastUrls")
    private void unpack(Map<String, Object> broadcastUrls) {
        if (broadcastUrls == null) {
            return;
        }
        this.hls = (String)broadcastUrls.get("hls");
        ArrayList rtmpResponse = (ArrayList)broadcastUrls.get("rtmp");
        if (rtmpResponse == null || rtmpResponse.size() == 0) {
            return;
        }
        for (Map element : rtmpResponse) {
            Rtmp rtmp = new Rtmp();
            rtmp.setId((String)element.get("id"));
            rtmp.setServerUrl((String)element.get("serverUrl"));
            rtmp.setStreamName((String)element.get("streamName"));
            this.rtmpList.add(rtmp);
        }
    }

    public String getHls() {
        return this.hls;
    }

    public List<Rtmp> getRtmpList() {
        return this.rtmpList;
    }

    public String toString() {
        try {
            return new ObjectMapper().writeValueAsString((Object)this);
        }
        catch (Exception e) {
            return "";
        }
    }
}

