/*
 * Decompiled with CFR 0.152.
 */
package com.opentok;

import com.opentok.ArchiveLayout;
import com.opentok.BroadcastLayout;
import com.opentok.RtmpProperties;
import com.opentok.exception.InvalidArgumentException;
import java.util.ArrayList;
import java.util.List;

public class BroadcastProperties {
    private BroadcastLayout layout;
    private int maxDuration;
    private boolean hasHls;
    private List<RtmpProperties> rtmpList;
    private String resolution = null;

    private BroadcastProperties(Builder builder) {
        this.layout = builder.layout;
        this.maxDuration = builder.maxDuration;
        this.hasHls = builder.hasHls;
        this.rtmpList = builder.rtmpList;
        this.resolution = builder.resolution;
    }

    public BroadcastLayout layout() {
        return this.layout;
    }

    public int maxDuration() {
        return this.maxDuration;
    }

    public boolean hasHls() {
        return this.hasHls;
    }

    public List<RtmpProperties> getRtmpList() {
        return this.rtmpList;
    }

    public String resolution() {
        return this.resolution;
    }

    public static class Builder {
        private BroadcastLayout layout = new BroadcastLayout(ArchiveLayout.Type.BESTFIT);
        private int maxDuration = 7200;
        private boolean hasHls = false;
        private List<RtmpProperties> rtmpList = new ArrayList<RtmpProperties>();
        private String resolution = "640x480";

        public Builder layout(BroadcastLayout layout) {
            this.layout = layout;
            return this;
        }

        public Builder maxDuration(int maxDuration) throws InvalidArgumentException {
            if (maxDuration < 60 || maxDuration > 36000) {
                throw new InvalidArgumentException("maxDuration value must be between 60 and 36000 (inclusive).");
            }
            this.maxDuration = maxDuration;
            return this;
        }

        public Builder hasHls(boolean hasHls) {
            this.hasHls = hasHls;
            return this;
        }

        public Builder addRtmpProperties(RtmpProperties rtmpProps) throws InvalidArgumentException {
            if (this.rtmpList.size() >= 5) {
                throw new InvalidArgumentException("Cannot add more than 5 RtmpProperties properties");
            }
            this.rtmpList.add(rtmpProps);
            return this;
        }

        public Builder resolution(String resolution) {
            this.resolution = resolution;
            return this;
        }

        public BroadcastProperties build() {
            return new BroadcastProperties(this);
        }
    }
}

