/*
 * Decompiled with CFR 0.152.
 */
package com.opentok;

import com.opentok.Role;
import com.opentok.SessionProperties;
import com.opentok.TokenOptions;
import com.opentok.exception.InvalidArgumentException;
import com.opentok.exception.OpenTokException;
import com.opentok.util.Crypto;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.util.Random;
import java.util.stream.Collectors;
import org.apache.commons.codec.binary.Base64;

public class Session {
    private String sessionId;
    private int apiKey;
    private String apiSecret;
    private SessionProperties properties;

    protected Session(String sessionId, int apiKey, String apiSecret) {
        this.sessionId = sessionId;
        this.apiKey = apiKey;
        this.apiSecret = apiSecret;
        this.properties = new SessionProperties.Builder().build();
    }

    protected Session(String sessionId, int apiKey, String apiSecret, SessionProperties properties) {
        this.sessionId = sessionId;
        this.apiKey = apiKey;
        this.apiSecret = apiSecret;
        this.properties = properties;
    }

    public int getApiKey() {
        return this.apiKey;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public SessionProperties getProperties() {
        return this.properties;
    }

    public String generateToken() throws OpenTokException {
        return this.generateToken(new TokenOptions.Builder().build());
    }

    public String generateToken(TokenOptions tokenOptions) throws OpenTokException {
        if (tokenOptions == null) {
            throw new InvalidArgumentException("Token options cannot be null");
        }
        Role role = tokenOptions.getRole();
        double expireTime = tokenOptions.getExpireTime();
        String data = tokenOptions.getData();
        Long create_time = (long)new Long(System.currentTimeMillis() / 1000L);
        StringBuilder dataStringBuilder = new StringBuilder();
        Random random = new Random();
        int nonce = random.nextInt();
        dataStringBuilder.append("session_id=");
        dataStringBuilder.append(this.sessionId);
        dataStringBuilder.append("&create_time=");
        dataStringBuilder.append(create_time);
        dataStringBuilder.append("&nonce=");
        dataStringBuilder.append(nonce);
        dataStringBuilder.append("&role=");
        dataStringBuilder.append((Object)role);
        if (tokenOptions.getInitialLayoutClassList() != null) {
            dataStringBuilder.append("&initial_layout_class_list=");
            dataStringBuilder.append(tokenOptions.getInitialLayoutClassList().stream().collect(Collectors.joining(" ")));
        }
        double now = System.currentTimeMillis() / 1000L;
        if (expireTime == 0.0) {
            expireTime = now + 86400.0;
        } else {
            if (expireTime < now - 1.0) {
                throw new InvalidArgumentException("Expire time must be in the future. relative time: " + (expireTime - now));
            }
            if (expireTime > now + 2592000.0) {
                throw new InvalidArgumentException("Expire time must be in the next 30 days. too large by " + (expireTime - (now + 2592000.0)));
            }
        }
        dataStringBuilder.append(String.format("&expire_time=%.0f", expireTime));
        if (data != null) {
            if (data.length() > 1000) {
                throw new InvalidArgumentException("Connection data must be less than 1000 characters. length: " + data.length());
            }
            dataStringBuilder.append("&connection_data=");
            try {
                dataStringBuilder.append(URLEncoder.encode(data, "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new InvalidArgumentException("Error during URL encode of your connection data: " + e.getMessage());
            }
        }
        StringBuilder tokenStringBuilder = new StringBuilder();
        try {
            tokenStringBuilder.append("T1==");
            StringBuilder innerBuilder = new StringBuilder();
            innerBuilder.append("partner_id=");
            innerBuilder.append(this.apiKey);
            innerBuilder.append("&sig=");
            innerBuilder.append(Crypto.signData(dataStringBuilder.toString(), this.apiSecret));
            innerBuilder.append(":");
            innerBuilder.append(dataStringBuilder.toString());
            tokenStringBuilder.append(Base64.encodeBase64String((byte[])innerBuilder.toString().getBytes("UTF-8")).replace("+", "-").replace("/", "_"));
        }
        catch (UnsupportedEncodingException | InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
            throw new OpenTokException("Could not generate token, a signing error occurred.", e);
        }
        return tokenStringBuilder.toString();
    }
}

