/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.image;

import com.twelvemonkeys.image.BufferedImageIcon;
import com.twelvemonkeys.image.ImageUtil;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.RasterOp;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;

public class AreaAverageOp
implements BufferedImageOp,
RasterOp {
    private final int mWidth;
    private final int mHeight;
    private Rectangle mSourceRegion;

    public AreaAverageOp(int pWidth, int pHeight) {
        this.mWidth = pWidth;
        this.mHeight = pHeight;
    }

    public Rectangle getSourceRegion() {
        if (this.mSourceRegion == null) {
            return null;
        }
        return new Rectangle(this.mSourceRegion);
    }

    public void setSourceRegion(Rectangle pSourceRegion) {
        if (pSourceRegion == null) {
            this.mSourceRegion = null;
        } else if (this.mSourceRegion == null) {
            this.mSourceRegion = new Rectangle(pSourceRegion);
        } else {
            this.mSourceRegion.setBounds(pSourceRegion);
        }
    }

    public BufferedImage filter(BufferedImage src, BufferedImage dest) {
        BufferedImage result = dest != null ? dest : this.createCompatibleDestImage(src, null);
        long start = System.currentTimeMillis();
        this.filterImpl(src.getRaster(), result.getRaster());
        long time = System.currentTimeMillis() - start;
        System.out.println("time: " + time);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resample(BufferedImage pSrc, BufferedImage pDest, AffineTransform pXform) {
        Graphics2D d = pDest.createGraphics();
        d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        try {
            d.drawImage(pSrc, pXform, null);
        }
        finally {
            d.dispose();
        }
    }

    public WritableRaster filter(Raster src, WritableRaster dest) {
        WritableRaster result = dest != null ? dest : this.createCompatibleDestRaster(src);
        return this.filterImpl(src, result);
    }

    private WritableRaster filterImpl(Raster src, WritableRaster dest) {
        if (this.mSourceRegion != null) {
            int cx = this.mSourceRegion.x;
            int cy = this.mSourceRegion.y;
            int cw = this.mSourceRegion.width;
            int ch = this.mSourceRegion.height;
            boolean same = src == dest;
            dest = dest.createWritableChild(cx, cy, cw, ch, 0, 0, null);
            src = same ? dest : src.createChild(cx, cy, cw, ch, 0, 0, null);
        }
        int width = src.getWidth();
        int height = src.getHeight();
        int widthSteps = (width + this.mWidth - 1) / this.mWidth;
        int heightSteps = (height + this.mHeight - 1) / this.mHeight;
        boolean oddX = width % this.mWidth != 0;
        boolean oddY = height % this.mHeight != 0;
        int dataElements = src.getNumDataElements();
        int bands = src.getNumBands();
        int dataType = src.getTransferType();
        Object data = null;
        int[] bitMasks = null;
        int[] bitOffsets = null;
        if (src.getTransferType() == 1) {
            if (src.getSampleModel() instanceof SinglePixelPackedSampleModel) {
                SinglePixelPackedSampleModel sampleModel = (SinglePixelPackedSampleModel)src.getSampleModel();
                bitMasks = sampleModel.getBitMasks();
                bitOffsets = sampleModel.getBitOffsets();
            } else {
                bitMasks = new int[]{65535};
                bitOffsets = new int[]{0};
            }
        }
        for (int y = 0; y < this.mHeight; ++y) {
            int scanH = !oddY || y < this.mHeight ? heightSteps : height - y * heightSteps;
            for (int x = 0; x < this.mWidth; ++x) {
                int scanW = !oddX || x < this.mWidth ? widthSteps : width - x * widthSteps;
                int pixelCount = scanW * scanH;
                int pixelLength = pixelCount * dataElements;
                try {
                    data = src.getDataElements(x * widthSteps, y * heightSteps, scanW, scanH, data);
                }
                catch (IndexOutOfBoundsException e) {
                    continue;
                }
                double valueA = 0.0;
                double valueR = 0.0;
                double valueG = 0.0;
                double valueB = 0.0;
                switch (dataType) {
                    case 0: {
                        byte[] bytePixels = (byte[])data;
                        for (int i = 0; i < pixelLength; i += dataElements) {
                            valueA += (double)(bytePixels[i] & 0xFF);
                            if (bands <= 1) continue;
                            valueR += (double)(bytePixels[i + 1] & 0xFF);
                            valueG += (double)(bytePixels[i + 2] & 0xFF);
                            if (bands <= 3) continue;
                            valueB += (double)(bytePixels[i + 3] & 0xFF);
                        }
                        valueA /= (double)pixelCount;
                        if (bands > 1) {
                            valueR /= (double)pixelCount;
                            valueG /= (double)pixelCount;
                            if (bands > 3) {
                                valueB /= (double)pixelCount;
                            }
                        }
                        bytePixels[0] = (byte)AreaAverageOp.clamp((int)valueA);
                        if (bands <= 1) break;
                        bytePixels[1] = (byte)AreaAverageOp.clamp((int)valueR);
                        bytePixels[2] = (byte)AreaAverageOp.clamp((int)valueG);
                        if (bands <= 3) break;
                        bytePixels[3] = (byte)AreaAverageOp.clamp((int)valueB);
                        break;
                    }
                    case 3: {
                        int[] intPixels = (int[])data;
                        for (int i = 0; i < pixelLength; i += dataElements) {
                            valueA += (double)((intPixels[i] & 0xFF000000) >> 24);
                            valueR += (double)((intPixels[i] & 0xFF0000) >> 16);
                            valueG += (double)((intPixels[i] & 0xFF00) >> 8);
                            valueB += (double)(intPixels[i] & 0xFF);
                        }
                        intPixels[0] = AreaAverageOp.clamp((int)(valueA /= (double)pixelCount)) << 24;
                        intPixels[0] = intPixels[0] | AreaAverageOp.clamp((int)(valueR /= (double)pixelCount)) << 16;
                        intPixels[0] = intPixels[0] | AreaAverageOp.clamp((int)(valueG /= (double)pixelCount)) << 8;
                        intPixels[0] = intPixels[0] | AreaAverageOp.clamp((int)(valueB /= (double)pixelCount));
                        break;
                    }
                    case 1: {
                        if (bitMasks != null) {
                            short[] shortPixels = (short[])data;
                            for (int i = 0; i < pixelLength; i += dataElements) {
                                valueA += (double)((shortPixels[i] & bitMasks[0]) >> bitOffsets[0]);
                                if (bitMasks.length <= 1) continue;
                                valueR += (double)((shortPixels[i] & bitMasks[1]) >> bitOffsets[1]);
                                valueG += (double)((shortPixels[i] & bitMasks[2]) >> bitOffsets[2]);
                                if (bitMasks.length <= 3) continue;
                                valueB += (double)((shortPixels[i] & bitMasks[3]) >> bitOffsets[3]);
                            }
                            valueR /= (double)pixelCount;
                            valueG /= (double)pixelCount;
                            valueB /= (double)pixelCount;
                            shortPixels[0] = (short)((int)(valueA /= (double)pixelCount) << bitOffsets[0] & bitMasks[0]);
                            if (bitMasks.length <= 1) break;
                            shortPixels[0] = (short)(shortPixels[0] | (short)((int)valueR << bitOffsets[1] & bitMasks[1]));
                            shortPixels[0] = (short)(shortPixels[0] | (short)((int)valueG << bitOffsets[2] & bitMasks[2]));
                            if (bitMasks.length <= 3) break;
                            shortPixels[0] = (short)(shortPixels[0] | (short)((int)valueB << bitOffsets[3] & bitMasks[3]));
                            break;
                        }
                    }
                    default: {
                        throw new IllegalArgumentException("TransferType not supported: " + dataType);
                    }
                }
                dest.setDataElements(x, y, 1, 1, data);
            }
        }
        return dest;
    }

    private static int clamp(int pValue) {
        return pValue > 255 ? 255 : pValue;
    }

    public RenderingHints getRenderingHints() {
        return null;
    }

    public BufferedImage createCompatibleDestImage(BufferedImage src, ColorModel destCM) {
        ColorModel cm = destCM != null ? destCM : src.getColorModel();
        return new BufferedImage(cm, ImageUtil.createCompatibleWritableRaster(src, cm, this.mWidth, this.mHeight), cm.isAlphaPremultiplied(), null);
    }

    public WritableRaster createCompatibleDestRaster(Raster src) {
        return src.createCompatibleWritableRaster(this.mWidth, this.mHeight);
    }

    public Rectangle2D getBounds2D(Raster src) {
        return new Rectangle(this.mWidth, this.mHeight);
    }

    public Rectangle2D getBounds2D(BufferedImage src) {
        return new Rectangle(this.mWidth, this.mHeight);
    }

    public Point2D getPoint2D(Point2D srcPt, Point2D dstPt) {
        if (dstPt == null) {
            dstPt = srcPt instanceof Point2D.Double ? new Point2D.Double() : new Point2D.Float();
        }
        dstPt.setLocation(srcPt);
        return dstPt;
    }

    public static void main(String[] pArgs) throws IOException {
        BufferedImage image = ImageIO.read(new File("2006-Lamborghini-Gallardo-Spyder-Y-T-1600x1200.png"));
        for (int i = 0; i < 100; ++i) {
        }
        long start = System.currentTimeMillis();
        image = new AreaAverageOp(500, 600).filter(image, null);
        long time = System.currentTimeMillis() - start;
        System.out.println("time: " + time + " ms");
        JFrame frame = new JFrame("Test");
        frame.setDefaultCloseOperation(3);
        frame.setContentPane(new JScrollPane(new JLabel(new BufferedImageIcon(image))));
        frame.pack();
        frame.setVisible(true);
    }
}

